#include "param.h"
#include "err.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "ftn.h"
#include "tree.h"
#include "char.h"
/*			Copyright 1977 by Bill Webb.	 		*/

int uflg;
int iflg 1;		/* defaults to inhibit link on any error */
int arflg;		/* 1 if archive is to be produced */
int symalloc;
int objdes;
int armagic;

main(argc,argv) char **argv;
{
extern fin;
extern fout;
extern v7;
register int cnt;
register char *p;

v7 = argv[argc] == 0;
cnt = 0;
init();
--argc;
++argv;

while (--argc >= 0)
	{
	argp = *argv++;
	if (argp[0] == '-')
		{
		for (p= ++argp; *p; ++p)
			if (*p >= 'A' && *p <= 'Z')
				*p =- 'A'-'a';		/* insure lc */
		if (*argp == '-')
			++argp;
		switch (argp[0])
			{
		case 'i':		/* inhibit link on any error */
			iflg = !iflg;
			break;
		case 'n':		/* no object code */
			++nflg;
			break;
		case 'e':		/* extend source statement length */
			++eflg;
			break;
		case 'w':		/* ignore warnings */
			++wflg;
			break;
		case 'u':		/* undefined vars */
			++uflg;
			break;
		case 'o':		/* options */
			switch(argp[1])
				{
			case 'a':		/* change allocation size */
				symalloc =>> 1;		/* use half */
				break;
			case 'b':	/* abort on error */
				++abflg;
				break;
			case 'c':	/* C interface code */
				++acflg;
				break;
			case 's':		/* generate symbol table for fdb */
				++sflg;
				break;
			case 'd':		/* force declarations */
				++dclflg;
				break;
			case 'p':
				++pflg;
				break;
			case 'o':		/* old library format */
				armagic = OLDARMAGIC;
				++arflg;
				break;

			case 'n':		/* new archive format */
				armagic = NEWARMAGIC;
				++arflg;
				break;

			default:
				goto badopt;
				}
			break;
		case 's':			/* sequence numbering */
			if (argp[1] == 'l')
				++slflg;	/* source line #'s */
			else
				seqflg = !seqflg;
			break;
		case 'q':
			++qflg;			/* remember special */
			symalloc = 1024;	/* default to small alloc */
			fout = 1;
			++mflg;
			++cflg;
			++pflg;
			++lflg;
			break;
		case 'a':			/* force statistics */
			++aflg;			/* statistics stuff */
			break;
		case 'm':			/* map */
			++mflg;
			break;
		case 'p':			/* profile */
			++prflg;
			break;
		case 'c':			/* check subscripts */
			++chkflg;
			break;
		case 'l':			/* list options */
			p = argp[1];
			if(p&1)
				++lflg;
			if(p&2)
				++mflg;
			if(p&4)
				++cflg;
			if(p == 0)
				++lflg;
			break;
		case 't':			/* trace on */
			++tflg;
			break;
		case 'd':
			++dflg;
			break;
		default:
		badopt:
			printf("bad option %s\n",argp);
			}
		continue;
		}
	if(!lflg)
		printf("%s:\n",argp);
	hflg =+ lflg+mflg+cflg+pflg;		/* give heading if we give anything */
	aflg =+ hflg;		/* give stats if we give heading */
	goteof = 0;
	srcline = line = 0;
	if(fin > 0)
		close(fin);
	if (fopen(argp,&fin) < 0)
		ERROR1("can't open %s",E_OPEN,argp);
	++cnt;
	while (!goteof)
		compile();
	if(objdes)
		objclose();
	}
argp = 0;
if (cnt == 0)
	while (!goteof)
		compile();
flush();
exit(rc);
}

init()
{
register char *p;
extern fout;
int fpterr();

initpr();
fout = dup(1);
textbeg = sbrk(0)+WRITEHDR;
settype(0,MAXCHAR-1,INVALID);
settype('a','z',ALPHA);
settype('A','Z',UPPER);
settype('0','9',DIGIT);

chtype['\r'] = chtype[BLANK] = chtype[TAB] = IGNORE;	/* set blank and tab type */
for (p="?@&.+-*'/,=():"; *p; ++p)
	chtype[*p] = OTHER;
ldfps(05600);		/* load fpt status */
signal(8,&fpterr);
}

settype(min,max,code)
{
register int i;

for (i=min; i<=max; ++i)
	chtype[i] = code;
}
