#include "param.h"
/*			Copyright 1979 by Bill Webb.	 		*/
#include "err.h"
#include "ftn.h"
/*			Copyright 1977 by Bill Webb.	 		*/
#include "ops.h"
#include "tree.h"
#include "sym.h"
#include "char.h"

char *rclist;		/* list of return labels */
char modenames[];

struct proto relops[]
{
"eq.",	EQ_OP,
"ne.",	NE_OP,
"gt.",	GT_OP,
"ge.",	GE_OP,
"lt.",	LT_OP,
"le.",	LE_OP,
"or.",	OR_OP,
"and.",	AND_OP,
"eqv.",		EQV_OP,
"neqv.",	XOR_OP,
"xor.",		XOR_OP,
0, 0 };

char prio[]
/*
 *    +   -   *   /  **   &   |  ==   !=  >  >=   < <= eqv xor //
 */
{ 00, 70, 70, 80, 80, 90, 40, 30, 50, 50, 50, 50, 50, 50, 10, 20, 60 };

item(type)
{
/*
 * an item is a basic expression element, mainly different
 * types of operands.
 */
register int c;
register int i;
register char *s;		/* save starting position */

s = inptr;
c = *inptr;
if (chartype(c) == ALPHA)
	return(varexpr(type));	/* variable, fn, subscript etc. */
if (type == LEFT)
	noexpr();
if (chartype(c) == DIGIT)
	return(const());
if ((c == '+' || c == '-') && (chartype(inptr[1]) == DIGIT || inptr[1] == '.'))
	return(const());
++inptr;		/* consume the character */
switch(c)
	{
case '+':
case '-':
	if (chartype(inptr[1]) == DIGIT)
		return(const());
	break;
case QUOTE:
	--inptr;		/* back up before ' */
	return(sconst());
case '.':
	if (teststr("not."))	/* unary .not. */
		return(unary(NOT_OP,item(RIGHT)));
	--inptr;
	return(const());		/* get constant */
case '(':			/* parenthesized expr */
	i = expr(RIGHT);
	if (*inptr == COMMA)
		{
		inptr = s;
		return(cmplxconst());
		}
	expect(")");
	return(i);
	}
--inptr;		/* back up for rescan */
ERR("bad expression",E_BADEXP);
}

chkbool(m)
{
if (isbool[m])
	return;
ERR("boolean mode required",E_BOOL);
}

chkarith(m)
{
if (arithmode[m])
	return;
ERR("arithmetic mode required",E_ARITH);
}

expr(type)
{
/*
 * get an expression. essential part of this routine is the table "prio"
 * which gives operator priorities. operators and operands are picked 
 * up and stacked until an operator is found that is lower than the top of
 * the stack. the top of the stack is then evaluated.
 * "type" is the type of operand expected. its is either
 *
 * RIGHT	a "right" hand value
 * LEFT		a "left" hand value (left of an assignment)
 * MIDDLE	an argument to a function.
 */
#define	MAXSTK	20
char opstk[MAXSTK];
char *argstk[MAXSTK];
register int s;
register int op;
register int m;

s = 0;
opstk[0] = NO_OP;
if (*inptr == '+' || *inptr == '-')
	argstk[0] = iconst(0,INT2);
else
	argstk[0] = expritem(type);

for (;;)
	{
	op = getop();
	for (;;)
		{
		if (prio[opstk[s]] == prio[op])
			if (op == EXP_OP)	/* right associative */
				goto push;
			else
				goto pop;
		if (prio[opstk[s]] > prio[op])
			{ pop:
			/*
			 * stack top operator is higher prio than "op"
			 * i.e. { ... * :: + 
			 * so evaluate it and try again.
			 */
			if (s)
				{
				if (type == LEFT)
					noexpr();
				argstk[s-1] =
					diadic(opstk[s],argstk[s-1],argstk[s]);
				--s;
				}
			else
				return(argstk[0]);
			}
		else
			{ push:		/* save new operator */
			/*
			 * stack top operator is lower prio than "op"
			 * so stack "op" and get the next operator.
			 */
			if (++s > MAXSTK)
				ERR("expression stack overflow",E_STACK);
			opstk[s] = op;
			argstk[s] = expritem(RIGHT);
			break;
			}
		}
	}
}

expritem(type)
{
/*
 * get an item of the requested type. if type!=middle and the
 * item is a string then convert it to a str_op to insure that
 * the length is properly handled.
 */
register char *s;

s = item(type);
if (s->s_type == STRING)
	if (type != MIDDLE && (INSYM(s) || s->t_op == SBA_OP || s->t_op == SBV_OP || s->t_op == SYM_OP))
		s = mnode(STR_OP,s->s_type,s,NULL);
return(s);
}

getop()
{
/*
 * pick up an operator.
 * the only complications are:
 * 1. **
 * 2. .op. (relational and logical operators.
 */
register int c;
register struct proto *p;

switch(c = *inptr++)
	{
case '+':
	return(ADD_OP);
case '-':
	return(SUB_OP);
case '*':
	if (*inptr == '*')
		{
		++inptr;
		return(EXP_OP);
		}
	return(MUL_OP);
case '/':
	if(*inptr == '/')
		{
		++inptr;
		return(CAT_OP);
		}
	return(DIV_OP);
case '.':
	for (p=relops; p->p_name; ++p)
		if (teststr(p->p_name))
			return(p->p_type);
	break;
case ':':
case '=':
case ',':
case AT:
case 0:
case ')':
	--inptr;		/* back up */
	return(NO_OP);
	}
ERR("bad/missing operator",E_OP);
}

const()
{
/*
 * get a constant and return it's mode. 
 */
register int c;

c = *inptr;
if (c == QUOTE)
	return(sconst());
if (c == LPAR)
	return(cmplxconst());
if (c == '.')
	{
	if (teststr(".true."))
		return(iconst(-1,LOG2));
	if (teststr(".false."))
		return(iconst(0,LOG2));
	}
return(nconst());		/* convert numeric constant */
}

varexpr(type)
{
/*
 * pick up anything beginning with a variable name:
 * name
 * name(sub list)
 * name(par list)
 * type indicates what sort of an item is allowed.
 */
register int s;
register int op;
register char *p;

getvar();
if (sym_loc == CONST && type==LEFT)
	noexpr();
s = cur_sym;
if (optc(LPAR))
	{
	if (sym_nsubs == 0)
		{
		if (colon())
			return(substring(s));
		else
			return(fnexpr(type));	/* return a function */
		}
	else
		{
		p = subscvar(type);	/* subscripted variable */
		if (optc(LPAR))
			p = substring(p);
		return(p);
		}
	}
if (type != MIDDLE)
	{
	if (sym_flags&F_FN)
		SERR("requires arguments",E_ARGS);
	if (type!=IOARG && sym_nsubs)
		SERR("requires subscripts",E_SUBS);
	}
if(sym_loc == NOLOC)
	s->s_loc = LOCAL;	/* allocate to local region */
return(s);
}


treeplist(fn)
{
register char *t;

expect("(");
t = treelist(fn);
expect(")");
return(t);
}

treelist(fn) int (*fn)();
{
/*
 * get a list of fn's, and return tree of them.
 */
register struct node *t, *n;
register char *l;
int i;

i = 0;
t = NULL;
if (*inptr && *inptr != ')')
	do
		{
		if (optc(COMMA))
			{
			WARNING("extra comma ignored",E_COMMA);
			++inptr;
			continue;
			}
		if (n = (*fn)())
			{
			n = node(COMMA_OP,n,NULL);
			++i;
			if (t == NULL)
				t = n;
			else
				l->t_right = n;
			l = n;
			}
		}
	while (testc(COMMA));
listcnt = i;
return(t);
}

pexpr()
{
/*
 * get an actual argument for a function or subroutine call.
 * this is the only expression that allows arrays or functions
 * by themselves.
 * generate a temporary of appropriate type for expressions.
 */
register char *t;
register char *s;
register int l;

t = expr(MIDDLE);
if (!INSYM(t) && t->t_op != SBA_OP && t->t_op != SYM_OP)
	{
	s = gentemp(t->t_type);
	if (s->s_type == STRING)
		{
		l = strlen(t);
		if (l == 0)
			ERR("variable length string",E_VARSTR);
		if (s->s_size < l)
			s->s_size = l;
		s = mnode(STR_OP,s->s_type,s,iconst(l,INT2));
		}
	t = diadic(STORE_OP,t,s);
	}
else
	setflag(t,F_ARG);
return(t);
}

noexpr()
{
ERR("expression not allowed",E_NOEXPR);
}

exprtree()
{
return(expr(RIGHT));
}

subscvar(type)
{
/*
 * calculate position of subscripted variable.
 */
register char *s;
register char *r;
int i;
register char *t;
char *subs[MAXSUBS];
char *l;
int n;

s = cur_sym;
if(s->s_loc == NOLOC)
	s->s_loc = LOCAL;		/* allocate it */
n = sym_nsubs;
l = iconst(s->s_size,intmode);		/* get length */
expect("(");
/*
 * loop thru subscript list accumulating the subsripts in
 * "subs".
 */
for (i=0; ; )
	{
	subs[i] = iexpr();
	if (++i < n)
		expect(",");
	else
		break;
	}
expect(")");
r = 0;
/*
 * calculate the subscript position from accumulated subscript
 * expressions.
 */
for (i=n; --i >= 0; )
	{
	t = diadic(SUB_OP,subs[i],s->s_subs[i].lwb);
	if(chkflg)
		t = diadic(CHK_OP,t,s->s_subs[i].upb);
	if (r)
		r = diadic(ADD_OP,r,t);
	else
		r = t;
	r = diadic(MUL_OP,r,(i == 0) ? l : s->s_subs[i-1].upb);
	}
t = mnode(SYM_OP,s->s_type,s,NULL);
if (s->s_loc == PARAM)
	{
	if(ZERO(r))
		return(t);		/* 0 offset subscript */
	}
else
	{
	if (CONSTEXPR(r))
		{
		t->t_offset = intvalue(r);
		return(t);		/* constant subscript */
		}
	else if(dtest(r,ADD_OP))
		{
		t->t_offset = intvalue(r->t_left);
		r = r->t_right;
		}
	}
if (r && r->t_type != INT2)
	r = cvt(r,INT2);
t = mnode((type == RIGHT ? SBV_OP : SBA_OP),s->s_type,t,r);
return(t);
}

reverse(tree) char *tree;
{
/*
 * reverse a tree, used for functions where the arguments have to be
 * evaluated in reverse order to get them on the stack correctly.
 */
register char *t;
register char *r;
register char *old;

old = 0;
t = tree;
while (t)
	{
#ifdef	debug
	if(t->t_op != COMMA_OP)
		ERROR("incorrectly linked list",E_LIST);
#endif
	r = t->t_right;		/* next link */
	t->t_right = old;	/* link to previous */
	old = t;
	t = r;
	}
return(old);			/* now the last entry */
}

gentemp(type)
{
/*
 * generate a temporary of type "type".
 */

return(genvar(".t",tempcnt++,type));
}

genvar(name,letter,type) char *name;
{
/*
 * generate a variable name staring with "name", containing
 * a printable name corresponding to the integer 
 * "letter", and terminating with the type name, of the 
 * given type.
 */
register char *p;
register char *s;

clear(&symbol,SYMSIZE);
sym_len = SYMSIZE;
sym_type = type;
sym_loc = LOCAL;
sym_flags = F_TYPED;		/* insure correct type */
p = sym; s = name;
while (*s)
	*p++ = *s++;
*p++ = modenames[type];		/* insure uniqe name */
*p++ = 'a'+letter;
entersym();
return(cur_sym);
}

cexpr()
{
if (testc(STAR) || testc(AMP))
	{
	rclist = node(COMMA_OP,litem(),rclist);
	return(NULL);
	}
return(pexpr());
}

strlen(sp) char *sp;
{
/*
 * sp must be of type string. if "sp" is an expression involving
 * varying length strings return 0.
 * otherwise return the total length of the concatenation.
 */
register char *s;
register int l;
register char *r;
int l2;

s = sp;
if (INSYM(s))
	return(s->s_size);
if (s->t_op == STR_OP)
	{
	if (r = s->t_right)
		{
		if (constant(r))
			return(intvalue(r));
		else
			ERROR("bad str len",E_BADLEN);
		}
	else
		return(strlen(s->t_left));
	}
else if (s->t_op == CAT_OP)
	{
	if ((l = strlen(s->t_left)) && (l2 = strlen(s->t_right)))
		return(l+l2);
	}
else if (s->t_op == SBA_OP || s->t_op == SBV_OP || s->t_op == SYM_OP)
	return(strlen(s->t_left));
return(0);
}

#ifdef	strtest
strlen(sp) char *sp;
{
register int l;
static int strlvl;

printf("strlen %d:\n",++strlvl);
treeprint(sp);
l = str2len(sp);
printf("strlen: %d return %d\n",strlvl--,l);
return(l);
}
#endif

cmplxconst()
{
/*
 * get a complex constant of the form: ( fpt1, fpt2)
 * where "fpt1" and "fpt2" are real constants.
 */
register char *f1, *f2;
register int m;

expect("(");
f1 = rconst();
expect(",");
f2 = rconst();
expect(")");
m = f1->s_type;
if (f2->s_type != m)
	m = REAL8;
f1 = cvt(f1,m);
f2 = cvt(f2,m);
if (m == REAL4)
	m = CMPLX8;
else
	m = CMPLX16;
return(cconst(f1,f2,m));
}

rconst()
{
register char *s;

s = nconst();
switch(s->s_type)
	{
case INT2:
case INT4:
	return(cvt(s,REAL4));
case REAL4:
case REAL8:
	return(s);
default:
	ERR("real constant required",E_RCONST);
	}
}

substring(sp) char *sp;
{
register char *s, *l, *a;
s = sp;
chkstr(s->t_type);
expectc(LPAR);
if (optc(COLON))
	a = one_const;
else
	a = iexpr();
expectc(COLON);
s = str(s);		/* put in STR prefix if not already there */
if (!optc(RPAR))
	/*	second substring expression is end-pos, convert to length */
	l = iexpr();
else
	l = iconst(s->t_left->s_size,INT2);
s->t_right = diadic(SUB_OP,diadic(ADD_OP,l,one_const),a);
/*
 * if start-position is constant, and variable is not a parameter
 * (or if it is and staring position is zero offset) then convert
 * substring into a regular SYM_OP with an offset.
 */
if (constant(a) && (s->t_left->s_loc != PARAM || intvalue(a) == 1) )
	s->t_left = mnode(SYM_OP,CHARACTER,s->t_left,intvalue(a)-1);
else
	s->t_left = mnode(SUBSTR_OP,CHARACTER,s->t_left,a);
expectc(RPAR);
return(s);
}

colon()
{
/*
 * scan ahead to check if the next delimeter is a colon.
 * if it is then return YES, otherwise NO.
 */
register char *savetree;
register char *saveptr;
register int c;
char *savesym;

switch(inptr[1])
	{
case COLON:
	return(YES);
case RPAR:
case STAR:
case AMP:
	return(NO);
	}
savetree = textlast;
saveptr = inptr;
savesym = cur_sym;
++inptr;
expr(MIDDLE);
c = *inptr;
textlast = savetree;
inptr = saveptr;
cur_sym = savesym;
move(cur_sym->s_len&0377,cur_sym,&symbol);
return(c == COLON);
}
