#include "batch.h"

#define	eintr	4

char *aborts[]
{
"exit","hangup","interrupt","quit","illegal instruction trap",
"trace trap","iot trap","emt trap","floating point exception",
"killed","bus trap","segmentation trap","bad sys call",
"broken pipe","signal 14","signal 15","signal 16","signal 17",
"signal 18","signal 19"
};

int dtflg;

run(rflg)
{
/*
 * invoke a program. if rflg then it was a "r" command; 
 * otherwise a "ru" command. 
 */

register char *p;

register int i;

if(*ptr==0)
	err("no file specified");

getfile();

if(rflg)
	{
	if(file.f_uic)
		err("syntax");
	file.f_uic = sysuic;
	}

if( dtflg = equal(device.d_device,"dt"))
	{
	device.d_device[0] = 0;
	}
cvtfile(pgm);

if(run_fork() == 0)
	{		/* child */
	runinit();
	p = runtest();
	execv(p,execp);
	error("no %s",p);
	}

run_term();
}

closeall()
{

register int i;

for (i=3; i<15; ++i)
	close(i);

}


runinit()
{

/*
 * set up for run process 
 */

	if(chdir(userdir)< 0)
		error("no directory %s",userdir);
	setuid(uid);
	setgid(gid);
	close(0);
	dup(inpipe);
	closeall();
	signal(sigtime,0);			/* allow time outs */
	signal(sigint,old_int);
	signal(sigquit,old_quit);
	signal(sighup,old_hup);
}


runtest()
{
/*
 * routine to try and locate the program. if its found 
 * and is (unix) executable then run under unix. 
 * otherwise run under fakedos. 
 */

register char *p;

if( !	(test("",".lda") || test("/dos/",".lda") ||
	test("","") || test("/dos/","")))
	{
	if(dtflg)
		{		/* must fetch it from tape */
		execp[2] = pgm;
		execp[0] = device.d_unit;
		return("/dos/fetch");
		}
	error("program %s not found",pgm);
	}

if(statb.s_flags&xmask)
	{
	execp[2] = pgm;
	p = pathname;
	}

else
	{
	execp[2] = pathname;
	p = "/dos/fakedos";
	}

return(p);
}


test(s1,s2)
char *s1,*s2;
{
/* 
 * test if s1 concatened with pgm with s2 
 * exists and is a file 
 */

copy(pathname,s1);
append(pathname,pgm);
append(pathname,s2);

if(any(pgm,".") && any(s2,"."))
	return(0);

if(pgm[0] == '/' && s1[0] == '/')
	return(0);

if(stat(pathname,&statb) < 0) 
	return(0);
if((statb.s_flags & imask) != ifile)
	return(0);

return(1);
}

run_term()
{
extern errno;
register int i;

while (readline())
	{
	if(buff[0]!='$' || eq(buff,"$eo"))
		{
		append(buff,"\n");
		if(write(outpipe,buff,length(buff)) < 0)
			break;
		}
	else
		{
		++inflag;
		break;
		}
	}

close(outpipe);
outpipe = 0;
while ( (i=wait(&status)) != runps)
	if(i == -1 && errno != eintr)
		{
		printf("no process (ps = %d)\n",runps);
		}
	;
runps = 0;
if(status.lo==0)
	{
	if(status.hi!=0)
		err("job has been aborted");
	}
if(status.lo==sigtime)
	err("job time limit exceeded");
if(status!=0)
	err("%s ... job has been aborted",aborts[status&0177]);
}



run_fork()
{
/*
 * routine to fork and create the child process used 
 * to run programs and execute unix commands. 
 * it is responsible for creating the pipes used to pass
 * command data.
 */
extern fout;

flush();			/* force out any pending stuff */
if(pipe(pipes) < 0)
	err("can't create pipes");

if((runps = fork()) == 0)
	{
	close(outpipe);
	outpipe = 0;
	if (fout > 2)
		{
		close(1);
		dup(fout);
		}
	close(2);
	dup(1);
	}
else
	{
	close(inpipe);
	inpipe = 0;
	signal(sigpipe,1);
	}
return(runps);
}
