#
/*			Copyright 1980 by Bill Webb.	 		*/
#include "basic.h"
#include "stack.h"

#define	TYPEMASK	017

char *typenames[] IS
{
"", "integer", "real", "string", "", "function", "for", "gosub",
"any expression", "integer expression", "real expression", "string expression", "", "", "", "" };

STKPTR push(p) register STKPTR p;
{
/*
 * push stack item pointed to by "sp" onto the stack.
 */
register STKPTR s;
register int i;

s = (STKPTR) ((char *) stkptr - p->k_len);
if (s < (STKPTR) stkbase)
	stkover();
#ifndef NOTRCE
if (tflg)
	{
	TTRACEF(("stkptr=%o\n",stkptr));
	printf("push @%o item %s (%d), %d bytes",s,typenames[p->k_type],p->k_type,p->k_len);
	for (i=1; i<p->k_len/2; ++i)
		printf(" %o",((int *) p)[i]);
	printf("\n");
	}
#endif
move(p->k_len,(char *) p,(char *) s);
stkptr = (char *) s;
return(s);
}

clrstk()
{
register int *s;

stkptr = stktop;
s = (int *) stkptr;
*--s = NULLSTK;	/* null stack frame */
stkptr = (char *) s;
restore();
}

restore()
{
/*
 * restore data pointer to beginning.
 */
data.g_inptr = NULL;
data.g_curline = (LINEPTR) lines;		/* reset the DATA pointer */
}

STKPTR pop(type)
{
/*
 * pop an item of the "type" off the stack.
 * return a pointer to it.
 */
register STKPTR s;

s = (STKPTR) stkptr;
TRACEF(("pop @%o item %s (%d), %d bytes\n",s,typenames[s->k_type],s->k_type,s->k_len));
if (s->k_type == NULL)
	badstk(NULL);
if (s->k_type != type && type != ANYTYPE)
	badstk(type);
stkptr = (char *) stkptr + s->k_len;	/* pop stack */
TTRACEF(("stkptr=%o\n",stkptr));
return(s);
}

struct stringexpr *pushstring(ptr,len) char *ptr;
{
struct stringexpr s;

s.k_type = STRINGEXPR;
s.k_len = sizeof (struct stringexpr);
s.k_sptr = ptr;
s.k_slen = len;
return((struct stringexpr *) push(&s));
}

pushfloat(f) double f;
{
/*
 * special case push for floating point ... done very often
 */
register struct floatexpr *s;

s = ((struct floatexpr *) stkptr) - 1 ;
if (s < (struct floatexpr *) stkbase)
	stkover();
TRACEF(("pushfloat %f\n",f));
stkptr = (char *) s;
s->k_type = FLOATEXPR;
s->k_len = sizeof (struct floatexpr);
s->k_float = f;
}


double popfloat()
{
register struct floatexpr *s = (struct floatexpr *) stkptr;

if (s->k_type != FLOATEXPR)
	badstk(FLOATEXPR);
stkptr = ((char *) stkptr) + s->k_len;	/* remove it from the stack */
TRACEF(("pop %f\n",s->k_float));
return(s->k_float);
}

badstk(type)
{
register int i;

if ((i = ((struct stack *) stkptr)->k_type) == NULL)
	err("stack underflow");
if (type)
	err("%s expected; got %s",typenames[type],typenames[i]);
dumpstk();
err("bad stack frame");
}

dumpstk()
{
register STKPTR s;

#ifndef NOTRCE
for (SCANSTK(s))
	TRACEF(("stack @ %o = %s (%d bytes)\n",s,typenames[s->k_type],s->k_len));
#endif
}

popstring(sptr,lptr) char **sptr; int *lptr;
{
register struct stringexpr *s;

s = (struct stringexpr *) stkptr;
pop(STRINGEXPR);
*sptr = s->k_sptr;
*lptr = s->k_slen;
}

stkover()
{
err("stack overflow");
}
