#
#include <stdio.h>
/*			Copyright 1980 by Bill Webb.	 		*/
/*  EVAX                                                                */
/*        JNL821118   add conditional prompt for signon     EVAX        */
/*        JNL821123   add conditional tracing flg -o        EVAX        */
/*        JNL821123   fix blank line vi problem             EVAX        */
/*        JNL821211   add check for seg. faults             EVAX        */
/*                                                                      */
#include "basic.h"
#include "stack.h"
#include "tokens.h"
#include <signal.h>


#define	ISUPPER(c) ('A' <= c && c <= 'Z')
#define	NOTTY	'x'
FILE *infile;
int listlevel INITZERO;
int timerflg = TIMER ;  /*  force it to be on  */

main(argc,argv) char **argv;
{
int	die() ;
register char *argp;
LNR startline = 0;
--argc;
++argv;

while (argc > 0 && (*(argp = *argv) == '-' || *argp == '+'))
	{
	++argv;
	--argc;
	if (*argp == '+')
		{
		startline = atoi(argp+1);
		continue;
		}
	while (*++argp)
		switch(*argp)
			{
		case 'a':
			++aflg;
			break;
		case 'n':
			++nflg;
			break;
		case 'o':			/* EVAX */
			++oldtrflg ;			/* EVAX */
			break ;  			/* EVAX */
		case 'r':
			++rflg;
			break;
		case 's':
			typelens[FLOAT] = sizeof (float);	/* single precision */
			break;
		case 'x':
			++xflg;
			break;
		case 't':
			++tflg;
			break;
#ifdef PLOT
		case 'p':
			pltini(*argv++);
			--argc;
			break;
#endif
			}
	}

initsys();
init();
signal(SIGSEGV, die) ;  /*  just in case ... */
printf(SIGNON);
if (argc > 0)
	{
	argcnt = argc;
	argvec = argv;
	argc = 0;
	enter(old,*argv);
	}
if (rflg)
	{
	exit(enter(dorun,startline) == NULL ? 0 : 1);
	}
for (;;)
	enter(doline,0);
}

doline()
{
TESTATTN();
if (istty)
	printf(prompt);
flush();
if (readline(line,infile) < 0)
	{
	TESTATTN();
	exit(0);
	}
inptr = line;
if (line[0] == 0)
	;
else if (!moncmd())
	compile();
}

compile()
{
register LNR lnr;
register int l;
register LINEPTR p;

inptr = line;
tokenize(line,line);
if (tflg)
	listline(&immed,stdout);
inptr = line;
if (line[0] == 0) return (YES) ;  /*  blank line EVAX  */
if (isdigit(line[0]))
	{
	lnr = cvtlnr();
	if (*inptr)
		{
		l = length(inptr)+1;
		move(l,inptr,immed.l_line);
		if (l&1)
			++l;
		l += LINESIZE;
		immed.l_len = l;
		immed.l_lnr = lnr;
		storeline(&immed);
		}
	else
		{
		p = findline(lnr,NEXTLNR);
		if (p->l_lnr == lnr)
			delline(p);
		}
	}
else
	{
	curline = 0;
	immed.l_len = 0;
	execute(&immed);
	}
return(YES);
}

LINEPTR findline(lnr,flag) LNR lnr;
{
/*
 * scan thru the lines to locate the given line number.
 * if given line is not found and NEXTLNR was specified
 * return the next one.
 */
register LINEPTR p;

for (SCANLINES(p))
	{
	if (lnr <= p->l_lnr)
		break;
	}
if (p->l_lnr != lnr && flag != NEXTLNR)
	err("line not found");
return(p);
}

list(line1,line2,file) FILE *file;
LNR line1;
LNR line2;
{
register LINEPTR p;

listlevel = 0;
for (SCANLINES(p))
	{
	if (p->l_lnr >= line1)
		{
		if (p->l_lnr > line2)
			break;
		else
			listline(p,file);
		}
	}
}

char lnrdelims[] = { MINUS, COMMA, '-', ',', 0 };
getlnrs(lp1,lp2,type) LNR *lp1; LNR *lp2;
{
/*
 * get line number range into lp1 and lp2
 * optional formats:
 * LISTLNRS:
 * 		0-MAXLNR
 * line		line-line
 * line1,line2	line1-line2
 * DEFAULTLNRS:
 * independent defaults for line1 and line2
 * according to what is initially passed.
 */
register LNR line1;
register LNR line2;

if (type == LISTLNRS)
	{
	line1 = 0;
	line2 = MAXLNR;
	}
else
	{
	line1 = *lp1;
	line2 = *lp2;
	}
if (*inptr == NULL)
	;
else
	{
	line1 = cvtlnr();
	if (type == LISTLNRS)
		line2 = line1;
	optional(lnrdelims);
	if (*inptr)
		line2 = cvtlnr();
	}
endchk();
*lp1 = line1;
*lp2 = line2;
}

delete(line1,line2)
LNR line1; LNR line2;
{
register LINEPTR p;

for (p = findline(line1,NEXTLNR); isline(p) && p->l_lnr <= line2; delline(p))
	;
}

delline(linep)
LINEPTR linep;
{
register LINEPTR p;
register LINEPTR q;
register int l;

p = linep;
l = p->l_len;
q = NEXTLINE(p);
smartmove(((char *)lastline)-((char *) q), (char *) q, (char *) p);
lastline -= l;
--linecnt;
}

badsyn()
{
err("bad syntax");
}

optional(str) char *str;
{
register char *s;

if (*inptr)
	for (s=str; *s; ++s)
		if (*s == *inptr)
			{
			++inptr;
			return(1);
			}
return(0);
}

storeline(linep) LINEPTR linep;
{
/*
 * store line "linep" into place at line number "lnr"
 * locate the place that it should be stored into.
 * if there already exists a line there then replace it.
 * otherwise move the lines down and insert it.
 */
register LINEPTR l;
register LINEPTR p;
register char *q;	/* where the next line is */
int overlap;

l = linep;
p = findline(l->l_lnr,NEXTLNR);
if (l->l_lnr != p->l_lnr)
	q = (char *) p;				/* insert before p */
else
	q = (char *) NEXTLINE(p);	/* replace p */
overlap = (char *)q - (char *) p;	/* length of overlap */
if (overlap >= l->l_len && overlap-l->l_len <= LEN_FUZZ)
	l->l_len = overlap;
else
	{
	while (lastline + l->l_len - overlap > endlines)
		if (!morelines())
			err("out of room");
	smartmove(lastline-q,q,(char *)p + l->l_len);	/* make room for it */
	}
move(l->l_len,(char *) l,(char *) p);
lastline += l->l_len - overlap;		/* revised end */
if (!overlap)
	++linecnt;
}

LNR cvtlnr()
{
register LNR l;
register int c;

l = 0;
while ((c = *inptr) && isdigit(c))
	{
	l = l * 10 + c - '0';
	if (l > MAXLNR)
		err("bad line number");
	++inptr;
	}
return(l);
}

init()
{
extern char *prompts[];

prompt = prompts[0];		/* default is unix prompt */
initprio();
clrsym();
clrstk();
clrprog();
}

clrprog()
{
/*
 * erase the program by puting the "last line" in at the start
 * of the program area.
 */
register LINEPTR l;

l = (LINEPTR) lines;
l->l_len = 0;
l->l_lnr = MAXLNR;
lastline = ((char *) l) + LINESIZE;
linecnt = 0;
}

tokenize(inp,outp)
char *inp, *outp;
{
/*
 * go thru "inp" and convert all basic keywords into their
 * tokens and put into "outp".
 * convert to lower case.
 * take care of strings as well.
 */
register int c;
int i;
register char *t, *p;

while (c = *inp++)
	{
	if (c == ' ')
		continue;
	for (i= -1; t = tokens[UNTOKEN(i)]; --i)
		{
		for (p=inp-1; ; )
			{
			if (*p++ != *t++)
				{
				if (p[-1] == ' ')
					{
					--t;
					continue;
					}
				else if (ISUPPER(p[-1]) && p[-1] == t[-1]-('a'-'A'))
					;
				else
					break;
				}
			if (*t == 0)
				{
				TTRACEF(("token %d ",i));
				inp = p;
				c = i;
				switch(i)
					{
				case REM:
				case DATA:
					*outp++ = c;
					while (*outp++ = *inp++)
						;
					return;
				case PRIME:
				case QUOTE:
					--t;	/* point to delimeter */
					*outp++ = c;
					while (*inp)
						{
						if (*inp == *t && *++inp != *t)
							break;
						*outp++ = *inp++;
						}
					if (*inp == NULL)
						{	/* special case where output is longer than input */
						*outp++ = c;
						*outp = 0;
						return;
						}
					break;
					}
				goto loop;
				}
			}
		}
	if (ISUPPER(c))
		c -= 'A' - 'a';		/* make it lower case */
loop:
	*outp++ = c;
	}
*outp = c;
}

listline(linep,file) LINEPTR linep; FILE *file;
{
/*
 * list a line in the program.
 * only complications are:
 * (1) tokens have to be expanded to their textual representations
 * (2) for ... next loops are indented to show program structure
 */
register char *p;
register LINEPTR l;
int wastoken;
register int c;
int i;

l = linep;
fprintf(file,"%5d ",l->l_lnr);
for (i=0; i<listlevel; ++i)
	fprintf(file," ");
wastoken = YES;
for (p =l->l_line; *p; ++p)
	{
	if (istoken(*p))
		{
		if (!wastoken)
			fprintf(file," ");
		++wastoken;
		c = *p;
		switch(c)
			{
		case QUOTE:
		case PRIME:
			c = tokens[UNTOKEN(c)][0];
			fprintf(file,"%c",c);
			while (*++p && !istoken(*p))
				{
				if (*p == c)
					fprintf(file,"%c",c);
				fprintf(file,"%c",*p);
				}
			fprintf(file,"%c ",c);
			break;
		case REM:
		case DATA:
			fprintf(file,"%s",tokens[UNTOKEN(c)]);
			break;
		case FOR:
			if (p[1] == INPUT || p[1] == OUTPUT)
				goto normal;
			listlevel += 2;
		case NEXT:
			listlevel--;
		default:
		normal:
			fprintf(file,"%s ",tokens[UNTOKEN(c)]);
			break;
			}
		}
	else
		{
		putc(*p,file);
		wastoken = NO;
		}
	}
fprintf(file,"\n");
}

autonumber(line1,line2) register LNR line1, line2;
{
register LINEPTR q;
register char *p;
char *flag;

curline = NULL;
for ( ; ; line1 += line2)
	{
	sprintf(line,"%5u ",line1);
	if ((q = findline(line1,NEXTLNR)) && q->l_lnr == line1)
		flag = "*";
	else
		flag = "";
	printf("%u%s ",line1,flag);
	flush();
	p = endstr(line);
	if (readline(p,infile) < 0 || *p == 0)
		{
		TESTATTN();
		break;
		}
	inptr = line;
	compile();
	if (*line == END)
		break;			/* stop after END found */
	}
}

attnerr()
{
err(ATTNMSG);  /*  EVAX fix  */
}

die()
{
#ifdef EVAX
	signal (SIGSEGV, SIG_IGN) ;	/* dangerous !!! */
#endif
	error("Segmentation fault!! Please notify %s",NOTIFY);
}

