#include "basic.h"
/*			Copyright 1980 by Bill Webb.	 		*/
#include "stack.h"
#include "tokens.h"

def()
{
/*
 * define a function that follows.
 * def fn name type (v1,...,vn)
 * all that happens now is that the input pointer is saved for
 * later evaluations of the function.
 */
register struct fn *v;
int type;

if (*inptr != FN)
	badsyn();
v = (struct fn *) getvar(&type,NO);		/* collect the function name */
v->v_curline = curline;
v->v_inptr = inptr;
while (!endtest())
	++inptr;
}

fn()
{
/*
 * invocation of a previously defined function.
 */
register struct fn *f;		/* the function */
register STKPTR s;
struct var *v;			/* pointer to vars on stack */
struct var var;
int type;
int vtype;			/* the of a variable */
int i, n;
char *base;			/* stack base */
char *saveptr;			/* saved curline and inptr */
struct textline *saveline;

base = stkptr;
f = (struct fn *) getvar(&type,NO);		/* get the function header */
if (f->v_inptr == NULL)
	err("function undefined");
expectc(LPAR);
for (n = 0; !endtest();)
	{
	expr();
	++n;
	if (*inptr == RPAR)
		break;
	expectc(COMMA);
	}
expectc(RPAR);
s = (STKPTR) stkptr;		/* remember where expressions are on stack */

saveline = curline; saveptr = inptr;
curline = f->v_curline; inptr = f->v_inptr;
expectc(LPAR);
for (i=1; i <= n; ++i)
	{
	var.k_len = sizeof (struct var);
	var.k_ptr = getvar(&vtype,NO);
	var.k_type = vtype;
	push(&var);
	if (i < n)
		expectc(COMMA);
	}
expectc(RPAR);
expectc(EQ);
v = (struct var *) stkptr;	/* variables on stack */
exchange(s,v,n);		/* exchange variables with stacked values */
expr();
endchk();
exchange(s,v,n);		/* exchange variables with stacked values */
s = (STKPTR) stkptr;			/* the current expression */
stkptr = base;			/* restore the original stack */
push(s);			/* push the result onto the stack */
curline = saveline; inptr = saveptr;
}

exchange(s,v,n) register struct var *v; register STKPTR s;
{
/*
 * v points to variables stored on the stack.
 * s points to values stored on the stack.
 * there are "n" of each.
 * go thru both lists, exchanging the values of each.
 */
int i;
register SYMPTR p;
char *ptr; int len; double f;

for (i=0; i<n; ++i)
	{
	p = v->k_ptr;			/* pointer to variable */
	if (s->k_type != v->k_type+EXPR)
		err("types don't match %s <> %s",typenames[s->k_type],typenames[v->k_type]);
	TRACEF(("exchange value %.2s ",p->v_name));
	switch(v->k_type)
		{
	case FLOAT:
		TRACEF((" %.6f <==> %.6f\n",floatSym(p),floatStk(s)));
		f = floatStk(s);
		if (SINGLE)
			{
			floatStk(s) = floatSym(p);
			floatSym(p) = f;
			}
		else
			{
			floatStk(s) = doubleSym(p);
			doubleSym(p) = f;
			}
		break;
	case INT:
		TRACEF((" %d <==> %d\n",intSym(p),(int) floatStk(s)));
		f = floatStk(s);
		floatStk(s) = intSym(p);
		intSym(p) = f;
		break;
	case STRING:
		TRACEF((" %.*s <==> %.*s\n",Klen(s),Kptr(s),Slen(p),Sptr(p)));
		ptr = Kptr(s);
		len = Klen(s);
		Kptr(s) = Sptr(p);
		Klen(s) = Slen(p);
		Sptr(p) = ptr;
		Slen(p) = len;
		break;
		}
	s = (STKPTR) POPSTK(s);
	v = (struct var *) POPSTK(v);
	}
}
