#include <stdio.h>
#include <pwd.h>

#define	LIMITFILE "/usr/adm/cpu-stats.l"
#define	MAXUID	256
int f;
int limit;

main(argc,argv) char **argv;
{
register struct passwd *p;
int n;
register char *s;

if ((f = open(LIMITFILE,2)) < 0)
	err("cannot open %s",LIMITFILE);
if (argc == 1)
	{
	printlimits();
	exit(0);
	}
if (argc > 3)
	err("usage: %s [user] [amount]",argv[0]);
if ((p = getpwnam(argv[1])) == NULL)
	err("%s not valid login name",argv[1]);
seek(f,p->pw_uid * sizeof limit,0);
if (argc == 2)
	{
	read(f,&limit,sizeof limit);
	}
else
	{
	s = argv[2];
	n = atoi(s);
	limit = n;
	write(f,&limit,sizeof limit);
	close(f);
	}
printf("%s limit is now %d\n",argv[1],limit);
}

printlimits()
{
register struct passwd *p;
register int i;

for (i=0; i<MAXUID; ++i)
	{
	if (read(f,&limit,sizeof limit) != sizeof limit)
		break;
	if (limit && (p = getpwuid(i)) != NULL)
		printf("%-8.8s %d\n",p->pw_name,limit);
	}
}
