
#include <avsys.h>

void DisableInterrupts()
{
_asm
{
  di
}
}

void EnableInterrupts()
{
_asm
{
  ei
}
}

double sqrt(double d)
{
  return *((double*(*)())0x30d5)(d);
}

double dabs(double d)
{
  return *((double*(*)())0x30cf)(d);
}

double dint(double* d)
{
_asm
{
  ld l,_d+0(ix)
  ld h,_d+1(ix)
  call 0x30c9
  ld e,8(ix)
  ld d,9(ix)
  ld bc,#0x8
  ldir
}
}

int dtoa(double d,char* str)
{
_asm
{
  ld e,_str+0(ix)
  ld d,_str+1(ix)

  pop ix
  pop hl
  ld (retaddr),hl
  pop hl
  ld (retbank),hl
  pop hl
  ld (retfunc),hl

  call 0x30cc

  ex de,hl
  ld hl,(retfunc)
  push hl
  ld hl,(retbank)
  push hl
  ld hl,(retaddr)
  push hl
  push ix
  ex de,hl
}
}

double atod(char* str)
{
_asm
{
  ld l,_str+0(ix)
  ld h,_str+1(ix)
  call 0x30c3
  ld e,8(ix)
  ld d,9(ix)
  ld bc,#0x8
  ldir
}
}

int atoi(char *str)
{
  int n;
  int f;

  n = 0;
  f = 0;
  for(;;str++)
  {
    switch(*str)
    {
      case ' ':
      case '\t': continue;
      case '-': f++;
      case '+': str++;
    }
    break;
  }
  while(*str >= '0' && *str <= '9') n = n*10 + *str++ - '0';
  return (f?-n:n);
}

char* itoa(int value,char *string,int radix )
{
  char buf[16];
  char* p=buf+15;
  int t=value;
  int d;

  if(!value)
  {
    string[0]='0';
    string[1]=0;
    return string;
  }

  p[0]=0;

  if(t<0)
  {
    t=-t;
  }

  while(t)
  {
    d=(t%radix);
    if(d>9) d+=7;
    *--p=d+'0';
    t/=radix;
  }

  if(value<0)
  {
    *--p='-';
  }

  strcpy(string,p);

  return string;
}
