unsigned int NumberOfEntries;
unsigned char IrByte[MAXIRBYTES];
/*------------------------------------------------------*/

void sende()
{
  if (NumberOfEntries>0)
  {
   _asm
  {
	di
	ld 	l,#PORT_IR
	ld 	e,#BAUD_115200
	ld 	d,#0
	call 	0x018C			; init_comm
;------------------------------------------------------------------
; set 7 bit
;------------------------------------------------------------------
        in      a,(#A10_UART_LCR)  	; Get current lcr.
        and     a,#0b10000000      	; Set Parameters
        or      a,#0b00000001
        out     (#A10_UART_LCR),a	; Set new lcr.

;------------------------------------------------------------------
; Send IR-Sequences
;------------------------------------------------------------------
   	ld 	de,(_NumberOfEntries)
        ld 	hl,#_IrByte		 ;Array with IR-Bytes
.snd01:
	push	de
	ld	a,(hl)		; current IrByte 
	and	a,#0x7F		; mask for repeats
	ld	e,a		; e is repeat counter
	ld	a,(hl)		; current IrByte
	push	hl		; save hl
	and	a,#0x80		; mask for gap-bit
	jr	z,.snd03	; gap ?
	ld	l,#0x6D	      	; no : Set Standard byte

.snd02:
	call 	0x0192		; Send One Byte
	dec	e		; count repeats
	jr	nz,.snd02
	jr	.snd05
.snd03:
	ld	hl,#40		; yes : delay for the time to send 1 Byte		
.snd04:
	dec	l		; count delay
	jr	nz,.snd04
	dec	e		; count repeats
	jr	nz,.snd03
.snd05:	
	pop	hl		; array pointer
	pop	de		; Number of Entries
	inc 	hl		; bump array pointer
	dec	de		; count down
	ld	a,e		; all IrBytes done ?
	or	d
	sbc	#0
	jr	nz,.snd01

	call 0x018F			; close comm
	ei
  }
  }  
}
/*------------------------------------------------------*/

void learn()
{
  int i;
  for (i=0;i<NumberOfEntries;i++)
  {
	IrByte[i]=0;
  }
  _asm
  {
	di
	ld 	l,#PORT_IR
	ld 	e,#BAUD_115200
	ld 	d,#0
	call 	0x018C			; init_comm
;------------------------------------------------------------------
; set 7 bit
;------------------------------------------------------------------
        in      a,(#A10_UART_LCR)  	; Get current lcr.
        and     a,#0b10000000      	; Set Parameters
        or      a,#0b00000001
        out     (#A10_UART_LCR),a  	; Set new lcr.

;------------------------------------------------------------------
; wait for a gap (200 bytes long, max waiting 65000 Loops)
;------------------------------------------------------------------
	ld 	hl,#0000            	; max loops
.lrn01:
        ld 	d,#200               	; size of gap
.lrn02:
	in 	a,(A10_UART_LSR)     	; load Line control register
	bit 	0,a			; test flag "receive data ready"
	jr 	nz,.lrn03              	; ==> not in gap
	dec 	d                   	; no count gap
	jr 	nz,.lrn02
	jr 	.lrn04
.lrn03:
	in 	a,(A10_UART_RBR)   	; dummy : load Receive buffer register
	dec  	l                  	; count loops
	jr 	nz,.lrn01
	dec 	h
	jr 	nz,.lrn01
;------------------------------------------------------------------
; wait for first flash-light; max 3.000.000 loops ~ 20 sec.
;------------------------------------------------------------------
.lrn04:
	ld 	hl,#0x0000        	; max loops
	ld	e,#0x30
.lrn05:
	in 	a,(A10_UART_LSR)     	; load Line control register
	bit 	0,a			; test flag "receive data ready"
	jr 	nz,.lrn06              	; yes ==> get Byte
	dec  	l                  	; count loops
	jr 	nz,.lrn05
	dec 	h
	jr 	nz,.lrn05
	dec 	e
	jr 	nz,.lrn05
	jr 	.lrn14			; ==> timeout 
	
;---------------------------------------------------------------
; Record IR-Sequences
;---------------------------------------------------------------
.lrn06:
	in 	a,(A10_UART_RBR)   	; load Receive buffer register
        ld 	hl,#_IrByte		; Array with IR-Bytes
	ld	e,#0x6D			; e = last received Byte
	ld 	c,#1			; c = repeat counter (eins im Sinn)
	ld 	b,#17			; b = number of retries 
        jr      .lrn09

.lrn07: 
	ld 	c,#1			; c = repeat counter (eins im Sinn)
	ld 	b,#12			; b = number of retries 
        jr      .lrn09
.lrn08:                            	 
	ld 	b,#14			; b = number of retries 
.lrn09:
	in 	a,(A10_UART_LSR)   	; load Line status register
	bit 	0,a               	; test flag "receive data ready"
	jr 	nz,.lrn10            	; ==> get byte
	dec 	b                 	; count retries
	jr 	nz,.lrn09            	; ==> in limit
	ld 	a,#0               	; ==> time out: no byte received
	jr 	.lrn11  
.lrn10:
	in 	a,(A10_UART_RBR)   	; load Receive buffer register
	or 	a
	jr 	z,.lrn11	      	; =0 ?
	ld 	a,#0x6D	      		; Set Standard byte
.lrn11:
	cp	e			; same byte as before ? 
  	jr	nz,.lrn12		; no : ==> save entry
  	inc	c
	ld	a,#127
	cp	c
	jr	nz,.lrn08			
	ld	a,e			; last byte
.lrn12:
	ld 	b,a			; b = temp for last received byte
	ld 	a,#0
	cp	e
	ld	a,c			; Repeats
	jr	z,.lrn13
	or	a,#0x80			; send 
.lrn13:
	ld	(hl),a
	inc	hl
	ld 	e,b			; last received byte
	ld	a,(_NumberOfEntries)
	dec 	a
	ld	(_NumberOfEntries),a
	jr	nz,.lrn07
	ld	a,(_NumberOfEntries+1)
	dec 	a
	ld	(_NumberOfEntries+1),a
	jp	p,.lrn07
.lrn14:		 
	call 0x018F			; close comm
	ei
  }
}
