/* .\avsdk\lib\knotools.c

  C-lib with diverse tools, missed in SDK.
  Maybe Gerard will put it in AVSYS.

  This is Public Domain.
  Coded by Kai Nothdurft 01/2000.
  KNothdur@ifu.Rantzau.de

*/

#include <knotools.h>

#define _fstrcpy 0x0105

char *fstrcpy(unsigned char* dest, CONST_FAR_PTR src)
/*
    Function
      Copies banked string src to dest.

    Parameters 
      dest   Pointer of the destination string.
      src    The 'long'-address of source string.

    Return Value  
      Pointer of destination string.

    Example
      fstrcpy(string1, string2);

*/
{
     _asm
     {
          ld    l, _dest+0(ix)
          ld    h, _dest+1(ix)  /* destination-address in HL */
          ld    e, _src+2(ix)
          ld    d, _src+3(ix) 
          push  de              /* source bank on stack */
          ld    e, _src+0(ix)
          ld    d, _src+1(ix)   
          push  de              /* source-address on Stack */
          call  _fstrcpy        /* FarStrCopy. */
          pop   de              /* clean up stack */
          pop   de              /* clean up stack */
     }
}
