/*Avigo FwSDK Keyboard input routines
 *Written for Avigo FwSDK v0.92 beta 3
 *By Sam Rauch
  srauch@umich.edu

  ***IF YOU MAKE ANY ENHANCEMENTS OR FIND ANY BUGS PLEASE LET ME KNOW SO THAT I
     CAN UPDATE THE GENERAL RELEASE***

 */

#ifndef _KEYBOARD_H
#define _KEYBOARD_H

/*All functions/parameters explained at bottom*/

/*Keyboard mode defines*/
#define KBSTATE_NORMAL     0
#define KBSTATE_CAPS       1
#define KBSTATE_SHIFT      2
#define KBSTATE_LFT_ACCENT 4
#define KBSTATE_RT_ACCENT  8
#define KBSTATE_DOT_ACCENT 16
#define KBSTATE_HAT_ACCENT 32
#define KBSTATE_SYMBOL     64
#define KBSTATE_FIRSTCAP   128
#define KBSTATE_PASSWORD   255

/*Keyboard backup defines*/
#define KB_BUFFER_BACKUP	1
#define KB_NO_BACKUP		2
#define KB_SWAPLCD_BACKUP	3
#define KB_LCDCOPY_BACKUP	4

/*Keyboard special key defines*/
/*These are the char values returned for the Backspace, Enter and Tab keys*/
#define KBKEY_BACKSPACE 8
#define KBKEY_CR  '\n'
#define KBKEY_TAB '\t'

/*functions*/
void open_keyboard(unsigned char mode);
void open_keyboard_extended(unsigned char mode, unsigned char backup, int x, int y);
char keyboard_is_open();
unsigned char check_keyboard(int key, int x, int y);
void close_keyboard();

/*Keyboard mode defines*/
/*Used to define the opening state of the keyboard:
	KBSTATE_NORMAL     Standard keyboard
	KBSTATE_CAPS       CAPS on
	KBSTATE_SHIFT      SHIFT on
	KBSTATE_LFT_ACCENT ` ("left") accent on
	KBSTATE_RT_ACCENT   ("right") accent on
	KBSTATE_DOT_ACCENT  ("double-dot") accent on
	KBSTATE_HAT_ACCENT ^ ("hat") accent on
	KBSTATE_SYMBOL     Symbol keyboard
	KBSTATE_FIRSTCAP   "First-caps" keyboard (Same as when you normal Avigo text entry)
	KBSTATE_PASSWORD   Password keyboard
Used in open_keyboard/open_keyboard extended function calls. KBSTATE_PASSWORD,
KBSTATE_FIRSTCAP, KBSTATE_SYMBOL should not be combined anything - send them
as single arguments.

The others can be combined following manner:
	[value] | [value] | [value] |.....
	The valid combinations follow these rules:
	  1. NORMAL, SHIFT, or CAPS - any or all or none of these can be present
	  2. Only one of the KBSTATE_*_ACCENT values can be present
	So "KBSTATE_CAPS | KBSTATE_SHIFT | KBSTATE_HAT_ACCENT" is a valid argument
		and will open a keyboard with Caps on, Shift on, and ^ accent on.
	But "KBSTATE_LFT_ACCENT | KBSTATE_RT_ACCENT" is not a valid argument.  Only
		one of the accents will actually be on.

  It won't crash if you send invalid combinations - open_keyboard will map
  whatever you send to a valid combination, it just may not be what you want :)

  The most frequently used values would probably be
	1. KBSTATE_NORMAL
	2. KBSTATE_FIRSTCAP
	3. KBSTATE_PASSWORD
*/

/*Keyboard backup defines*/
/* Defines how the LCD is backed up when the keyboard is opened:
	KB_NO_BACKUP - Don't backup LCD
	KB_BUFFER_BACKUP - Use the backup buffer; Backup/RestoreWindow()
	KB_LCDCOPY_BACKUP - Backs up the entire Real LCD to the Virtual LCD	
	KB_SWAPLCD_BACKUP - Use SwapLCD to backup just the portion occupied by
		the keyboard from the Real LCD to the Virtual LCD
  */


/*Explanation of functions*/

/*open_keyboard
void open_keyboard(unsigned char mode);
 * Easiest way to open keyboard.  Simply calls open_keyboard_extended as:
 *   open_keyboard_extended(mode, KB_BUFFER_BACKUP, 0, 169)
 * The valid options for mode are the KBSTATE_* #define's above
 */

/*open_keyboard_extended
void open_keyboard_extended(unsigned char mode, unsigned char backup, int x, int y);
 *  Allows more control over the operation of the keyboard.
 *  mode - initial keyboard mode; see the KBSTATE_* #define's above
 *  backup - LCD backup method; see the KB_*_BACKUP #define's above
 *  x - x location of keyboard top left (usually 0)
 *  y - y location of keyboard top left (anything between 0 & 169, ?usually 169?)
 * WARNING ON VALUES OF X & Y:
   verified valid range for x: 0-1
   verified valid range for y: 0-169
   IF YOU SPECIFY X OR Y OUTSIDE THIS RANGE, THE KEYBOARD MAY OR MAY NOT WORK!
   THE KEYBOARD DOES NOT VERIFY THAT X & Y ARE IN THIS RANGE
 */

/*keyboard_is_open
char keyboard_is_open();
 * Returns 1 if keyboard is open
 *         0 if not
 */

/*close_keyboard
void close_keyboard();
 * Restores the LCD according to the backup method specified when the keyboard
 *    was opened and resets some state variables
 */

/*check_keyboard
unsigned char check_keyboard(int key, int x, int y);
 * The "meat" of the keyboard code.
 * key - value returned by GetKey (PENDOWN, ADDRESS, etc...)
 * penx - x location from GetKey
 * peny = y location from GetKey
 *
 * Called after a GetKey() as in:
 *   k = GetKey(&penx,&peny);
 *   c = check_keyboard(k,penx,peny);
 * If a key was pressed, it will return the char value of the key.  If no key
 *  was detected or a "control key" (caps, shift, symbol, accents) was pressed
 *  it will return 0
 *
 * See KBKEY* #define's above for values of \n, \t, & backspace
 */

#endif