#include <avsys.h>
#include <avgui.h>
#include <avicons.h>

#define cmAbout 0x2000
#define cmOther 0x2001
#define cmExit  0x2002
#define cmOff   0x2003
#define nbmax   34

int id=100;
int ExitCode = APPLICATION;
unsigned int ibank=0;
extern unsigned int image, look, open, blink;

char line[255];
char* message;
int pos, lastpos;
int ind, lastind;
int liney;
int flag ,start;

PDESKBOX *dsk;
PBUTTON *Other;
PBUTTON *Off;
PMENUFIELD *MenuFld;

#pragma codeseg
MENUITEM MainMenu[]=
{
    {"Jedi Wisdom", cmOther,  lstDisplay},
    {"Exit",  cmExit,   lstDisplay | lstUnderLine},
    {"Power Off",   cmOff,    lstDisplay},
    {"\0", 0, 0}
};

static char Btn1Label[]="Jedi Wisdom";
static char Btn2Label[]="Off";
static char WindowTitle[]="Jediware";
#pragma defaultseg

const char *sentence[] =
{
    "A Jedi must have the deepest commitment, the most serious mind.",
    "Adventure. Heh! Excitement. Heh! A Jedi craves not these things.",
    "A Jedi's strength flows from the Force.",
    "Beware the Dark Side.",
    "Anger. Fear. Aggression. The Dark Side of the Force are they.",
    "Once you start down the Dark Path, forever will it dominate your destiny, consume you it will...",
    "The Dark Side is quicker, easier, more seductive.",
    "A Jedi uses the Force for knowledge and defense, never for attack.",
    "You must unlearn what you have learned.",
    "Try not. Do, or do not. There is no try.",
    "Size matters not.",
    "My ally is the Force. And a powerful ally it is.",
    "Luminous beings are we, not this crude matter!",
    "You must feel the force around you.",
    "Control! You must learn control!",
    "Ready are you? What know you of ready?",
    "Why wish you become Jedi?",
    "Help you I can, yes.",
    "Patience!",
    "Wars not make one great.",
    "Concentrate!",
    "Fear is the path to the Dark Side.",
    "Fear leads to anger, anger leads to hate, hate leads to suffering.",
    "Always two there are, no more, no less... a Master and an Apprentice.",
    "May the Force be with you.",
    "Hard to see, the Dark Side is.",
    "Concentrate... feel the Force flow.",
    "Through the Force, things you will see. Other places. The future... the past. Old friends long gone.",
    "Only a fully trained Jedi Knight with the Force as his ally will conquer.",
    "If you end your training now, if you choose the quick and easy path, you will become an agent of evil.",
    "Mind what you have learned. Save you it can.",
    "When nine hundred years old you reach, look as good you will not.",
    "That is the way of things ... the way of the Force.",
    "Already know you that which you need."
};

void new_sentence()
{
    message=sentence[random(nbmax)];
    FillRect(1,16,158,85,DRAW_WHITE);
    SetFontType(PRPFONT11N);
    ind=pos=lastpos=lastind=flag=start=0;
    liney=16;
    for(ind=0; ind<=strlen(message) ; ind++)
    {
        line[pos++]=message[ind];
        if ((message[ind]==' ') | (message[ind]=='\0'))
        {
            line[pos]='\0';
            if (GetStringLength(line,PRPFONT11N) < 152)
            {
                lastpos=pos;
                lastind=ind;
            }
            else
            {
                flag=1;
            };
        }

        if ((flag==1)|(message[ind]=='\0'))
        {
            pos=0;
            ind=lastind;

            line[lastpos]='\0';
            WriteAlignString(4,liney,line,156,ALIGN_LEFT,0);
            liney+=11;
            flag=0;
        };
    }
}


void dsk_draw(VOID_PTR view)
{
    PDESKBOX_draw(view);
    AssignBankNo(image, ibank);
    DrawIcon(40, 86, ibank, &image, 0);
    new_sentence();
}


void move_eyes()
{

    switch(random(3))
    {
        case 0 :
            AssignBankNo(look, ibank);
            DrawIcon(70, 105, ibank, &look, 0);
            break;

        case 1 :
            AssignBankNo(blink, ibank);
            DrawIcon(70, 105, ibank, &blink, 0);
            break;

        case 2 :
            AssignBankNo(open, ibank);
            DrawIcon(70, 105, ibank, &open, 0);
            break;

        default:
            break;
    }
}




void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y)
{
    PDESKBOX_handleEvent(view,evType,x,y);

    if (*evType == evTimer)
    {
        move_eyes();
    }


    if (*evType == evCommand)
    {
        switch(TOWORD(x,y))
        {
            case cmOther :
                new_sentence();
                break;

            case cmExit :
                PutEvent(evCommand, HIGBYTE(cmQuit),LOWBYTE(cmQuit));
                break;

            case cmOff :
                _asm
                {
                    push af
                    call    0x002D
                    WAIT:           ld      a,(0xC05D)
                    and     a
                    jr      nz,WAIT
                    pop af
                };
                new_sentence();
                break;

            default:
                break;
        }
    }
}


int main()
{
    dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239,
                                    MK_FAR_PTR(WindowTitle),MK_FAR_PTR(MainMenu), NULL_FP,
                                    bafClose | bafDotTitle | bafComLine);

    InsertButton(dsk, id++, MK_FAR_PTR(Btn1Label), cmOther, bttBasic, 0);
    InsertButton(dsk, id++, MK_FAR_PTR(Btn2Label), cmOff,   bttBasic, 2);

    BankedAssign1(dsk->draw,dsk_draw);
    BankedAssign2(dsk->handleEvent,dsk_handleEvent);

    ExecView((PGROUP_PTR) dsk);
    Destroy((VOID_PTR) dsk);
    return ExitCode;
}
