void say_to()
{
     _asm
     {

         push af         /* save registers */
         push bc
         push hl
         push de
         di              /* disable interruption */

         ld hl,#sample   /* sample starting adr */
         ld bc,#0x1c6    /* sample lenght */

play:    ld e,#0x8       /* 8 bits to analyse */
         ld d,(hl)       /* take a byte */
playb:   sra d           /* shift right */
         jr nc,reset     /* bit = 0 ? */

set:     ld a,(#0xc00d)  /* buzzer = 1 */
         or #0x08
         out (#0x28),a
         jr suite

reset:   ld a,(#0xc00d)  /* buzzer=0 */
         and #0xf7
         out (#0x28),a

suite:   ld a,#0x1a       /* delay */
loop:    nop
         nop
         nop
         nop
         dec a
         jr nz,loop

         dec e           /* last bit ? */
         jr nz, playb
         inc hl          /* next byte */
         dec bc          /* last byte ? */
         ld a, b
         or c
         jr nz, play

         ei              /* enable interruptions */
         pop de          /* restore registers */
         pop hl
         pop bc
         pop af
         jp end

sample:

.db 0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
.db 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
.db 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
.db 0x5a,0x52,0x92,0x0,0x90,0x0,0x69,0xc9,0x84,0x84,0x90,0x0,0xb0,0x65,0x49,0x22
.db 0x21,0x69,0x93,0x24,0x48,0x9,0x94,0x40,0x0,0x1,0x52,0x4a,0x26,0x49,0x2,0x81
.db 0x24,0x49,0x2,0x24,0x81,0x40,0x12,0x24,0x92,0x0,0x0,0x0,0x40,0x82,0x24,0x81
.db 0x4c,0x12,0x0,0x0,0x1b,0x0,0x60,0xd7,0xc1,0x44,0xda,0xc,0x98,0xbb,0x1,0x9b
.db 0x89,0x34,0x13,0x20,0x76,0x43,0x6e,0x32,0xeb,0x66,0x86,0xcc,0xc,0xd9,0x64,0xe6
.db 0xcd,0x0,0xb8,0x99,0xf0,0x93,0x99,0x77,0x33,0xe3,0x66,0xc6,0xcf,0xcc,0xfc,0x19
.db 0x9,0x37,0x33,0xb2,0x4c,0x64,0x9f,0x9,0x40,0x3b,0x81,0xdf,0xcc,0xec,0x9b,0x89
.db 0x38,0x33,0xf1,0x99,0x89,0x7d,0x33,0x22,0x66,0x46,0x3e,0x33,0xb1,0x6d,0x44,0xe4
.db 0xdc,0xc8,0x6f,0x66,0xe6,0x8d,0x89,0xb9,0x33,0xf3,0xc9,0xc8,0x7c,0x13,0x40,0x6e
.db 0x6,0x3c,0x33,0x33,0xcf,0x4,0x90,0x9b,0x0,0xcf,0xcc,0xcc,0x33,0x9,0xec,0x26
.db 0x92,0x27,0x22,0xf7,0x4c,0x0,0xbb,0x9,0xe4,0xc9,0xcc,0x35,0x13,0xc0,0x6e,0x2
.db 0x39,0x32,0xf3,0xcd,0x4,0xb1,0x7b,0x64,0xce,0xcc,0x3c,0x33,0x1,0x66,0x6,0xf9
.db 0x99,0x99,0x6e,0x46,0x84,0x99,0x1,0x7e,0x22,0xd2,0xcd,0x48,0xe4,0x97,0xc8,0x67
.db 0x26,0x99,0x19,0x40,0x76,0x13,0x79,0x66,0x96,0x9b,0x1,0xe4,0x3f,0x91,0x67,0x26
.db 0x99,0x9,0x40,0xfe,0x11,0x3d,0x23,0xd9,0x19,0x40,0xb4,0x9b,0xe0,0x13,0xc3,0xcc
.db 0x60,0xa2,0x99,0x44,0xce,0x48,0x66,0x12,0x11,0xec,0x30,0x72,0x2,0x98,0xcb,0xc
.db 0x32,0x9f,0xf9,0x19,0xc8,0x2c,0x3,0xc8,0x67,0x82,0x27,0x90,0xf3,0xc,0x60,0x9f
.db 0xc1,0x4d,0x60,0x36,0x11,0xc8,0x76,0x12,0xcf,0x60,0x7e,0x13,0xc8,0x66,0x33,0x4d
.db 0x20,0xbf,0x81,0x60,0xbe,0xc1,0x32,0x90,0xdf,0x40,0xb0,0xcd,0xe4,0x0,0xa4,0x97
.db 0x0,0x2c,0x3,0x11,0x80,0x76,0x10,0x88,0xef,0xb0,0x0,0x24,0x7,0x80,0x6c,0xe
.db 0x4,0x80,0xb9,0x0,0x92,0xb,0x8,0x0,0xf3,0x1,0x20,0x3e,0x8,0x0,0xf2,0x1
.db 0x20,0x3c,0x0,0x0,0xe0,0x3,0x0,0x26,0x0,0x0,0xfc,0x0,0x80,0x0,0x0,0x0
.db 0x2,0x0,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
.db 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
.db 0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
.db 0x0,0x0,0x0,0x0,0x0
.db 0x0

end:

     }
}
