/*
 * VoiceClock.c - Avigo Voice Clock 
 * Copyright (C) 2001 Jean-michel Bunouf (jeanmichel.bunouf@oreka.com)
 * 
 * The program is freely distributable.  
 * This means that you have permission to use, copy or distribute 
 * this software and its documentation.  You do not have permission 
 * to charge anything other than a duplication fee for distributing 
 * copies of this software.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * */

#include <avsys.h>
#include <avdata.h>
#include <avgui.h>
#include "voiceclock.h"

#define cmAbout 0x2000
#define cmSay   0x2001
#define cmMode  0x2002
#define cmDate  0x2003
#define cmOff   0x2004

#pragma codeseg
static char Btn1Label[]="Say time";
static char Btn2Label[]="Off";
static char WindowTitle[]="Avigo Voice Clock";
static char AboutMessage[]="Avigo Voice Clock\n\nCopyright (c) 2001\nJean-michel Bunouf";
#pragma defaultseg


MENUITEM MainMenu[]=
{
   {"Say time",      cmSay,    lstDisplay},
   {"dd/mm/yyyy",          cmDate,   lstDisplay},
   {"24h mode",      cmMode,   lstDisplay},
   {"About...",      cmAbout,  lstDisplay | lstUnderLine}, 
   {"Power Off",     cmOff,    lstDisplay},
   {"Exit",       cmQuit,   lstDisplay},
   {"\0", 0, 0} 
};

int id=100;
PDESKBOX *dsk;
PMENUFIELD *MenuFld;
unsigned char flag=(1==1);

extern unsigned int bmp0, bmp1, bmp2, bmp3, bmp4, bmp5, bmp6, bmp7, bmp8, bmp9, bmpam, bmppm;
extern unsigned int s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

struct {
  unsigned int bank;
  unsigned int *image;
} BitmapTime [12];

struct {
  unsigned int bank;
  unsigned int *image;
} BitmapDate [10];

struct {
  unsigned char disp24h;
  unsigned char dispmmdd;
} Prefs;



void UpdateMenu()
{
 if (Prefs.disp24h)
  strcpy(MainMenu[2].item,"12h mode");
 else
  strcpy(MainMenu[2].item,"24h mode");

 if (Prefs.dispmmdd)
  strcpy(MainMenu[1].item,"dd/mm/yyyy");
 else
  strcpy(MainMenu[1].item,"mm/dd/yyyy");
}


void LoadPreferences()
{
 /* load application preferences */
 if (GetPreferenceLen(CurrentAppID))
  ReadPreference(CurrentAppID, 0, &Prefs, sizeof(Prefs));
 else
 {  
  Prefs.disp24h=(1==0);
  Prefs.dispmmdd=(1==1);
 };
 UpdateMenu();
}


void SavePreferences()
{
 /* write out the application preferences */
 SavePreference(CurrentAppID, &Prefs, sizeof(Prefs));
}


void displaytime()
{
 unsigned char ch1,ch2,ch3,ch4,temp,i;
 int year;

 _TIME time;
 _DATE date;

 GetTime(&time);
 GetDate(&date);

 /* displays am or pm if necessary */
 
 if (Prefs.disp24h)
 {
  FillRect(100,90,134,113, DRAW_WHITE);
 }
 else
 {
  if (time.hour>12) 
  {
  time.hour=time.hour-12;
  DrawIcon( 100, 90, BitmapTime[11].bank, BitmapTime[11].image,PUT);
  }
  else DrawIcon( 100, 90, BitmapTime[10].bank, BitmapTime[10].image,PUT);
 };

 /* displays month and day */

 ch1=date.day/10;
 ch2=date.day - ch1*10;
 ch3=date.month/10;
 ch4=date.month - ch3*10;
 if (Prefs.dispmmdd)
 {
  temp=ch1;
  ch1=ch3;
  ch3=temp;
  temp=ch2;
  ch2=ch4;
  ch4=temp;
 };

 SetLineSize(2);

 DrawIcon( 6, 170, BitmapDate[ch1].bank, BitmapDate[ch1].image,PUT);
 DrawIcon( 22, 170, BitmapDate[ch2].bank, BitmapDate[ch2].image,PUT);
 
 DrawLine(42,181,40,181,DRAW_BLACK);

 DrawIcon( 46, 170, BitmapDate[ch3].bank, BitmapDate[ch3].image,PUT);
 DrawIcon( 62, 170, BitmapDate[ch4].bank, BitmapDate[ch4].image,PUT);

 /* displays year */

 year=date.year + 1901;  /* 0 ->1901 198->2001 */
 ch1=year/1000;  
 ch2=(year - (ch1*1000))/100;
 ch3=(year - (ch1*1000)-(ch2*100))/10;
 ch4=year - (ch1*1000)-(ch2*100)-(ch3*10);

        DrawLine(82,181,80,181,DRAW_BLACK);

 DrawIcon( 86, 170, BitmapDate[ch1].bank, BitmapDate[ch1].image,PUT);
 DrawIcon( 102, 170, BitmapDate[ch2].bank, BitmapDate[ch2].image,PUT);
 DrawIcon( 118, 170, BitmapDate[ch3].bank, BitmapDate[ch3].image,PUT);
 DrawIcon( 134, 170, BitmapDate[ch4].bank, BitmapDate[ch4].image,PUT);


 /* displays time */

 ch1=time.hour/10;
 ch2=time.hour - ch1*10;
 DrawIcon( 6, 36, BitmapTime[ch1].bank, BitmapTime[ch1].image,PUT);
 DrawIcon( 40, 36, BitmapTime[ch2].bank, BitmapTime[ch2].image,PUT);
 
 ch1=time.minute/10;
 ch2=time.minute - ch1*10;
 DrawIcon( 86, 36, BitmapTime[ch1].bank, BitmapTime[ch1].image,PUT);
 DrawIcon( 118, 36, BitmapTime[ch2].bank, BitmapTime[ch2].image,PUT);
 
 /* displays seconds spots and bargraph */

 flag= !flag;
 if (flag) 
 {
  FillRect (80,46,84,50,DRAW_BLACK);
  FillRect (76,68,80,72,DRAW_BLACK);
 }
 else  
 {
  FillRect (80,46,84,50,DRAW_WHITE);
  FillRect (76,68,80,72,DRAW_WHITE);
 }
 
 SetLineSize(0);
 DrawLine(1,148,158,148,DRAW_GRAY);

 for (i=0; i<59; i++)
 {
  if (i<=time.second) DrawLine (10+i<<1, 127, 10+i<<1, 134,DRAW_BLACK); 
   else DrawLine (10+i<<1, 127, 10+i<<1, 134,DRAW_WHITE);
 }

 WriteChar(16,135,1,0);
 WriteChar(132,135,1,0);

}


void initbmp()
{
 AssignBankNo(bmp0, BitmapTime[0].bank);
   BitmapTime[0].image=&bmp0;
 AssignBankNo(bmp1, BitmapTime[1].bank);
   BitmapTime[1].image=&bmp1;
 AssignBankNo(bmp2, BitmapTime[2].bank);
   BitmapTime[2].image=&bmp2;
 AssignBankNo(bmp3, BitmapTime[3].bank);
   BitmapTime[3].image=&bmp3;
 AssignBankNo(bmp4, BitmapTime[4].bank);
   BitmapTime[4].image=&bmp4;
 AssignBankNo(bmp5, BitmapTime[5].bank);
   BitmapTime[5].image=&bmp5;
 AssignBankNo(bmp6, BitmapTime[6].bank);
   BitmapTime[6].image=&bmp6;
 AssignBankNo(bmp7, BitmapTime[7].bank);
   BitmapTime[7].image=&bmp7;
 AssignBankNo(bmp8, BitmapTime[8].bank);
   BitmapTime[8].image=&bmp8;
 AssignBankNo(bmp9, BitmapTime[9].bank);
   BitmapTime[9].image=&bmp9;
 AssignBankNo(bmpam, BitmapTime[10].bank);
   BitmapTime[10].image=&bmpam;
 AssignBankNo(bmppm, BitmapTime[11].bank);
   BitmapTime[11].image=&bmppm;

 AssignBankNo(s0, BitmapDate[0].bank);
   BitmapDate[0].image=&s0;
 AssignBankNo(s1, BitmapDate[1].bank);
   BitmapDate[1].image=&s1;
 AssignBankNo(s2, BitmapDate[2].bank);
   BitmapDate[2].image=&s2;
 AssignBankNo(s3, BitmapDate[3].bank);
   BitmapDate[3].image=&s3;
 AssignBankNo(s4, BitmapDate[4].bank);
   BitmapDate[4].image=&s4;
 AssignBankNo(s5, BitmapDate[5].bank);
   BitmapDate[5].image=&s5;
 AssignBankNo(s6, BitmapDate[6].bank);
   BitmapDate[6].image=&s6;
 AssignBankNo(s7, BitmapDate[7].bank);
   BitmapDate[7].image=&s7;
 AssignBankNo(s8, BitmapDate[8].bank);
   BitmapDate[8].image=&s8;
 AssignBankNo(s9, BitmapDate[9].bank);
   BitmapDate[9].image=&s9;
}


void say_time()
{


 /* get time */

 _TIME time;
 GetTime(&time);


 /* say "it is" */

 say_it_is();


 /* say minutes */

 if ((time.minute>=3 & time.minute<8) | (time.minute>=53 & time.minute<58))  
  say_n05();
 if ((time.minute>=8 & time.minute<13) | (time.minute>=48 & time.minute<53))  
  say_n10();
 if ((time.minute>=13 & time.minute<18) | (time.minute>=43 & time.minute<48)) 
  say_n15();
 if ((time.minute>=18 & time.minute<23) | (time.minute>=38 & time.minute<43)) 
  say_n20();
 if ((time.minute>=23 & time.minute<28) | (time.minute>=33 & time.minute<38)) 
  { 
  say_n20(); 
  say_n05();
  };
 if (time.minute>=28 & time.minute<33)
  say_half();


 /* say past or to */

 if (time.minute>=3 & time.minute<33)
  say_past();
 if (time.minute>=33 & time.minute<58)
  say_to();
 if (time.minute>=33 & time.minute<=59)
    {
  time.hour=time.hour+1;
  if (time.hour==24) time.hour=0;
    };
  

 /* say hours */

 if (time.hour==1 | time.hour==13)
  say_n01();
 if (time.hour==2 | time.hour==14)
  say_n02();
 if (time.hour==3 | time.hour==15)
  say_n03();
 if (time.hour==4 | time.hour==16)
  say_n04();
 if (time.hour==5 | time.hour==17)
  say_n05();
 if (time.hour==6 | time.hour==18)
  say_n06();
 if (time.hour==7 | time.hour==19)
  say_n07();
 if (time.hour==8 | time.hour==20)
  say_n08();
 if (time.hour==9 | time.hour==21)
  say_n09();
 if (time.hour==10 | time.hour==22)
  say_n10();
 if (time.hour==11 | time.hour==23)
  say_n11();
 if (time.hour==12)
  say_n12();
 if (time.hour==0)
  say_midnight();

 /* pause */

 Delay_10ms();
 Delay_10ms();
 Delay_10ms();
 Delay_10ms();
 Delay_10ms();

 /* say am or pm */

 if (time.hour>0 & time.hour<12) 
  say_am();
 if (time.hour>12) 
  say_pm();



}



void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y)
{  
 PDESKBOX_handleEvent(view,evType,x,y); 
 
 if (*evType == evCommand)
 {
     switch(TOWORD(x,y))
     {
  case cmSay :
   say_time();
   break;
  case cmMode :
   Prefs.disp24h=! Prefs.disp24h;
   UpdateMenu();
   break;
    case cmDate :
   Prefs.dispmmdd=! Prefs.dispmmdd;
   UpdateMenu();
   break;
  case cmAbout :
          MessageBox(AboutMessage, mfInformation | mfOKButton);
          break;
  case cmOff :
   _asm
   {
    push af
    call    0x002D           
          WAIT:  ld      a,(0xC05D)       
                  and     a               
                  jr      nz,WAIT
    pop af
   };
   break;
  default:
   break;
  }
    }

 if (*evType == evTimer)
 {
  displaytime();
 }

}


int main()
{

 LoadPreferences();
 initbmp();

 dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239, 
        MK_FAR_PTR(WindowTitle),MK_FAR_PTR(MainMenu), NULL_FP,
        bafClose | bafDotTitle | bafComLine); 
 InsertButton(dsk, id++, MK_FAR_PTR(Btn1Label), cmSay, bttBasic, 0);
 InsertButton(dsk, id++, MK_FAR_PTR(Btn2Label), cmOff, bttBasic, 2);
 BankedAssign2(dsk->handleEvent,dsk_handleEvent);
 ExecView((PGROUP_PTR) dsk);
 Destroy((VOID_PTR) dsk);
 
 SavePreferences();

 return APPLICATION;
}
