/*
 * Vexed v1.4 - system.c "Application independant stuff"
 * Copyright (C) 1999 James McCombe (cybertube@earthling.net)
 *
 * Adaptation for the Avigo
 * Copyright (C) 2001 Jean-michel Bunouf (jeanmichel.bunouf@oreka.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#include <avsys.h>
#include <avdata.h>
#include <avgui.h>

#include "protos.h"

extern struct {
	Boolean
		PieceMoveAnim, /* whether the movement of a piece by the user is animated */
		GravityAnim, /* whether the gravity effect is animated */
		EliminationAnim, /* whether piece elimination is animated */
		Sound; /* whether sound is on or off */
	int CurrentLevel, SolvedLevels; /* stores the level the user was last at */
} VexedPreferences;



void LoadPreferences()
{
/* load application preferences into the structure shown above */

 if (GetPreferenceLen(CurrentAppID))
    ReadPreference(CurrentAppID, 0, &VexedPreferences, sizeof(VexedPreferences));
 else
	{
    VexedPreferences.PieceMoveAnim = 1;
    VexedPreferences.GravityAnim = 1;
    VexedPreferences.EliminationAnim = 1;
    VexedPreferences.CurrentLevel = 0;
    VexedPreferences.SolvedLevels = 0;
    }
}

void SavePreferences()
{
/* write out the application preferences */
SavePreference(CurrentAppID, &VexedPreferences, sizeof(VexedPreferences));
}
