/*
 * Vexed v1.4 - sound.c "Sound specific code for vexed"
 * Copyright (C) 1999 James McCombe (cybertube@earthling.net)
 *
 * Adaptation for the Avigo
 * Copyright (C) 2001 Jean-michel Bunouf (jeanmichel.bunouf@oreka.com)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#include <avsys.h>
#include <avdata.h>
#include <avgui.h>

#include "protos.h"

extern struct {
	Boolean
		PieceMoveAnim, /* whether the movement of a piece by the user is animated */
		GravityAnim, /* whether the gravity effect is animated */
		EliminationAnim, /* whether piece elimination is animated */
		Sound; /* whether sound is on or off */
	int CurrentLevel, SolvedLevels; /* stores the level the user was last at */
} VexedPreferences;

void SoundEffect(int effect)
{
int s,volume=1;

if (VexedPreferences.Sound) 
	{
	if (effect == HighBeep)
		{
		Buzzer(7,1);
		}

	if (effect == LowBeep)
		{
		Buzzer(5,1);
		}

	if (effect == HighSweepLow)
		{
		for (s = 7; s >= 1; s -= 1)
		Buzzer(s,1);
		}
	}
else
	Delay_10ms();
	Delay_10ms();
}
