/*********************************

    AVGUI Library Hello Program
        for use with FWSDK
 Public Domain - Randy Gill 11/99

********************************************************

This app is a demonstration of the Avgui library, and
will display a DeskBox (window).  It is released to the
public domain with the hope that it will be helpful as
an example.

********************************************************/

#include <avsys.h>
#include "avgui.h"

/* Create our user-defined commands */

#define cmHello 0x2000

/* Define resource ID counter variable.  This is incremented during each
'Create...' to ensure each control has a unique ID. If this were a large
application, we'd use a different technique and store the ID for each
control so we could reuse their memory blocks */

int id=100;

char Message[]="Hello, World";
char WindowTitle[]="GUI Hello World";

/* Avigo apps return a code indicating the program to run next.  APPLICATION
indicates the apps. menu */

int ExitCode = APPLICATION;

/* Define our main menu.  Every Avigo menu has {"\0", 0, 0} as the last item. */

MENUITEM MainMenu[]=
{
   {"Say Hello", cmHello, lstDisplay},
   {"Exit", cmCancel, lstDisplay},
   {"\0", 0, 0} 
};

/* Declare pointer for our DeskBox */

PDESKBOX *dsk;

/* Replacement event handler for DESKBOX.  This is where we do what we
need to do in response to the events we receive */

void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{  

/* Do default handling (process pen events, etc...) */

   PDESKBOX_handleEvent(view,evType,x,y); 

/* For this app, we're only interested in the 'command' events */

   if (*evType == evCommand)
   {
      switch(TOWORD(x,y)) /* TOWORD combines the 8-bit 'x' and 'y' into one
                             16-bit value, the 'command'. */
      {
         case cmHello :
                           MessageBox(Message, mfInformation | mfOKButton);
                           break;
      }
   }
}

/* Here's where our main program starts */

int main()
{

/* First we create our DeskBox */

   dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239, 
      MK_FAR_PTR(WindowTitle),MK_FAR_PTR(MainMenu), NULL_FP,
      bafClose | bafDotTitle ); 

/* Now we will assign the handler we implemented earlier to our DeskBox.
There are two functions that do this.  Use 'BankedAssign1()' if your handler
has only one argument, and 'BankedAssign2()' if it has two or more.  A handler
will never have zero arguments.  Note: two functions are needed because of the
differences in the way parameters are passed in the FWSDK and in the Avigo
internally. The 'Official $DK' uses just one: BankedAssign()*/

   BankedAssign2(dsk->handleEvent,dsk_handleEvent);

/* Here's the 'magic' function that does most of the work of the program.
ExecView() will draw, and redraw when needed, our deskbox and all our controls.
It will continuously poll for pen and button input, then send messages to the
controls and the DeskBox itself, and invoke their handlers.  It will exit when
it processes a cmCancel or cmQuit command message. */

   ExecView((PGROUP_PTR) dsk);

/* Finally, we'll 'destroy' the DeskBox to free up its resource memory. */

   Destroy((VOID_PTR) dsk);

/* Hey, we're done! That wasn't so bad, was it? */
  
   return ExitCode;

}
