#include <avsys.h>
#include <avgui.h>
#include <avicons.h>

#define cmAbout 0x2000
#define cmOther 0x2001
#define cmExit  0x2002
#define cmOff   0x2003
#define nbmax   180

int id=100;
int ExitCode = APPLICATION;
unsigned int ibank=0;
extern unsigned int image;

char line[255];
char* message; 
int pos, lastpos;
int ind, lastind; 
int liney;
int flag ,start;

PDESKBOX *dsk;
PBUTTON *Other;
PBUTTON *Off;
PMENUFIELD *MenuFld;

#pragma codeseg
MENUITEM MainMenu[]=
{
   {"An other one...", cmOther,  lstDisplay},
   {"About...", cmAbout,  lstDisplay},
   {"Exit",  cmExit,   lstDisplay | lstUnderLine},
   {"Power Off",   cmOff,    lstDisplay},
   {"\0", 0, 0} 
};
static char Btn1Label[]="An other one !";
static char Btn2Label[]="Off";
static char WindowTitle[]="M.O.D. with Dilbert";
static char AboutMessage[]="Dilbert(c) Scott Adams\nMOD 2001(c) JM Bunouf";
#pragma defaultseg

const char *sentence[] = {
"Computing Definition: Access Time - The time between the instant at which information is called for, and the instant at which management expects the final report.",
"Computing Definition: Assembler - One who drops his card deck.",
"Computing Definition: Bit - The increment by which programmers slowly go mad.",
"Computing Definition: Breakpoint - The point at which programmer increments past last bit available.",
"Computing Definition: Chaining - A method of attaching programmers to desk, to speed up output.",
"Computing Definition: Checkpoint - The location from which a programmer draws his salary.",
"Computing Definition: Core storage - A receptacle for the center section of apples.",
"Computing Definition: Counter - An area over which martini's are served.",
"Computing Definition: Crash - What a detached programmer would dearly love to do, for at least eight hours.",
"Computing Definition: Default - De line west of which de state of california will float off to sea at de next major quake.",
"Computing Definition: Device - Medieval torture instrument such as thumbscrew, iron maiden.",
"Computing Definition: Documentation - A manual which tells you how to use a program, system, or utility one version ago, and which is now unsupported.",
"Computing Definition: Error - What someone else has made when they disagree with your computer output.",
"Computing Definition: External Storage - Wastebasket.",
"Computing Definition: Fixed Word Length - Four letter word used by programmers in a state of confusion.",
"Computing Definition: Hardware - Nuts, bolts, and circuit boards 'left over' after repairman has reassembled cpu.",
"Computing Definition: I/O Device - Note you sign for the bank in/order to get loan for new (old) car.",
"Computing Definition: Library - An organized collection of obsolete material.",
"Computing Definition: Low Order Position - The programmer's location in the chain of command.",
"Computing Definition: Mainframe - Primary person who just got set up for the blame of the system crash.",
"Computing Definition: Microsecond - Amount of time needed for a program to bomb.",
"Computing Definition: Nanosecond - Measure of time on mork's planet ork.",
"Computing Definition: Off-Line - Uncharitable remarks programmer makes to wife or husband upon being phoned at 9pm to come in because system just crashed.",
"Computing Definition: On-Line - Programmer trying to deal rationally on phone with management at 9pm.",
"Computing Definition: Peripheral - Now you see it, now you don't...",
"Computing Definition: Printout - A document to verify data you know is wrong anyway.",
"Computing Definition: Programmer - Red eyed mumbling mammal, capable of communicating with inanimate objects.",
"Computing Definition: Source file - One which was 'appropriated' from one of the competitors.",
"Computing Definition: Switch - When management changes its mind.",
"Rules of the game: 1) You can't win.  2) You can't break even.  3) You can't even quit the game.",
"Rules of the game: A faithful car will continue to be faithful until the day you fit it with four brand new tyres, then it will fall apart.",
"Rules of the game: An authority is somebody who can tell you more about something than you really care to know.",
"Rules of the game: Any given program will expand to fill all available resources.",
"Rules of the game: Any given program, once running, is obsolete.",
"Rules of the game: Anything free is worth what you pay for it.",
"Rules of the game: Army Axiom: An order that can be misunderstood will be misunderstood.",
"Rules of the game: Army Law: If it moves, salute it; If it doesn't move, pick it up; If you can't pick it up, paint it.",
"Rules of the game: Basic research is what I am doing when - I don't know what I am doing.",
"Rules of the game: Do not believe in miracles - rely on them.",
"Rules of the game: Don't force it, get a large hammer.",
"Rules of the game: Experiments should be reproducable, - they should all fail in the same way.",
"Rules of the game: Finagle's First Law: If an experiment works, something has gone wrong.",
"Rules of the game: Finagle's Fourth Law: Once a job is messed up, anything done to improve it makes it worse.",
"Rules of the game: First Law of Advice: The correct advice is to give the advice that is desired.",
"Rules of the game: Friends may come and go, but enemies accumulate.",
"Rules of the game: I have yet to see any problem, which, when you looked at it the right way, did not become still more complicated.",
"Rules of the game: If a program is useful, it will have to be changed.",
"Rules of the game: If a program is useless, it will have to be documented.",
"Rules of the game: If an experiment works, you must be using the wrong equipment.",
"Rules of the game: If at first you don't succeed, give up.",
"Rules of the game: If at first you don't succeed, blame the teacher.",
"Rules of the game: If at first you don't succeed, try something else.",
"Rules of the game: If at first you don't succeed, try, try again. Then give up.",
"Rules of the game: If it can be borrowed and it can be broken, you will borrow it and you will break it.",
"Rules of the game: If little else, the brain is an educational toy. - Tom Robbins",
"Rules of the game: If you do something which you are sure will meet with everyone's approval, somebody won't like it.",
"Rules of the game: If you explain so clearly that no one can misunderstand, somebody will.",
"Rules of the game: If you put your supper dish to your ear you can hear the sounds of a restaurant. - Snoopy.",
"Rules of the game: If you want your name spelt wrong, die.",
"Rules of the game: In any household, junk accumulates to fill the storage space available.",
"Rules of the game: In case of doubt, make it sound convincing.",
"Rules of the game: Incompetence knows no barriers of time or place.",
"Rules of the game: Information travels more surely to those with a lesser need to know.",
"Rules of the game: It does not matter if you fall down as long as you pick something from the floor when you get up.",
"Rules of the game: It is better for civilisation to be going down the drain than to be coming up it.",
"Rules of the game: It works better when you turn the brightness up.",
"Rules of the game: Live within your income, even if you have to borrow to do it.",
"Rules of the game: Monday is a hard way to spend one-seventh of your life.",
"Rules of the game: Murphy's Eighth Law: If everything seems to be going well, you have obviously overlooked something.",
"Rules of the game: Murphy's Fifth Law: If anything just cannot go wrong, it will anyway.",
"Rules of the game: Murphy's First Law: Nothing is as easy as it looks.",
"Rules of the game: Murphy's Second Law: Everything takes longer than you think.",
"Rules of the game: Murphy's Seventh Law: Left to themselves, things tend to go from bad to worse.",
"Rules of the game: Murphy's Third Law: Anything that can go wrong will go wrong, and at the worst possible time.",
"Rules of the game: Negative slack tends to increase.",
"Rules of the game: Never go to a doctor who's office plants have died.",
"Rules of the game: Next to surviving an earthquake, nothing is quite so satisfying as as receiving a income tax refund ",
"Rules of the game: Nothing is impossible for the man who doesn't have to do it himself.",
"Rules of the game: Old age is always 15 years older than I am.",
"Rules of the game: On a beautiful day like this, it is hard to believe that anyone can be unhappy - but we're working on it.",
"Rules of the game: Parkinson's First Law: Work expands to fill the time available for its completion.",
"Rules of the game: Parkinson's Second Law: Expenditures rise to meet income.",
"Rules of the game: Patience is something that you admire greatly in the driver behind you but not in the one ahead of you.",
"Rules of the game: Program complexity grows until it exceeds the capability of the programmer who must maintain it.",
"Rules of the game: Pros are people who do jobs well even when they don't feel like it",
"Rules of the game: Speed bumps are of negligible effect when the vehicle exceeds triple the restraining speed.",
"Rules of the game: The Law of Selective Gravity (The Buttered Side Down Law): An object will fall so as to do the most damage.",
"Rules of the game: The chief cause of problems is solutions.",
"Rules of the game: The lagging activity in a project will invariably be found in the area where highest overtime rates lie waiting.",
"Rules of the game: The lion and the calf shall lie down together, but the calf won't get much sleep.",
"Rules of the game: The probability of anything happening is inversely proportional to its desirability.",
"Rules of the game: The usefulness of a meeting is inversely proportional to its attendance.",
"Rules of the game: There ain't no such thing as a free lunch.",
"Rules of the game: Two wrongs do not make a right; it usually takes three or more.",
"Rules of the game: Under the most rigorously controlled conditions, the experimental apparatus will do exactly as it pleases.",
"Rules of the game: Variables won't; constants aren't.",
"Rules of the game: When all else fails, read the manual.",
"Rules of the game: When things are going well, somebody will experiment detrimentally.",
"Rules of the game: When you try to make an impression, the chances are that that is the impression you will make.",
"Rules of the game: When your work speaks for itself, don't interrupt.",
"Rules of the game: Why can't lifes's big problems come when we are twenty and know everything ?",
"Rules of the game: You always find something in the last place you look.",
"Rules of the game: You can get ANYWHERE in ten minutes if you drive fast enough.",
"Rules of the game: You cannot successfully determine beforehand which side of the bread to butter.",
"Another ingredient for a happy marriage: Budget the luxuries first !",
"Another ingredient for a happy marriage: In a family argument, if it turns out you are right - apologise at once!",
"To stay young requires unceasing cultivation of the ability to unlearn old falsehoods.",
"Money is truthful. If a man speaks of his honour, make him pay cash.",
"Waking a person unnecessary should not be considered a capital crime. For a first offence, that is.",
"A skunk is better company than a person who prides himself on being 'frank.'",
"Sin lies only in hurting other people unnecessarily. All other 'sins' are invented nonsense. (Hurting yourself is not sinful - just stupid.)",
"Anything free is worth what you pay for it.",
"A committee is a life form with six or more legs and no brain.",
"Animals can be driven crazy by placing too many in too small a pen. Homo sapiens is the only animal that voluntarily does this to himself.",
"We, my Lords, may thank Heaven that we have something better than out brains to depend on. (Lord Chesterfield to the House of Lords)",
"In the beginning was the word - and the word was four bytes. (from the bible?)",
"Wars are not fought to decide who is right - only who is left.",
"To err is human - To really foul things up requires computers.",
"When I am right nobody remembers... When I am wrong nobody forgets!",
"If you can't tie good knots... tie many.",
"A lack of planning on your part does not constitute an emergency on my part.",
"What you can not avoid, Welcome.",
"Yesterday's a memory Tomorrow's a vision Today's a bitch",
"It is better to keep your mouth closed and let people think you are a fool than to open it and remove all doubt. - Samual Clemmens",
"Money wouldn't be so important if everybody didn't want some.",
"TO DO IS TO BE - Socrates TO BE IS TO DO - Sartre DO BE DO BE DO - Sinatra",
"Walk softly but carry a big stick.",
"A Wise Man can see more from the bottom of a well than a Fool can see from the top of a mountain.",
"When a finger points at the moon, the imbecile looks at the finger.",
"Live fast, Die young, Leave a good looking corpse.",
"Graffiti: I have a drink problem, I can't afford it.",
"Graffiti: I looked up my wife's family tree. Most of her relatives are still climbing around in it.",
"Graffiti: I used to be a schizophrenic, but now I'm lonely.",
"Graffiti: I'd give my right arm to be ambidextrous.",
"Graffiti: I'm immortal - so far.",
"Graffiti: If a woman wants to learn to drive, don't stand in her way.",
"Graffiti: Ironic isn't it, that God gave the tortoise a drag factor of 0.03.",
"Graffiti: Is there an imaginary cure for hypochondria?",
"Graffiti: It is now beyond any doubt that cigarettes are the biggest cause of statistics.",
"Graffiti: Join the army, travel the world, meet interesting people and shoot them.",
"Graffiti: Just because you're paranoid it doesn't mean they aren't out to get you.",
"Graffiti: Just when I was getting used to yesterday along came today.",
"Graffiti: Keep Britain tidy, shoot a tourist.",
"Graffiti: Laugh, and the world laughs with you. - Snore and you sleep alone.",
"Graffiti: Laugh, and the world thinks you are an idiot.",
"Graffiti: Life is a sexually transmitted disease.",
"Graffiti: Living on Earth is expensive, but it does include a free trip around the sun.",
"Graffiti: Lord give me patience......But Hurry!",
"Graffiti: Love Thy Neighbour - But don't get caught.",
"Graffiti: Love is blind. And when you get married you get your eyesight back.",
"Graffiti: Make love, not war; get married and do both!",
"Graffiti: Money isn't everything. - It isn't even enough!",
"Graffiti: My wife wears rubber gear and whips me. Ohhhhh Kay!",
"Graffiti: Neurotics build castles in the air. Psychotics live in them, and Psychiatrists charge them rent.",
"Graffiti: Never put off till tomorrow what you can avoid altogether.",
"Graffiti: No one feels as helpless as the owner of a sick goldfish.",
"Graffiti: People in glass houses shouldn't throw stones. Neither should they nail up pictures.",
"Graffiti: Racial prejudice is a pigment of the imagination",
"Graffiti: Real Ale - reaches the parts Heineken daren't mention.",
"Graffiti: Reality is an illusion caused by lack of alcohol.",
"Graffiti: Reality is for people who cannot cope with science fiction.",
"Graffiti: Reincarnation is making a comeback!",
"Graffiti: Sado-masochism means not having to say you're sorry.",
"Graffiti: Save trees, eat more beavers.",
"Graffiti: Say it with flowers - give her a triffid.",
"Graffiti: Smile - things may get worse more slowly.",
"Graffiti: Smoking - think of it as evolution in action.",
"Graffiti: Study art and logic - learn to draw your own conclusions.",
"Graffiti: Sudden prayers make God jump.",
"Graffiti: Support British steel - smelt the Iron Lady.",
"Graffiti: The Annuual Conference of Clairvoyants has been cancelled due to unforeseen circumstances.",
"Graffiti: The English country gentleman galloping after a fox - the unspeakable in pursuit of the uneatable.",
"Graffiti: The first three minutes of your life can be dangerous ... The last three can be pretty dodgy too!",
"Graffiti: The meek shall inherit the earth - in 6' x 2' plots.",
"Graffiti: The optimist proclaims that we live in the best of all possible worlds; and the pessimist fears this is true.",
"Graffiti: The reason that people here get lost in thought is because it's such unfamiliar territory.",
"Graffiti: The road to success is usually under construction.",
"Graffiti: The trouble with political jokes is that they get elected.",
"Graffiti: We are the people our parents warned us about.",
"Graffiti: Welsh men only marry Welsh women because sheep can't cook."
};

void new_sentence()
{
		message=sentence[random(nbmax)];
		FillRect(1,16,158,85,DRAW_WHITE);
		SetFontType(PRPFONT11N);
		ind=pos=lastpos=lastind=flag=start=0;
  		liney=16;
		for(ind=0; ind<=strlen(message) ; ind++)
		{
			line[pos++]=message[ind];
  			if ((message[ind]==' ') | (message[ind]=='\0'))
			{
				line[pos]='\0';	
				if (GetStringLength(line,PRPFONT11N) < 152)
				{
		 			lastpos=pos;
					lastind=ind;
				}
				else
				{                    
					flag=1;
				};
			}  
  			if ((flag==1)|(message[ind]=='\0'))
			{
				pos=0;					
				ind=lastind;	
				line[lastpos]='\0';
				WriteAlignString(4,liney,line,156,ALIGN_LEFT,0);
				liney+=11;
				flag=0;
			};
		}
}


void dsk_draw(VOID_PTR view)
{ 
	PDESKBOX_draw(view); 
	AssignBankNo(image, ibank);
	DrawIcon(1, 86, ibank, &image, 0);
    	new_sentence();
}	


void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y)
{  
	PDESKBOX_handleEvent(view,evType,x,y); 
	
	if (*evType == evCommand)
	{
   		switch(TOWORD(x,y))
   		{
      	case cmAbout :
        MessageBox(AboutMessage, mfInformation | mfOKButton);
       	break;

     	case cmOther :
  		new_sentence();
		break;

		case cmExit :
		PutEvent(evCommand, HIGBYTE(cmQuit),LOWBYTE(cmQuit));
		break;
			
		case cmOff :
		_asm
		{
		push af
		call    0x002D           
WAIT:           ld      a,(0xC05D)       
                and     a               
                jr      nz,WAIT
		pop af
		};
		new_sentence();
		break;

		default:
		break;
			}
   	}
}


int main()
{
	dsk = (PDESKBOX *)CreateDeskBox(id++, 0, 0, 159, 239, 
	      	MK_FAR_PTR(WindowTitle),MK_FAR_PTR(MainMenu), NULL_FP,
      		bafClose | bafDotTitle | bafComLine); 
	
	InsertButton(dsk, id++, MK_FAR_PTR(Btn1Label), cmOther, bttBasic, 0);
	InsertButton(dsk, id++, MK_FAR_PTR(Btn2Label), cmOff,   bttBasic, 2);

	BankedAssign1(dsk->draw,dsk_draw); 
	BankedAssign2(dsk->handleEvent,dsk_handleEvent);

	ExecView((PGROUP_PTR) dsk);
	Destroy((VOID_PTR) dsk);
	return ExitCode;
}
