/*
#include "ressdk.h"
#include "f_sdkapi.h"
*/

#ifndef NULL
#define NULL 		'\0'
#define CRLF 		"\r\n"

#define LANDSCAPE		1
#define PORTRAIT		0

#define DECAL_SMALL_FONT	10

#define evPaint		0x81
#define evCreate	0x82
#define evQuit		0x83
#define evDestroy	0x84
#define evFastTimer 0x85
#define evChar		0x86
#define evShow		0x87
#define evComChar	0x88
#define evCreateModal 0x89
#endif

/* comm port defines */

#ifndef SPEED_115000
#define SPEED_115000	1
#define SPEED_57000		2
#define SPEED_14400		8
#define SPEED_9600		12
#define SPEED_4800		24
#define SPEED_2400		48
#define SPEED_1200		96

#define PORT_IR	0
#define PORT_RS	1
#endif

typedef unsigned int  word;
typedef unsigned char byte;
typedef unsigned long ulong;

/* rect struct */
typedef struct Tagrect
{
 short left;
 short top;
 short right;
 short bottom;
}rect;


typedef struct TagWindow
{
 int 			used;
 int			Modal;
 byte			wleft;
 byte			wtop;
 byte			wright;
 byte			wbottom;
 byte			wDir;
 unsigned short	wflags;
 int 			(*WndProc)(byte, unsigned short , byte, byte);
 unsigned short	WndProcBank;   
 CONST_FAR_PTR	wTitle;
 CONST_FAR_PTR	wMenu;
 PDESKBOX 		*Wnd;
 word			prop;
}Window;

extern BANKED void		WinMain(void);
extern BANKED byte 		GetWindowDirection(byte handle);
extern BANKED void 		PostQuitMessage(byte handle, short app);
extern BANKED void 		PostMessage(byte handle, unsigned short evType, byte x, byte y);
/*extern BANKED short		RunApplication(void);*/
extern BANKED byte		CreateWindow(CONST_FAR_PTR Win);
/*
 If you use Mode1 the window that has opened the comm port will
 not receive the evComChar message anymore.

 Mode 1=
	Use Avocet ExecView function. (Use it if you insert page arrows,
	textfields. Communications are stoped.

 Mode 0=
	The toolkit handles Modal display, communications are active
	even when a modal window is displayed
*/ 	

extern BANKED short		CreateModalWindow(CONST_FAR_PTR Win, byte owner, int Mode);
extern BANKED void  	DestroyWindow(byte handle);
extern BANKED VOID_PTR	GetWindowPtr(byte handle);
extern BANKED void  	RotateWindow(byte handle);
extern BANKED void 		GetWindowsRect(byte handle, rect *r);
extern BANKED byte		GetWinHeight(byte handle);
extern BANKED byte		GetWinWidth(byte handle);
/*extern BANKED short  	DispatchMessages(void);*/
extern BANKED void 		InsertControl(byte handle, PVIEW *p);
extern BANKED void		BringToFront(byte handle);
extern BANKED void		ClearClientArea(byte handle);
extern BANKED void 		DrawSystemIcon(byte x, byte y, int icon_number, int mode);
extern BANKED void 		ResizeWindow(byte handle, byte left, byte top, byte right, byte bottom);
extern BANKED byte 		HighByte(word v);
extern BANKED byte 		LowByte(word v);
extern BANKED void 		CloseComm(void);
extern BANKED void 		SendByte(byte Byte);
extern BANKED void 		OpenComm(byte handle, byte Port, word Speed);


extern BANKED byte 		DrawString(byte h, byte x, byte y, CONST_FAR_PTR str, short attr);
extern BANKED void 		DrawTime(byte h, byte x, byte y, short attr);
extern BANKED char 		DecimalSeparator(void);
extern BANKED int 		isdigit(char c);
extern BANKED int 		isalpha(char c); 
extern BANKED short 	ScreenWidth(void);
extern BANKED short 	ScreenHeight(void);
extern BANKED int 		Round(double t);
extern BANKED void 		SetProp(byte handle, word prop);
extern BANKED word 		GetProp(byte handle);
extern BANKED int 		GetCharLength(char c,int Font);
extern BANKED char 		tolower(char c);
extern BANKED char 		toupper(char c);
extern BANKED void 		strupr(char *s);
extern BANKED void 		strlwr(char *s);
extern BANKED word		GetCmd(byte x, byte y);

