#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "windows.h"
#include "progress.h"

static short
		Ptop,
		Pleft,
		Pright,
		Pbottom;
/*
#define Ptop		95
#define Pleft		10
#define Pright		Pleft+140
#define Pbottom		Ptop+50
*/
#define WinWidth	140
#define WinHeight	50


static char TmpStr[128] = "";


static void reverse(char *s)
{
 char *j;
 short c;

 j = s + strlen(s) - 1;
 while(s < j) 
 {
  c = *s;
  *s++ = *j;
  *j-- = c;
 }
}


static itoa(int n, char *ret) 
{
 int sign;
 char *ptr;
 
 ptr = ret;
 if ((sign = n) < 0) /* record sign */
    n = -n;     /* make n positive */
 do 
 {          /* generate digits in reverse order */
  *ptr++ = n % 10 + '0';         /* get next digit */
 } while ((n = n / 10) > 0);    /* delete it */

 if (sign < 0) *ptr++ = '-';

 *ptr = '\0';
 reverse(ret);
}


BANKED void Progress(int per)
{
 itoa(per, TmpStr); 
 strcat(TmpStr,"%");
 WriteString(73, Ptop+18, TmpStr, 0);

 FillRect( Pleft+20, Ptop+30, (Pleft+20)+per, Ptop+40, DRAW_BLACK);
}

BANKED void StopProgress()
{
 RestoreWindow( Pleft, Ptop, GetLCDBackBufAddr(), PUT); /*GetLCDBackBufAddr()*/
}

BANKED void StartProgress()
{
 Pleft = (ScreenWidth() - WinWidth) /2;
 Ptop  = (ScreenHeight() - WinHeight) /2;
 Pright = Pleft + WinWidth;
 Pbottom = Ptop + WinHeight;

 BackupWindow( Pleft, Ptop, Pright, Pbottom, GetLCDBackBufAddr()); /*GetLCDBackBufAddr()*/

 ClearLCDArea(Pleft, Ptop, Pright, Pbottom, 0);
 /* border */
 DrawRect(Pleft , Ptop, Pright, Pbottom, DRAW_BLACK);
 /* progress bar */
 DrawRect( Pleft+20, Ptop+30, Pright-20, Ptop+40, DRAW_BLACK);
 /* title */
 WriteString(Pleft+45,Ptop+5, "Progression", 0);
 Progress(0);
}

