#include "defaults.h"
#include "mlib.h"


char TempMlibStr[128];

extern unsigned char StartRomBank;

/*
** xtoi -- convert hex string to integer nbr
**         returns field size, else ERR on error
*/
int far xtoi(CONST_FAR_PTR v)
{
 char *hexstr = TempMlibStr;
 int nbr, d, b;  char *cp;

 fstrcpy(hexstr,v);
 
 d = nbr = 0; cp = hexstr;
 while(*cp == '0') ++cp;
 while(1) 
 {
  switch(*cp) 
  {
   case '0': case '1': case '2':
   case '3': case '4': case '5':
   case '6': case '7': case '8':
   case '9':                     b=48; break;
   case 'A': case 'B': case 'C':
   case 'D': case 'E': case 'F': b=55; break;
   case 'a': case 'b': case 'c':
   case 'd': case 'e': case 'f': b=87; break;
   default: return (nbr);
  }
  if(d < 4) ++d; else return (ERR);
  nbr = (nbr << 4) + (*(cp++) - b);
 }
 return (nbr);
}


long GetValue(char c)
{
 switch(c)
 {
  case '0': return((long)0);
  case '1': return((long)1);
  case '2': return((long)2);
  case '3': return((long)3);
  case '4': return((long)4);
  case '5': return((long)5);
  case '6': return((long)6);
  case '7': return((long)7);
  case '8': return((long)8);
  case '9': return((long)9);
  case 'A': return((long)10);
  case 'B': return((long)11);
  case 'C': return((long)12);
  case 'D': return((long)13);
  case 'E': return((long)14);
  case 'F': return((long)15);
 }
}

long far xtol(CONST_FAR_PTR vv)
{
 long l,v,x;
 char *hexstr = TempMlibStr;
 int i,len;
 
 fstrcpy(hexstr,vv);

 len = strlen(hexstr);
 /* get first */
 l = (long)GetValue(hexstr[len-1]);
 /* the others */
 for (i=1,v=16; i<len; i++, (long)v=((long) v * (long) 16))
 {
   x = (long) GetValue(hexstr[len-(i+1)]);
   x = (long) x * (long) v;
   l |= (long) x;
 }
 return(l);
}

/*
** itox -- converts nbr to hex string of length sz
**         right adjusted and blank filled, returns str
**
**        if sz > 0 terminate with null byte
**        if sz = 0 find end of string
**        if sz < 0 use last byte for data
*/

CONST_FAR_PTR far itox(int nbr, int sz)  
{
 int digit, offset;
 char *str = TempMlibStr;

 if(sz>0) str[--sz]=0;
 else 
 if(sz<0) sz = -sz;
 else while(str[sz]!=0) ++sz;

 while(sz) 
 {
  digit=nbr&15; 
  nbr=(nbr>>4)&4095;

  if(digit<10) offset=48; 
  else offset=55;

  str[--sz]=digit+offset;
    if(nbr==0) break;
 }
 while(sz) str[--sz]='0';

 return(MK_FAR_PTR(str));
}

CONST_FAR_PTR far ltox(long nbr)  
{
 char tmpbuff[20];
 char *str = TempMlibStr;

 fstrcpy(str, itox((WORD)(nbr >> 16) ,5));
 fstrcpy(tmpbuff, itox((WORD) nbr, 5));
 strcpy(&str[4],tmpbuff);

 return (MK_FAR_PTR(str));
}


/*
** itoa(n,s) - Convert n to characters in s 
*/
/*
** reverse string in place 
*/
void reverse(char *s)
{
 char *j;
 short c;

 j = s + strlen(s) - 1;
 while(s < j) 
 {
  c = *s;
  *s++ = *j;
  *j-- = c;
 }
}


CONST_FAR_PTR far itoa(int n) 
{
 int sign;
 char *ptr;
 char *tmp = TempMlibStr;
 
 ptr = tmp;
 if ((sign = n) < 0) /* record sign */
    n = -n;     /* make n positive */
  do {          /* generate digits in reverse order */
    *ptr++ = n % 10 + '0';         /* get next digit */
    } while ((n = n / 10) > 0);    /* delete it */
  if (sign < 0) *ptr++ = '-';
  *ptr = '\0';
  reverse(tmp);
  return (MK_FAR_PTR(tmp));
}

/*
** atoi(s) - convert s to integer.
*/
int far atoi(CONST_FAR_PTR v)
{
  int sign, n;
  char *s = TempMlibStr;
  
  fstrcpy(s,v);
  
  while(*s<=' ' && (*s==' ' || (*s<=13 && *s>=9))) ++s;
  sign = 1;
  switch(*s) {
    case '-': sign = -1;
    case '+': ++s;
    }
  n = 0;
  while((*s<='9' && *s>='0')) n = 10 * n + *(s++) - '0';
  return (sign * n);
}


char far tolower(char c)
{
 if(c<='Z' && c>='A') return (c+32);
 return (c);
}

char far toupper(char c) 
{
  if(c<='z' && c>='a') return (c-32);
  return (c);
}

int far isdigit(int c) 
{
  return ((int) (c<='9' && c>='0'));
}

int far isalpha(int c) 
{
 return ((int) (c<='z' && c>='a') || (c<='Z' && c>='A'));
}
/*
** return 'true' if c is a hexadecimal digit
** (0-9, A-F, or a-f)
*/
int far isxdigit(int c)
{
  return ((c<='f' && c>='a') ||
          (c<='F' && c>='A') ||
          (c<='9' && c>='0'));
}


