#include "p100plib.h"
#include "ressdk.h"
#include "f_sdkapi.h"
#include "packet.h"
#include "windows.h"
#include "memo.h"
#include "memos.h"

BANKED int MemoEof(void)
{
 return((int) (TextPos[CurrentPos] == 0));
}

BANKED int ReadLine(char *s)
{
 int cnt = 0;

 do
 {
  *(s++) = ReadChar();
  cnt++;
 }while((*(s-1)) && ((*(s-1))!='\n'));
 *s=0;

 return (cnt);
}

BANKED char ReadChar(void)
{
 if (CurrentPos<MAXTEXTSIZE)
   return(TextPos[CurrentPos++]);
 else
   return (0);
}

BANKED int FindMemo(CONST_FAR_PTR title)
{
 int 	i, cnt;
 char 	tmp[40],
		tmp2[40];
 char *p;

 fmemcpy(tmp2, title, 40);
 if (tmp2[strlen(tmp2)-1] != '\n') strcat(tmp2, "\n");

 cnt = GetMemoCount();

 if (cnt)
 {
  for (i=0; i<cnt; i++)
  {
   if ((p = GetMemoTitle(i)))
   {
    if ((strstr(p, tmp2)) && (strlen(p) == strlen(tmp2))) return(i);
   }
  }
 }
 return(-1);
}

BANKED void CloseMemo(void)
{
 if (Changed) SaveMemo();
 CurrentPos = 0;
 MemoIndex = -1;
}

BANKED int OpenMemo(int index)
{
 PIMHEAD *p;
 int sz;

 /*TextPos = TextBuffer;*/
 CurrentPos = 0;
 /*memset(TextPos, 0, 3500);*/
 strcpy(MemoTitle, GetMemoTitle(index));
 MemoIndex = index;
 TextPos = GetField(MemoBuffer, TITLE_FIELD + 1);
 headsz = TextPos-MemoBuffer;
 sz = strlen(TextPos);
 if (sz < MAXTEXTSIZE)
   memset(TextPos+sz,0,MAXTEXTSIZE-strlen(TextPos));

 p = (PIMHEAD *) MemoBuffer;
 SavedCategory = p->category;
 MustDelete = FALSE;
 Changed = FALSE;
}

BANKED int CreateMemo(CONST_FAR_PTR title)
{
 int i;

 i = FindMemo(title);
 MustDelete = (i>=0);
 MemoIndex = i;
 /*if (i>=0) DeleteMemo(i);*/

 CurrentPos = 0;

 i = CreateMemoExt(title);
 TextPos = GetField(MemoBuffer, TITLE_FIELD + 1);
 /*OpenMemo(i);*/
 memset(TextPos, 0, MAXTEXTSIZE);
 Changed = TRUE;

 SavedCategory = 0;

 return (i);
}

BANKED int WriteMemo(CONST_FAR_PTR str)
{
 char *p;

 if (CurrentPos<MAXTEXTSIZE)
 {
  if (CurrentPos == 0) memset(TextPos, 0, MAXTEXTSIZE);
  p = TextPos+CurrentPos;

  fstrcpy(p, str);
  CurrentPos += strlen(p);

  Changed = TRUE;

  return(strlen(p));
 }
 return(0);
}



BANKED int SaveMemo(void)
{
 if (MustDelete) 
 {
  dapLoadIndexTable(TYPE_MEMO);
  dapDeleteRecord(MemoIndex);
  dapSaveIndexTable();
 }

 Changed = FALSE;

 dapLoadIndexTable(TYPE_MEMO);

 /*TextPos[CurrentPos]='\n';*/
 if (TextPos[strlen(TextPos)-1] != '\n') strcat(TextPos, "\n");
 memo_head.recLength += strlen(TextPos) + 1;
 memo_head.synKeyOffset = memo_head.recLength;
 memcpy(MemoBuffer, &memo_head, PIMHEAD_SIZE);

 MemoIndex = dapCreateRecord (MemoBuffer, memo_head.recLength);
 /*MemoIndex = dapChangeRecord(MemoIndex, MemoBuffer, memo_head.recLength);*/
 dapSaveIndexTable();
 /*
 if (MemoIndex<0)
   MemoIndex = CreateMemoExt(MK_FAR_PTR(MemoTitle), MK_FAR_PTR(TextBuffer),CurrentPos);
 else
   MemoIndex = SaveMemoExt(MemoIndex, MK_FAR_PTR(MemoTitle), MK_FAR_PTR(TextBuffer),CurrentPos);
 */
 MustDelete = TRUE;
 return(MemoIndex);
}

BANKED int SaveBinMemo(CONST_FAR_PTR data, short datalen, CONST_FAR_PTR Header)
{
 short sz;

 if (MustDelete) 
 {
  dapDeleteRecord(MemoIndex);
  dapSaveIndexTable();
 }

 Changed = FALSE;

 dapLoadIndexTable(TYPE_MEMO);

 /*TextPos[CurrentPos]='\n';*/
 fstrcpy(TextPos, Header);
 sz = strlen(TextPos);
 if (TextPos[sz-1] != '\n') strcat(TextPos, "\n");
 sz = strlen(TextPos);

 if ((datalen+sz+2)>MAXTEXTSIZE) datalen = MAXTEXTSIZE-(sz+2);
 fmemcpy(&TextPos[sz+1], data, datalen);

 memo_head.recLength += sz + datalen + 2;
 memo_head.synKeyOffset = memo_head.recLength;
 memcpy(MemoBuffer, &memo_head, PIMHEAD_SIZE);

 MemoIndex = dapCreateRecord (MemoBuffer, memo_head.recLength);
 /*MemoIndex = dapChangeRecord(MemoIndex, MemoBuffer, memo_head.recLength);*/
 dapSaveIndexTable();
 /*
 if (MemoIndex<0)
   MemoIndex = CreateMemoExt(MK_FAR_PTR(MemoTitle), MK_FAR_PTR(TextBuffer),CurrentPos);
 else
   MemoIndex = SaveMemoExt(MemoIndex, MK_FAR_PTR(MemoTitle), MK_FAR_PTR(TextBuffer),CurrentPos);
 */
 MustDelete = TRUE;
 return(MemoIndex);
}


BANKED int GetMemoCount()
{
 int i,j;

 dapGetRecordCount(TYPE_MEMO, &i, &j);
 return (i);
}

BANKED int IsMemoProtected(int index)
{
 PIMHEAD *p;
 int size;
 
 dapLoadIndexTable(TYPE_MEMO);
 size = dapGetRecordSize(index);
 
 dapReadRecord(index, 0, MemoBuffer, size);
 p = (PIMHEAD *) MemoBuffer;

 return ((int) (p->option & 2));
}

BANKED void DeleteMemo(int index)
{
 dapLoadIndexTable(TYPE_MEMO);
 if (dapDeleteRecord(index) == SUCCESS)
   dapSaveIndexTable();
}

BANKED char *GetMemoTitle(int index)
{
 int size;
 
 dapLoadIndexTable(TYPE_MEMO);
 size = dapGetRecordSize(index);
 
 if (size<MAX_MEMO_SIZE) 
 {
  if (dapReadRecord(index, 0, MemoBuffer, size) == SUCCESS)
    return (GetField(MemoBuffer, TITLE_FIELD));
 }
 return ((char *) 0);
}


BANKED CONST_FAR_PTR GetMemoCategory(int index)
{
 int size;
 
 dapLoadIndexTable(TYPE_MEMO);
 size = dapGetRecordSize(index);
 
 if (dapReadRecord(index, 0, MemoBuffer, size) == SUCCESS)
   return(MK_FAR_PTR(GetField(MemoBuffer, CATEGORY_FIELD)));

 return (0);
}

BANKED char *GetMemoBuffer(void)
{
 return(GetField(MemoBuffer, TITLE_FIELD + 1));
}


BANKED char *GetMemoText(int index)
{
 int size;
 PIMHEAD *p;
 
 dapLoadIndexTable(TYPE_MEMO);
 size = dapGetRecordSize(index);

 if (dapReadRecord(index, 0, MemoBuffer, size) == SUCCESS)
 {
  p = (PIMHEAD *) MemoBuffer;
  SavedCategory = p->category;
  return(GetField(MemoBuffer, TITLE_FIELD + 1));
 }
 
 return ((char *) 0);
}

/*
void OpenMemo(int index)
{
 char *p;

 TextPos=0;
 p = GetField(MemoBuffer, TITLE_FIELD + 1);
 TextSize = strlen(p);
}
*/

BANKED int CreateMemoExt(CONST_FAR_PTR title)
{
 char Category[1];
 int ret;

 fstrcpy(TmpTok,title);
 if (TmpTok[strlen(TmpTok)-1] != '\n') strcat(TmpTok, "\n");

 dapLoadIndexTable(TYPE_MEMO);

 Category[0] = '\0';

 /*if (textlen > MAX_MEMO_SIZE) textlen = MAX_MEMO_SIZE;*/

 memo_rec.offset = PIMHEAD_SIZE + RECHEAD_SIZE*MEMO_FIELD_COUNT;
 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*PRIVATE_FIELD, &memo_rec, RECHEAD_SIZE);
 memcpy(MemoBuffer + memo_rec.offset, &Private, PrivateLength); 
 memo_rec.offset = memo_rec.offset + PrivateLength;
 
 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*CATEGORY_FIELD, &memo_rec, RECHEAD_SIZE);
 memcpy(MemoBuffer + memo_rec.offset, Category, 0); 
 memo_rec.offset = memo_rec.offset + 0;

 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*TITLE_FIELD, &memo_rec, RECHEAD_SIZE);
 memcpy(MemoBuffer + memo_rec.offset, TmpTok, strlen(TmpTok) + 1); 
 memo_rec.offset = memo_rec.offset + strlen(TmpTok) + 1;
 
 memcpy(MemoBuffer + PIMHEAD_SIZE + RECHEAD_SIZE*TEXT_FIELD, &memo_rec, RECHEAD_SIZE);
 memo_rec.offset = memo_rec.offset + 1; 
 /*
 fmemcpy(MemoBuffer + memo_rec.offset, text, textlen + 1); 
 memo_rec.offset = memo_rec.offset + textlen + 1;
 
 TextPos = MemoBuffer+memo_rec.offset;
 */
 memset(&memo_head, 0, PIMHEAD_SIZE);
 memo_head.typeID = TYPE_MEMO;
 memo_head.fieldCount = MEMO_FIELD_COUNT;
 memo_head.recLength = memo_rec.offset;
 memo_head.synKeyOffset = memo_head.recLength;
 memo_head.category = SavedCategory;

 memcpy(MemoBuffer, &memo_head, PIMHEAD_SIZE);
 /*memcpy (&memo_head, MemoBuffer, PIMHEAD_SIZE);*/
 /*
 dapCheckFreeRecordSpace (memo_head.recLength);

 ret = dapCreateRecord (MemoBuffer, memo_head.recLength);

 dapSaveIndexTable();
 */
 return ret;
}


BANKED int SaveMemoExt(int index, CONST_FAR_PTR title)
{
 DeleteMemo(index);
 return(CreateMemoExt(title));
}



static BANKED char *GetField(char *Buffer, short FieldId)
{
 unsigned short FieldLength;
 RECHEAD RecHead;
 RECHEAD NextRecHead;

 memcpy (&RecHead, Buffer + sizeof (PIMHEAD) + (sizeof (RECHEAD))*FieldId, sizeof (RECHEAD));

/*********************************************************************************
* If this is not the last field, we can use the offset of the next field to
* determine the length. If its that last field we need to use the total record
* length to determine the field length.
*********************************************************************************/

 if (FieldId < GetFieldCount(Buffer) - 1)
 {
  memcpy (&NextRecHead, Buffer + sizeof (PIMHEAD) + (sizeof (RECHEAD))*(FieldId + 1), sizeof (RECHEAD));
 }
 else
 {
  NextRecHead.offset = GetRecordLength (Buffer);
 }
 FieldLength = NextRecHead.offset - RecHead.offset;
 /*memcpy (ReturnPtr, Buffer + RecHead.offset, FieldLength);*/

 return (Buffer + RecHead.offset);
}

static BANKED byte GetFieldCount (char *Buffer)
{

unsigned char FieldCount;

memcpy (&FieldCount, Buffer + FIELD_COUNT_OFFSET, sizeof (char));
return FieldCount;

}

static unsigned short GetRecordLength (char *Buffer)
{

unsigned short Length;

memcpy (&Length, Buffer + LENGTH_OFFSET, sizeof (short));
return Length;

}


