#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "windows.h"
#include "input.h"

#define WinLeft      0
#define WinTop       120
#define WinRight     159
#define WinHeight    239-WinTop
#define WinBottom    WinTop+WinHeight

#define TextLeft     WinLeft+5
#define TextTop      WinTop+20
#define TextRight	 WinRight-5
#define TextBottom   TextTop+15
#define CharWidth    7
#define CharHeight   15

static CONST_FAR_PTR	InputTitle;

static char   Result[128];

static BANKED void InputTextHandler(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
 PTEXTFIELD_handleEvent(thisView,evType,x,y);
}


static BANKED int InputWndProc(byte handle, unsigned short evType, byte x, byte y)
{
 PTEXTFIELD *thisView;

 switch(evType)
 {
  case evCreate:
        thisView = (PTEXTFIELD *) 
			CreateTextField('T', TextLeft, TextTop, TextRight, TextBottom, Result, PRPFONT11N, 
     				 		14, 30, InputTitle);

 		PTXFTotalRows = 1;
 		BankedAssign(thisView->handleEvent, InputTextHandler);
 		InsertControl(handle, (PVIEW *) thisView);
		break;
 }
}


BANKED int StartInput(byte handle, CONST_FAR_PTR ITitle, char *text)
{
 Window Win;
 int ret;
  
 strcpy(Result, text);
 
 if (Result[strlen(Result)-1] != '\n') strcat(Result, "\n");

 SetFontType(PRPFONT11N);
 
 InputTitle = ITitle;

 Win.wTitle = InputTitle;
 Win.wMenu =  0;
 Win.wleft = WinLeft;
 Win.wtop = WinTop;
 Win.wright = WinRight;
 Win.wbottom = WinBottom;
 Win.wDir = PORTRAIT;
 Win.Modal = TRUE;
 Win.wflags = bafClose|bafCheck|bafDotTitle;
 BankedAssign(Win.WndProc,InputWndProc);

 LCDCopy(1);
 
 ret = CreateModalWindow(MK_FAR_PTR(Win), handle, TRUE);

 LCDCopy(0);

 if (ret == cmCancel) return(FALSE);

 strcpy(text, Result);
 return (TRUE);
}

