#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "math.h"
#include "windows.h"
#include "keyb.h"
#include "main.h"

extern unsigned char StartRomBank;


static BANKED void BlinkCursor(void)
{
 FillRect(CurPosX, CurPosY, CurPosX+1, CurPosY+CHARH, DRAW_XOR);
 CursorOn ^= 1;
}

static BANKED void ScrollTermUp(void)
{
 if (CursorOn) BlinkCursor();
 BackupWindow(0, DebY+CHARH, 159, MaxY, GetLCDBackBufAddr());
 RestoreWindow(0, DebY, GetLCDBackBufAddr(), PUT);
 ClearLCDArea(DebX, (MaxY-CHARH)+1, MaxX, MaxY, 0);
}

static BANKED void PrintChar(char c)
{
 char str[3];

 if (c != BACK_SPACE)
 {
  str[0] = c;
  str[1] = 0;

  SetFontType(PRPFONT11N);
  if (CursorOn) BlinkCursor();

  /* check if won't fit in X */
  if(c == '\r') CurPosX = DebX;
  else
  if (((CurPosX + GetStringLength(str, PRPFONT11N)) >= MaxX) || (c == '\n'))
  {
   /* check if bottom reached */
   if (CurPosY+CHARH>=MaxY) ScrollTermUp();
   else CurPosY += CHARH;
  }
  else
  {
   WriteString(CurPosX, CurPosY, str, 0);
   CurPosX += GetStringLength(str, PRPFONT11N)+1;
  }
  /* checkY */ 
  /*if (CurPosY>=MaxY) ScrollTermUp();*/
 }
}

static BANKED void DrawWorkSpace(byte handle)
{
 rect r;

 GetWindowsRect(handle, &r);

 DebX = r.left+5;
 DebY = r.top+16;
 MaxX = r.right-5,
 MaxY = DebY + (MAXLINES*CHARH);
 
 DrawRect(DebX-1, DebY-1, MaxX+1, MaxY+1, DRAW_BLACK);

 CurPosX = DebX;
 CurPosY = DebY;
}

/*
/
/ MAIN WINDOW HANDLERS 
/
/
*/

static BANKED void OnCommand(byte handle, WORD Cmd)
{
 switch(Cmd)
 {
  case mcExit:  
      PostQuitMessage(handle, APPLICATION);
      break;
 }
}

static BANKED int WndProc(byte handle, unsigned short evType, byte x, byte y)
{
 switch(evType)
 {
  case evChar:
  		PrintChar(x);
  		break;

  case evDestroy:
		DestroyWindow(KeybWin);
		break;

  case evKeyDown:
		PostQuitMessage(handle, x);
		break;

  case evCommand:
		OnCommand(handle, ((WORD) x << 8) | (WORD) y);
		break;

  case evFastTimer:
  		BlinkCnt++;
		if (BlinkCnt < 4) break;
		BlinkCnt = 0; 
 
/*  case evTimer:*/
  		BlinkCursor();
		break;

  case evCreate:
		/* make keyb window */
		KeybWin = StartKeyBoard(handle, 1);
 		break;

  case evPaint:
        DrawWorkSpace(handle);
 		break;

  case evPenDown:
  		break;
 }
}

BANKED void WinMain(void)
{
 Window Win;

 ClearLCD(0);
 SetFontType(PRPFONT11N);

 Win.wTitle = MK_FAR_PTR(AppTitle);
 Win.wMenu =  MK_FAR_PTR(AppMenu);
 Win.wleft = 0;
 Win.wtop = 0;
 Win.wright = 159;
 Win.wbottom = 155;
 Win.Modal = FALSE;
 Win.wDir = 0;
 Win.wflags = bafDotTitle;

 BankedAssign(Win.WndProc,WndProc);
 CreateWindow(MK_FAR_PTR(Win));
}


