#include "ressdk.h" 
#include "packet.h"
#include "windows.h"

extern byte StartRomBank; 

#define  SCRNX		159
#define  SCRNY		239
#define  CHARW		7
#define  CHARH		10

#define  DEBX		2
#define  DEBY		15

static int		 Xpos = DEBX;
static int		 Ypos = DEBY;
static int		 PrintMode = 0;


static Window	Windows[MAX_WINDOWS] = {};
static Message	Messages[MAX_MSGS] = {};

static short	Cur_Msg;
static short	NumWindows = 0;

static char TempStr[256];

static void Scroll()
{
 /*ScrollUp( 0, CHARH-1, SCRNX-1, SCRNY-1, CHARH);*/
 
 BackupWindow( 0, CHARH-1, SCRNX, SCRNY, GetLCDBackBufAddr());
 RestoreWindow(0,0, GetLCDBackBufAddr(), PUT);
 ClearLCDArea(0,(SCRNY-CHARH), SCRNX, SCRNY, 0)
}

BANKED int printfs(CONST_FAR_PTR v)
{
 char *p;
 char *p2;
 char str[50];
 char *s = TempStr;

 fstrcpy(TempStr, v);

 p = s;
 p2 = str;
 *p2 = NULL;

 while(*p)
 {
  if (Xpos >= SCRNX-CHARW) {Xpos = DEBX; Ypos +=CHARH;}
  /* should scroll here */
  if (Ypos >= SCRNY-CHARH) {Scroll();Ypos -= CHARH;}

  if (GetStringLength(str, GetFontType())>=(SCRNX-Xpos-CHARW))
  {
   p--;
   *p='\n';
  }


  switch (*p)
  {
   case '\n': 
      if (str[0]) 
      {
       WriteString( Xpos, Ypos, str, PrintMode);
       p2=str;
       *p2=NULL;
      }
      Xpos = DEBX; 
      Ypos += CHARH;
      break;

   case '\t': 
      if (str[0]) 
      {
       WriteString( Xpos, Ypos, str, PrintMode);
		p2=str;
       *p2=NULL;
       Xpos += (GetStringLength(str, GetFontType()) + (CHARW * 3));
      }
      break;

   default:
     *(p2++) = *p;
     *p2 = NULL;
     break;
  }
  p++;
 }
 /* something to print in out buffer ?? */
 if (str[0]) 
 {
  WriteString( Xpos, Ypos, str, PrintMode);
  Xpos += GetStringLength(str, GetFontType());
 }
 return (strlen(s));
}

BANKED int printff(double v)
{
 char TmpStr[128];

 NumericToStr((double) v, TmpStr, DTREAL);
 return (printfs(MK_FAR_PTR(TmpStr)));
}

BANKED int printfn(int v)
{
 char TmpStr[128];
 
 NumericToStr((double) v, TmpStr, DTINTEGER);
 return (printfs(MK_FAR_PTR(TmpStr)));
}


BANKED int isdigit(char c) 
{
 return ((int) (c<='9' && c>='0'));
}

BANKED int isalpha(char c) 
{
 return ((int) (c<='z' && c>='a') || (c<='Z' && c>='A'));
}


BANKED char DecimalSeparator(void)
{
 if (GetSysFormat() & 2) return(',');
 else					 return('.');
}


BANKED void WinDrawHandler(VOID_PTR thisView)
{
 register short i;

 for (i=0; i<MAX_WINDOWS; i++)
 {
  if ((VOID_PTR) Windows[i].Wnd == thisView)
  {
   PostMessage(i, evPaint, 0, 0);
   DispatchMessages();
   return;
  }
 }
}

BANKED void WinProcHandler(VOID_PTR thisView, unsigned short *evType, byte x, byte y)
{
 register short i;

 for (i=0; i<MAX_WINDOWS; i++)
 {
  if ((VOID_PTR) Windows[i].Wnd == thisView)
  {
   PostMessage(i, *evType, x, y);
   DispatchMessages();
   return;
  }
 }
}

void DrawTime(byte h, byte x, byte y, short attr)
{
 _TIME time;

 GetTime(&time);
 WriteTime(Windows[h].wleft+x, Windows[h].wtop+y, time, attr);
}

void DrawString(byte h, byte x, byte y, CONST_FAR_PTR str, short attr)
{
 fstrcpy(TempStr, str);
 WriteString(Windows[h].wleft+x, Windows[h].wtop+y, TempStr, attr);
}

void InsertControl(byte handle, PVIEW *p)
{
 PDESKBOX *dsk;

 dsk = (PDESKBOX *) Windows[handle].Wnd;

 LoadBank(&dsk->insert);
 dsk->insert((VOID_PTR) dsk, (PVIEW *) p);
}

byte GetWinHeight(byte handle)
{
 return(Windows[handle].wbottom+1);
}

byte GetWinWidth(byte handle)
{
 return(Windows[handle].wright+1);
}

void RotateWindow(byte handle)
{
 byte i;
 PDESKBOX *p;

 p = (PDESKBOX *) Windows[handle].Wnd;

 i = Windows[handle].wbottom;
 Windows[handle].wbottom = Windows[handle].wright;
 Windows[handle].wright = i;

 i = p->bottom;
 p->bottom = p->right;
 p->right = i;
}

VOID_PTR GetWindowPtr(byte handle)
{
 return ((VOID_PTR) Windows[handle].Wnd);
}

int FindWindow(byte x, byte y)
{
 short i;

 for (i=0; i<MAX_WINDOWS; i++)
 {
   if (Windows[i].used)
   {
     if (((x >= Windows[i].wleft) && (x<= Windows[i].wright)) &&
         ((y >= Windows[i].wtop) && (y<= Windows[i].wbottom))) return (i);
   }
 }

 return (-1);
}


void PostMessage(byte handle, unsigned short evType, byte x, byte y)
{
 if (Cur_Msg>=MAX_MSGS) WarningBeep();
 else
 {
  Cur_Msg++;
  Messages[Cur_Msg].handle = handle;
  Messages[Cur_Msg].evType = evType;
  Messages[Cur_Msg].x = x;
  Messages[Cur_Msg].y = y;
 }
}

int FindFreeWindow(void)
{
 register short i;

 for (i=0; i<MAX_WINDOWS; i++)
   if (!Windows[i].used) return (i);

 return (-1);
}

int PeekMessage(byte *handle, unsigned short  *evType, byte *x, byte *y)
{
 register byte i;

 if (Cur_Msg>0)
 {
  *handle = Messages[1].handle;
  *evType = Messages[1].evType;
  *x = Messages[1].x;
  *y = Messages[1].y;

  for (i=Cur_Msg; i>1; i--) 
    memcpy(&Messages[i-1], &Messages[i], sizeof(Message));

  Cur_Msg--;
  return (TRUE);
 }
 else return(FALSE);
}


void DispatchMessages(void)
{
 unsigned short  evType, ev;
 byte handle;
 byte x,y;
 VOID_PTR thisView;

 while(Cur_Msg>0)
 {
  if (PeekMessage(&handle, &evType, &x, &y))
  {
   thisView = Windows[handle].Wnd;
   ev = evType;
  
   if (evType == evQuit)
   {
    if (Windows[handle].Modal) EndState = x;
    else    				DestroyWindow(handle);
   }
   else
   {
    if (evType == evPaint)
      PDESKBOX_draw((VOID_PTR) thisView);

    if (evType<evPaint)
      PDESKBOX_handleEvent((VOID_PTR) thisView, &evType, x, y);
   
    /* dispatch messages */
    if (handle>=0) 
    {
     LoadBank(&(Windows[handle].WndProc));
     Windows[handle].WndProc(handle, ev, x, y);
    }
   }
  }
 }
}

void BrodCast(unsigned short evType, byte x, byte y)
{
 register short i;

 for (i=0; i<MAX_WINDOWS; i++)
	if (Windows[i].used) 
		PostMessage(i, evType, x, y);
}

void DestroyWindow(int handle)
{
 PostMessage(handle, evDestroy, 0, 0);
 DispatchMessages();
 Windows[handle].used = FALSE;
 Destroy ((VOID_PTR) Windows[handle].Wnd);
 NumWindows--;
}


short CreateModalWindow(CONST_FAR_PTR Win)
{
 byte h;
 short ret;
 unsigned short  evType;
 byte handle;
 byte x,y;

 DispatchMessages();

 h = CreateWindow(Win);
 /* remove paint message */
 PeekMessage(&handle, &evType, &x, &y);

 Windows[h].Modal = TRUE;
 ret = ExecView ((PGROUP *) Windows[h].Wnd);
 DestroyWindow(h);
 return ret;
}

byte CreateWindow(CONST_FAR_PTR Win)
{
 register byte i;
 PDESKBOX *v;
 
 i = FindFreeWindow();
 if (i>=0)
 {
  fmemcpy(&Windows[i], Win, sizeof(Window));
  /*
  Windows[i].wTitle = MK_FAR_PTR(TestTitle);
  Windows[i].wMenu = MK_FAR_PTR(TestMenu);
  */
  Windows[i].used = TRUE;

  v = (PDESKBOX *)
   CreateDeskBox('A', Windows[i].wleft, Windows[i].wtop, 
                 Windows[i].wright, Windows[i].wbottom,
                 Windows[i].wTitle, Windows[i].wMenu, 0,
                 Windows[i].wflags);

  Windows[i].Wnd = v;
  BankedAssign(v->handleEvent, WinProcHandler);
  BankedAssign(v->draw, WinDrawHandler);

  Windows[i].Modal = FALSE;

  /* dispatch the OnCreate message */
  PostMessage(i, evCreate,0, 0);
  DispatchMessages();

  PostMessage(i, evPaint,0, 0);
  /*DispatchMessages();*/

  NumWindows++;
 }
 return i;
}
/*
int GetKey(byte *penx, byte *peny)
{
.asm
	call 00E7h
	ld l,a
	ld h,0
	push hl
	;  set xpos 
	ld	l,(ix+0+?TSC25)
	ld	h,(ix+0+?TSC25+1)
	ld	e,l
	ld	d,h
	ld	a,b
	ld	(de),a
	;  set ypos
	ld	l,(ix+2+?TSC25)
	ld	h,(ix+2+?TSC25+1)
	ld	e,l
	ld	d,h
	ld	a,c
	ld	(de),a
	; set code 
    pop hl
.endasm
} 

short GetMyEvent(byte *x, byte *y)
{
 short ev;

 switch((ev = GetKey(x, y)))
 {
  case 0: 
		return(evNothing);
  case POWER:
  case ADDRESS:
  case SCHEDULE:
  case TASK:
  case MEMO:
  case PGUP:
  case PGDN:
  case CALENDAR:
  case EXPENSES:
  case CALCULATOR:
  case TABLE:
  case APPLICATION:
  case FIND:
  case BACK_LIGHT:
  case PC_LINK_KEY:
  		*x = ev;
  		return (evKeyDown);

  case 255:
  		return(evPenDown);
 }
}
*/

short RunApplication(void)
{
 short evType, ev, ret;
 byte x;
 byte y;
 short LastWin = -1;
 
 /*return (ExecView ((PGROUP *) Windows[handle].Wnd));*/
 ret = APPLICATION; 
 
 do
 {
  DispatchMessages();

  /*evType = GetMyEvent(&x, &y);*/
  evType = GetEvent(&x, &y);
  ev = evType;

  switch(evType)
  {
    case evNothing:
		break;
  
 	case evTimer:
 		BrodCast(evType, x, y);
 		break;
  
 	case evKeyDown:
         ret = x;
         BrodCast(evQuit, x, y);
         break;
  
 	case evPen:
 	case evPenDown:
 	case evPenDownMove:
 	case evPenAuto:
 	case evPenUp:
     	LastWin = FindWindow( x, y);
         if (LastWin>=0) PostMessage(LastWin, evType, x, y);
 		ClearEvent(&evType);
  		break;
   
 	default:
         if (LastWin>=0) PostMessage(LastWin, evType, x, y);
 		ClearEvent(&evType);
		break;
    }
  
 }while(NumWindows>0);

 return ret;
}


