#include "ressdk.h"
#include "packet.h"
#include "f_sdkapi.h"
#include "..\mlib.h"
#include "main.h"
#include "..\window.h"

/*#define DEMO TRUE*/

#ifdef DEMO
short Counter;
const char NagMsg[] = "This application is Shareware, please register $10. ociviol@astecsoft.com.";
#endif

/* 0 = hexa, 1 = decimal */
char Mode = HEXADECIMAL;
int Start = 0;

#ifdef DEMO
void ShowNagBox()
{
 MessageBox(MK_FAR_PTR(NagMsg),mfInformation | mfOKButton);
}
#endif

void ShowAboutBox()
{
 MessageBox(MK_FAR_PTR(AboutMsg),mfInformation | mfOKButton);
}


/*
/
/ MAIN WINDOW HANDLERS 
/
/
*/

void OnCreate(VOID_PTR thisView)
{
#ifdef DEMO
  Counter = 6;
#endif

 /* insert page arrow */
 InsertPageArrow((PDESKBOX *) thisView, 'A', (PVIEW *) thisView);

 ShowAboutBox();
}


void OnCommand(VOID_PTR thisView, WORD Cmd)
{
 char str[10];

#ifdef DEMO
 Counter++;
#endif

 switch(Cmd)
 {
  case mcExit:  
#ifdef DEMO
      ShowNagBox();
#endif
      EndState = mcExit;
      break;
  case mcAbout:
      ShowAboutBox();
      break;

  case mcDecimal:
      Mode = DECIMAL;
      Start = 0;
      OnPaint(thisView);

      break;

  case mcHexa:
      Mode = HEXADECIMAL;
      Start = 0;
      OnPaint(thisView);
      break;


  case cmPgDn:
      Start++;
      OnPaint(thisView);
      break;

  case cmPgUp:
      Start++;
      OnPaint(thisView);
      break;
 }
}

void OnPaint(VOID_PTR thisView)
{
 int i,j,Ypos,Pos,Xpos;
 int Max = 22;

 char s[5],
      carac[3];

 ClearLCDArea(5,15,145,238,0);
 SetFontType(PRPFONT11N);

 for (j=0, Pos=Start,Xpos=8; j<4; j++, Xpos+=35)
 {
  for (i=0,Ypos=15; i<Max;i++,Ypos+=10, Pos++)

  {
   /* make value string */
   if (Pos > 255) Pos = 0;

   switch(Mode)
   {
    case DECIMAL:
         itoa(Pos,s);
         break;
   
    case HEXADECIMAL:
         itox(Pos,s,3);
         break;
   }
   /* make character */
   carac[0] = (BYTE) Pos;
   carac[1] = NULL;
   /* output to screen */
   WriteString(Xpos,Ypos,carac,0);
   WriteString(Xpos+15, Ypos,s,0);
  }
 }
}

void OnPenDown(VOID_PTR thisView, unsigned char x, unsigned char y)
{}

void OnPenUp(VOID_PTR thisView, unsigned char x, unsigned char y)
{}

void OnPenMove(VOID_PTR thisView, unsigned char x, unsigned char y)
{}

void OnPenAuto(VOID_PTR thisView, unsigned char x, unsigned char y) 
{}

void OnKeyDown(VOID_PTR thisView, unsigned char KeyCode) 
{
 switch(KeyCode)
 {
  /* pgdn */
  case 7: 
    Start += (4 * 22);
    if (Start > 255) Start = 0;
    OnPaint(thisView);
    break;

    /* pgup */
  case 6: 
    Start -= (4 * 22);
    if (Start > 255) Start = 0;
    OnPaint(thisView);
    break;
 }
}

void OnTimer(VOID_PTR thisView)
{
#ifdef DEMO
 if (Counter >5)
 {
  ShowNagBox();
  Counter = 0;
 }
#endif
}

void OnUnknown(VOID_PTR thisView, short *evType, unsigned char x, unsigned char y)
{}

short main(void)
{
 unsigned short retval;

 ClearLCD(0);
 SetFontType(PRPFONT11N);

 do
 {
  retval = StartApplication(MK_FAR_PTR(AppTitle),MK_FAR_PTR(AppMenu));
 } while (retval == cmOK);
 
 if (retval == cmCancel)
 {
  retval = APPLICATION;
 }
 return retval;
}


