/* avicons.h
 *
 * Header file for Avigo system icon drawing function
 *
 *
 * Version 1.1
 * By Bill Baxter with additions by Thomas Chapman
 * Oct 16, 1997
 *
 * Update History:
 * Oct 20, 1997  - Icon name #defines added
 *               - #ifndef conditional include flag added
 *
 * Feel free to redistribute/reuse this code at no charge.
 * But be aware that it comes with no guarantees or warantees of any
 * kind.  Use at your own risk.  Do not use this code in the control
 * system for a nuclear reactor.
 *
 * NOTES:
 * -  Drawing system icons onto the virtual screen
 *    doesn't seem to work.  Maybe the system call is
 *    already using the virtual screen.
 *
 * -  For a complete listing of the system icons, visit Hans Pufal's
 *    web site: http://www.digiweb.com/~hansp/avigo/sysicon.htm
 *
 * -  And don't forget to check back at http://billbaxter.com/avigo
 *    from time to time to see what's new in the world of the
 *    Freeware Avigo SDK.
 */

#ifndef AVICONS_INCLUDED
#define AVICONS_INCLUDED 1

/* This is a workaround for a Freeware SDK Bug with functions
 * that have char arguments
 */
typedef int CHAR;

/* MAX_ICON is the maximum icon index */
#define MAX_ICON 323

/***************************************************
        Icon list entered by Thomas Chapman
        10/20/98

        Thanks to Hans Pufal for providing the icon numbers...

        Symbols used in list:
        I = icon
        BTN = button

        N = Normal
        S = Selected

        B = Black
        W = White
        G = Gray

        L = Left
        R = Right
        U = Up
        D = Down

        RT = Rotated

        SM = Small
        LG = Large

        CALC = Calculator Button
        APP = Application Icons
        BAD = Do not use these icons!!!

        *********/

enum ICONS {
        I_ABC_BAR=1,
        I_ALARM,
        I_BATTERY,
        I_BTN_STAMP,
        I_BTN_SELECT,
        I_BTN_PEN,
        I_BTN_BOX,
        I_BTN_CIRCLE,
        I_BTN_LINE,
        I_BTN_ERASER,
        I_BTN_FILLED,
        I_BTN_BORDER,
        I_BTN_GRAY,
        I_BTN_LINE_1,
        I_BTN_LINE_2,
        I_BTN_LINE_3,
        I_INC_N,
        I_INC_S,
        I_BTN_L_N,
        I_BTN_L_N_RT,
        I_BTN_L_S_RT,
        I_BTN_L_S,
        I_BTN_R_N,
        I_BTN_R_N_RT,
        I_BTN_R_S_RT,
        I_BTN_R_S,
        I_DEC_N,
        I_DEC_S,
        I_BTN_ANG_L_N,
        I_BTN_ANG_L_N_RT,
        I_BTN_ANG_L_S_RT,
        I_BTN_ANG_L_S,
        I_BTN_ANG_R_N,
        I_BTN_ANG_R_N_RT,
        I_BTN_ANG_R_S_RT,
        I_BTN_ANG_R_S,
        I_BTN_ROTATE_N,
        I_BTN_ROTATE_N_RT,
        I_BTN_ROTATE_S,
        I_BTN_ROTATE_S_RT,
        I_BTN_SM_L_N,
        I_BTN_SM_L_N_RT,
        I_BTN_SM_L_S_RT,
        I_BTN_SM_L_S,
        I_BTN_SM_R_N,
        I_BTN_SM_R_N_RT,
        I_BTN_SM_R_S_RT,
        I_BTN_SM_R_S,
        I_BTN_SHADOW_L_N,
        I_BTN_SHADOW_L_N_RT,
        I_BTN_SHADOW_L_S_RT,
        I_BTN_SHADOW_L_S,
        I_BTN_SHADOW_R_N,
        I_BTN_SHADOW_R_N_RT,
        I_BTN_SHADOW_R_S_RT,
        I_BTN_SHADOW_R_S,
        I_CALC_CLEAR_B,
        I_CALC_CLEAR_W,
        I_CALC_SQRT_B,
        I_CALC_SQRT_W,
        I_CALC_SIGN_B,
        I_CALC_SIGN_W,
        I_CALC_PERCENT_B,
        I_CALC_PERCENT_W,
        I_CALC_MRC_B,
        I_CALC_MRC_W,
        I_CALC_MEM_M_B,
        I_CALC_MEM_M_W,
        I_CALC_MEM_P_B,
        I_CALC_MEM_P_W,
        I_CALC_DEV_B,
        I_CALC_DEV_W,
        I_CALC_7_W,
        I_CALC_7_B,
        I_CALC_8_W,
        I_CALC_8_B,
        I_CALC_9_W,
        I_CALC_9_B,
        I_CALC_MUL_B,
        I_CALC_MUL_W,
        I_CALC_4_W,
        I_CALC_4_B,
        I_CALC_5_W,
        I_CALC_5_B,
        I_CALC_6_W,
        I_CALC_6_B,
        I_CALC_SUB_B,
        I_CALC_SUB_W,
        I_CALC_1_W,
        I_CALC_1_B,
        I_CALC_2_W,
        I_CALC_2_B,
        I_CALC_3_W,
        I_CALC_3_B,
        I_CALC_ADD_B,
        I_CALC_ADD_W,
        I_CALC_0_W,
        I_CALC_0_B,
        I_CALC_DOT_W,
        I_CALC_DOT_B,
        I_CALC_EQ_W,
        I_CALC_EQ_B,
        I_0_B,
        I_1_B,
        I_2_B,
        I_3_B,
        I_4_B,
        I_5_B,
        I_6_B,
        I_7_B,
        I_8_B,
        I_9_B,
        I_PERIOD_B,
        I_COMMA_B,
        I_NEG_B,
        I_ERR_B,
        I_MONTH_BAR,
        I_CALC_SCREEN,
        I_WEEK_MON,
        I_WEEK_SUN,
        I_BAD_121,
        I_SAVE_N,
        I_SAVE_N_RT,
        I_SAVE_S_RT,
        I_SAVE_S,
        I_CLOSE_N,
        I_CLOSE_N_RT,
        I_CLOSE_S_RT,
        I_CLOSE_S,
        I_SEC_MENU_N,
        I_SEC_MENU_N2,
        I_PRI_MENU_N,
        I_PRI_MENU_S,
        I_SEC_MENU_S_RT,
        I_PRI_MENU_N2,
        I_PRI_MENU_S2,
        I_SEC_MENU_S,
        I_SEC_MENU_S2,
        I_SEC_MENU_S_RT2,
        I_PRI_MENU_N_RT,
        I_PRI_MENU_N3,
        I_MONTH_1,                              /* USED IN 6 MONTH VIEW */
        I_MONTH_2,                              /* USED IN 6 MONTH VIEW */
        I_MONTH_3,                              /* USED IN 6 MONTH VIEW */
        I_MONTH_4,                              /* USED IN 6 MONTH VIEW */
        I_MONTH_5,                              /* USED IN 6 MONTH VIEW */
        I_MONTH_6,                              /* USED IN 6 MONTH VIEW */
        I_MONTH_7,                              /* USED IN 6 MONTH VIEW */
        I_WEEKDAYS_MON,                         /* USED IN 6 MONTH VIEW */
        I_WEEKDAYS_SUN,                         /* USED IN 6 MONTH VIEW */
        I_SETUP_TOUCHPAD_1,
        I_SETUP_TOUCHPAD_2,
        I_SETUP_TOUCHPAD_3,
        I_BAD_154,
        I_SETUP_TP_FLASH_1,
        I_SETUP_TP_FLASH_2,
        I_WEEKDAYS_MON_MINI,            /* USED WHEN CHOOSING A DATE */
        I_WEEKDAYS_SUN_MINI,            /* USED WHEN CHOOSING A DATE */
        I_MONTH_1_MINI,         /* USED WHEN CHOOSING A DATE */
        I_MONTH_2_MINI,         /* USED WHEN CHOOSING A DATE */
        I_MONTH_3_MINI,         /* USED WHEN CHOOSING A DATE */
        I_MONTH_4_MINI,         /* USED WHEN CHOOSING A DATE */
        I_MONTH_5_MINI,         /* USED WHEN CHOOSING A DATE */
        I_MONTH_6_MINI,         /* USED WHEN CHOOSING A DATE */
        I_MONTH_7_MINI,         /* USED WHEN CHOOSING A DATE */
        I_STAMP_PICKER,
        I_STAMP_AIRPLANE,
        I_STAMP_CAR,
        I_STAMP_LIGHT,
        I_STAMP_PHONE,
        I_STAMP_BUILDING,
        I_STAMP_HOUSE,
        I_STAMP_ARROW_R,
        I_STAMP_ARROW_L,
        I_STAMP_ARROW_U,
        I_STAMP_ARROW_D,
        I_STAMP_CHECK,
        I_STAMP_X,
        I_STAMP_STAR,
        I_STAMP_NOT,
        I_STAMP_MALE,
        I_STAMP_FEMALE,
        I_STAMP_CUP,
        I_STAMP_BULB,
        I_LEAF_1,
        I_LEAF_2,
        I_LEAF_3,
        I_LEAF_4,
        I_KEYBOARD_LOWER,
        I_KEYBOARD_CAPS,
        I_KEYBOARD_SHIFT,
        I_KEYBOARD_CAPS_SHIFT,
        I_KEYBOARD_UPPER,
        I_KEYBOARD_LOWER_ACCENT_1,
        I_KEYBOARD_CAPS_ACCENT_1,
        I_KEYBOARD_SHIFT_ACCENT_1,
        I_KEYBOARD_CAPS_SHIFT_ACCENT_1,
        I_KEYBOARD_LOWER_ACCENT_2,
        I_KEYBOARD_CAPS_ACCENT_2,
        I_KEYBOARD_SHIFT_ACCENT_2,
        I_KEYBOARD_CAPS_SHIFT_ACCENT_2,
        I_KEYBOARD_LOWER_ACCENT_3,
        I_KEYBOARD_CAPS_ACCENT_3,
        I_KEYBOARD_SHIFT_ACCENT_3,
        I_KEYBOARD_CAPS_SHIFT_ACCENT_3,
        I_KEYBOARD_LOWER_ACCENT_4,
        I_KEYBOARD_CAPS_ACCENT_4,
        I_KEYBOARD_SHIFT_ACCENT_4,
        I_KEYBOARD_CAPS_SHIFT_ACCENT_4,
        I_KEYBOARD_SYMBOL,
        I_KEYBOARD_PASSWORD,
        I_SUN_SM,
        I_BAD_213,
        I_FONT_SIZE_1_RT,
        I_FONT_SIZE_2_RT,
        I_APP_MEMORY,
        I_MENU_BUTTON_W_N,
        I_MENU_BUTTON_W_N_RT,
        I_MENU_BUTTON_B_N_RT,
        I_MENU_BUTTON_B_N,
        I_LIST_N,
        I_LIST_N_RT,
        I_LIST_S_ONBLACK_RT,
        I_LIST_S_RT,
        I_LIST_S_ONBLACK,
        I_LIST_S,
        I_BAD_227,
        I_BAD_228,
        I_BAD_229,
        I_BAD_230,
        I_BAD_231,
        I_BAD_232,
        I_BAD_233,
        I_BUBBLE_X,
        I_BUBBLE_QUESTION,
        I_BUBBLE_EXCLAMATION,
        I_CALC_SM_CLEAR_B,
        I_CALC_SM_CLEAR_W,
        I_CALC_SM_6_W,
        I_CALC_SM_6_B,
        I_CALC_SM_SUB_B,
        I_CALC_SM_SUB_W,
        I_CALC_SM_1_W,
        I_CALC_SM_1_B,
        I_CALC_SM_2_W,
        I_CALC_SM_2_B,
        I_CALC_SM_3_W,
        I_CALC_SM_3_B,
        I_CALC_SM_0_W,
        I_CALC_SM_0_B,
        I_CALC_SM_DOT_W,
        I_CALC_SM_DOT_B,
        I_CALC_SM_EQ_W,
        I_CALC_SM_EQ_B,
        I_CALC_SM_ADD_B,
        I_CALC_SM_ADD_W,
        I_CALC_SM_SIGN_B,
        I_CALC_SM_SIGN_W,
        I_CALC_SM_PERCENT_B,
        I_CALC_SM_PERCENT_W,
        I_CALC_SM_DEV_B,
        I_CALC_SM_DEV_W,
        I_CALC_SM_7_W,
        I_CALC_SM_7_B,
        I_CALC_SM_8_W,
        I_CALC_SM_8_B,
        I_CALC_SM_9_W,
        I_CALC_SM_9_B,
        I_CALC_SM_MUL_B,
        I_CALC_SM_MUL_W,
        I_CALC_SM_4_W,
        I_CALC_SM_4_B,
        I_CALC_SM_5_W,
        I_CALC_SM_5_B,
        I_CALC_DISPLAY,
        I_CALC_0,
        I_CALC_1,
        I_CALC_2,
        I_CALC_3,
        I_CALC_4,
        I_CALC_5,
        I_CALC_6,
        I_CALC_7,
        I_CALC_8,
        I_CALC_9,
        I_ARROW_UP_DOWN,
        I_ABC_BAR_SHORT,                /* USED TO PICK CITIES */
        I_ARROW_DOWN,
        I_ARROW_LEFT,
        I_ARROW_UP,
        I_ARROW_RIGHT,
        I_DAY_DATE,
        I_WEEKDAYS_BOX_MON,
        I_WEEKDAYS_BOX_SUN,
        I_BAD_295,
        I_APP_SECURITY,
        I_APP_SETUP,
        I_APP_SKETCH,
        I_X_BOX,
        I_ARROW_DOWN_2,
        I_SUN,
        I_ARROW_DOWN_LG_B,
        I_ARROW_DONW_LG_G,
        I_SYNC,
        I_BAD_305,
        I_APP_SYNC,
        I_BAD_307,
        I_APP_WORLD_TIME,
        I_AVIGO,
        I_CALC_COMMA_W,
        I_CALC_COMMA_B,
        I_DOC,
        I_MENU_BUTTON_B_S_RT,
        I_MENU_BUTTON_W_S_RT,
        I_MENU_BUTTON_B_S,
        I_MENU_BUTTON_W_S,
        I_WEEKDAYS_BOX_SUN_LG,
        I_WEEKDAYS_BOX_MON_LG,
        I_BUBBLE_WAIT,
        I_BTN_COMMA_W,
        I_BTN_COMMA_B,
        I_SKETCH,
        I_DATA
};

/* DrawSystemIcon takes the x and y coordinates at which to
 * draw the system icon, the icon index number, and a drawing mode
 * which can be PUT, OR, or XOR (maybe others too?).
 */
void DrawSystemIcon(CHAR x, CHAR y, int icon_number, int mode);


#endif
