#include <avsys.h>
#include <avdata.h>
#include <avio.h>

typedef unsigned char UCHAR;
int ballrad=3,padsize=10,pul=14,pdl=120,bx=80,by=70,xmovr=3,ymovr=3,live1,live2;

void StartOptionsScreen();

void RedrawLives()
{
    int l1=live1, l2=live2;
    SetToVirtualLCD(0);
    ClearLCDArea(0,pdl+20,160,240,0);

    while(l1>0)
    {
	FillRect(10,pdl+20+l1*6,14,pdl+24+l1*6,DRAW_BLACK);
        l1--;
    }
    while(l2>0)
    {
	FillRect(146,pdl+20+l2*6,150,pdl+24+l2*6,DRAW_BLACK);
        l2--;
    }
  SetToRealLCD(1);
}

void ResetBall()
{
   if (bx>157-ballrad)
	live2--;
   if (bx<3+ballrad)
	live1--;
   bx=80;
   by=70;
   randomize();
   ymovr=(random(4)-1)*2;
   Buzzer(5,5);   
   RedrawLives();
}

void WaitForKeyPress()
{
   UCHAR x='a', y='a';
   while (GetKey(&x,&y)==0)
   {
   }
}

void PauseGame()
{
   int key;
   UCHAR x, y;
   Delay_10ms();
   Delay_10ms();
   SetToRealLCD(0);
   ClearLCD;
   WriteString(32,70,"!!!Game Paused!!!",DRAW_BLACK);
   WriteString(31,82,"Resume",DRAW_BLACK);
   WriteString(88,82,"Quit",DRAW_BLACK);
   DrawRect(30,80,71,95,DRAW_BLACK);
   DrawRect(80,80,120,95,DRAW_BLACK);

   while ((!(key=GetKey(&x,&y)) || y!=1))
   {
   	if ((y<95) && (y>80))
	    if ((x>20) && (x<60))
	        break;
            if ((x>70) && (x<110))
	    {
		live1=-29;
		break;
	    }
   }
   SetToRealLCD(1);
}

void EndGameMessage(int p1, int p2)
{
   if ((p1>p2) && (p1!=-29))
	WriteString(50,145,"Player 1 won!!!",DRAW_BLACK);
   if ((p1<p2) && (p1!=-29))
	WriteString(50,145,"Player 2 won!!!",DRAW_BLACK);
   if ((p1==p2) && (p1!=-29))
	WriteString(50,150,"Tie game!!!",DRAW_BLACK);
}

void DrawBall(unsigned int x, unsigned int y)
{
    FillCircle(x,y,ballrad,DRAW_BLACK);
}

void BounceBallTo()
{
    if (by<3)
    {
        by=4;
        ymovr=-1*ymovr;
    }

    if (by>pdl+8)
    {
        by=pdl+8;
        ymovr=-1*ymovr;
    }
}

/*make sure ball has hit the paddle
modify ymovr by adding absolute of the distance from center of paddle to the ball.*/

void BounceBallOffPad(int y1, int y2)
{
    if ((bx<3+ballrad) && (by<=y1+padsize) && (by>=y1-padsize))
    {
        Buzzer(5,1);
        ymovr=(ymovr)+(dabs(y1-padsize))/35;
        xmovr=(-1*xmovr);
        return;
    }
    if ((bx>157-ballrad) && (by<=y2+padsize) && (by>=y2-padsize))
    {
        Buzzer(5,1);
        ymovr=(ymovr)+(dabs(y1-padsize))/35;
        xmovr=(-1*xmovr);
        return;
    }
    ResetBall();
}

void DrawPaddle(int p,int y)
{
    if (p==1)
	DrawRect(0,y-padsize,2,y+padsize,DRAW_BLACK);
    else
	DrawRect(157,y-padsize,159,y+padsize,DRAW_BLACK);
}

int GameMain()
{
    int key;
    UCHAR x=-1, y=-1;
    unsigned int akey=0,y1=pdl-80,y2=pdl-80;
    char drg[10];

RedrawLives(live1,live2);
randomize();

WriteString(20,20,"Get ready!",DRAW_BLACK);
DrawRect(20,40,140,50,DRAW_BLACK);

while (akey<1200)
{
   akey++;
   DrawLine(20+(akey/10),40,20+(akey/10),50,DRAW_BLACK);
}

while((live1>=1) && (live2>=1))
{
        key = GetKey(&x, &y);
        if (key && (y<10) && (y>0) && (x>150) && (x<160))
            return 1;
	else
        if (key && key == TASK) PauseGame();

    SetToVirtualLCD(0);
    ClearLCDArea(0,0,160,140,0);

    if ((y1>=pul) && (y1<=pdl) && (y2>=pul) && (y2<=pdl))
    {
	DrawPaddle(1,y1);
	DrawPaddle(2,y2);
	key = IoReadKeys();
        if (key & IO_KEY_ADDRESS) y1=y1-4;
        if (key & IO_KEY_SCHEDULE) y1=y1+4;
        if (key & IO_KEY_PGDN) y2=y2+4;
        if (key & IO_KEY_PGUP) y2=y2-4;
    }
    else
    {
    	if (y1<pul)
		y1=pul;
    	if (y1>pdl)
		y1=pdl;
    	if (y2<pul)
		y2=pul;
    	if (y2>pdl)
		y2=pdl;
	DrawPaddle(1,y1);
	DrawPaddle(2,y2);
    }

    by=by+ymovr;
    bx=bx+xmovr;

    if (ymovr==0) ymovr=random(2)-1;
    if (ymovr>6) ymovr--;

    if ((by<3) || (by>8+pdl))
        BounceBallTo();

    if ((bx<3+ballrad) || (bx>157-ballrad))
	BounceBallOffPad(y1,y2);

    DrawRect(1,1,158,3,DRAW_BLACK);
    DrawRect(1,pdl+11,158,pdl+13,DRAW_BLACK);

    itoa(ymovr,drg,10);
    strcat(drg,"   ");
    WriteString(75,185,drg,DRAW_BLACK);


    DrawBall(bx,by);
    SetToRealLCD(1);
}
Buzzer(5,7);
Buzzer(4,9);
RedrawLives(live1,live2);
EndGameMessage(live1,live2);

WaitForKeyPress();
ClearLCD;
Delay_10ms();
Delay_10ms();
Delay_10ms();
main();
}

void MeTalk()
{
int key;
UCHAR x=5,y=5;
	SetToRealLCD(0);
	ClearLCDArea(0,0,160,240,0);
	Buzzer(5,5);
	WriteString(0,20,"Hey there... here's a simple",DRAW_BLACK);
	WriteString(0,30,"2-player Pong-wannabe",DRAW_BLACK);
	WriteString(0,40,"game that I hope Avigo users",DRAW_BLACK);
	WriteString(0,50,"like I will enjoy. It's my first",DRAW_BLACK);
	WriteString(0,60,"attempt at an Avigo game, so",DRAW_BLACK);
	WriteString(0,70,"don't bi*ch about all the bugs",DRAW_BLACK);
	WriteString(0,80,"              :-)",DRAW_BLACK);
	WriteString(0,90,"Ok, the set setup is working",DRAW_BLACK);
	WriteString(0,100,"but because of the high sens-",DRAW_BLACK);
	WriteString(0,110,"itivity of the screen it may",DRAW_BLACK);
	WriteString(0,120,"be hard to set an exact num-",DRAW_BLACK);
	WriteString(0,130,"ber. I'll work at it later...",DRAW_BLACK);
	WriteString(0,150,"---------------------------",DRAW_BLACK);
	WriteString(0,160,"Programmer: Eugene Gisin",DRAW_BLACK);
	WriteString(0,170,"Email: avigopics@hotmail.com",DRAW_BLACK);
	WriteString(68,187,"Done",DRAW_BLACK);
	DrawRect(60,185,100,200,DRAW_BLACK);
	
	while (!(key=GetKey(&x,&y)) || (y>200) || (y<185) || (x<60) || (x>100))
	{
	}
        ClearLCDArea(0,0,160,240,0);
	StartOptionsScreen();
}

void StartOptionsScreen()
{
int key,games=6,looper=0,z=0;
UCHAR x=0, y=0;
char drg[10], buffer[1], outb[1];

 ReadPreference(CurrentAppID,0,outb,4);
 games=atoi(outb); 

 while (z!=1)
 {
   x=y=0;
   live1=live2=games;
   ClearLCDArea(0,0,160,240,0);
   DrawRect(3,150,52,165,DRAW_BLACK);
   DrawRect(55,150,104,165,DRAW_BLACK);
   DrawRect(107,150,156,165,DRAW_BLACK);

   WriteString(68,170,"Sets",DRAW_BLACK);
   DrawRect(40,175,55,195,DRAW_BLACK);
   DrawRect(105,175,120,195,DRAW_BLACK);
   
   DrawLine(108,190,117,190,DRAW_BLACK);
   DrawLine(108,190,112,180,DRAW_BLACK);   
   DrawLine(113,180,117,190,DRAW_BLACK);   

   DrawLine(43,180,52,180,DRAW_BLACK);
   DrawLine(43,180,47,190,DRAW_BLACK);
   DrawLine(48,190,52,180,DRAW_BLACK);   

   DrawRect(40,205,120,220,DRAW_BLACK);
   WriteString(42,208,"Set as default",DRAW_BLACK);

   WriteString(15,152,"Play",DRAW_BLACK);
   WriteString(64,152,"About",DRAW_BLACK);
   WriteString(119,152,"Exit",DRAW_BLACK);
   itoa(games,drg,10);
   strcat(drg,"   ");
   WriteString(77,185,drg,DRAW_BLACK);

  while (!(key=GetKey(&x,&y)) || y!=-1)
  {
   if (games>=18) games=18;
   if (games<=0) games=1;
   if ((y>175) && (y<195))
   {
	if ((x>40) && (x<55))
	{
	   games--;
	   y=-1;
	   break;
        }
	if ((x>105) && (x<120))
	{
	   games++;
	   y=-1;
	   break;
	}
	y=-1;
   }

   if ((y>150) && (y<165))
   {
	if ((x>107) && (x<156))
	    return;
	if ((x>3) && (x<52))
	{
	    GameMain();
	}
	if ((x>55) && (x<104))
	{
	    MeTalk();
	}
   }
   if ((y>205) && (y<220))
   {
     if ((x>40) && (x<120))
     {
	DeletePreference(CurrentAppID);
        itoa(games,buffer,10);
	SavePreference(CurrentAppID,buffer,4);
	y=-1;
     }
   }
  }
 }
}

int main()
{
    int key,game=-1;
    SetToVirtualLCD(1);
    ClearLCD(0);
    SetToRealLCD(1);

    StartOptionsScreen();

    PenBeep();
    return key;
}