#include "dopewars.h"
#include "verify.h"
#include "pbitmap.h"

static HighScore hscores [5];
#pragma codeseg
static char DopeTitle[]="DopeWars";
static char EnterName[]="Enter your name:";
#pragma defaultseg


static void initGame(void)
{
    int i;
    for (i = 0; i < 8; i++)
        myDrugs [i] = 0;

    myCash = 2000;
    myDebt = 5500;
    myBank = 0;
    myCoat = 100;
    myGuns = 0;
    myTotal = 0;
    myLocation = 0;
    timeLeft = 31;
    copCount = 3;
    cheatsEnabled = 0;
    cheatKey = 0;
    makeDrugPrices(3);
}

void intro(void)
{
  PDESKBOX *dsk;

  dsk = (PDESKBOX *)CreateDeskBox(200, 0, 0, 159, 239, MK_FAR_PTR(DopeTitle),
                          MK_FAR_PTR(HelpMenu), NULL_FP, bafDotTitle | bafClose);
  AssignBankNo(dopeguy, ibank);
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
         CreateBitmap(201, 5, 30, ibank, (unsigned int)&dopeguy, PUT));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(202,  75, 45, 157, 56, MK_FAR_PTR(DopeTitle), 
                     lbofAlignLeft|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(203,  75, 57, 157, 68, MK_FAR_PTR((char *)"Version 1.0"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(204,  75, 85, 157, 96, MK_FAR_PTR((char *)"Based on"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(205,  75, 97, 157, 108, MK_FAR_PTR((char *)"Drug Wars"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(206,  75, 109, 157, 120, MK_FAR_PTR((char *)"by John E. Dell"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(205,  75, 127, 157, 138, MK_FAR_PTR((char *)"DopeWars (Palm)"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(206,  75, 139, 157, 150, MK_FAR_PTR((char *)"by Matthew Lee"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(207,  75, 158, 157, 169, MK_FAR_PTR((char *)"written by"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(208,  75, 170, 157, 181, MK_FAR_PTR((char *)"Kai Nothdurft"),
                     lbofAlignLeft|lbofDefineFont, PRPFONT11B));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(209,  5, 187, 157, 198, MK_FAR_PTR((char *)"KNothdur@ifu.Rantzau.de"),
                     lbofAlignCenter|lbofDefineFont, PRPFONT11N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
         CreateButton(210, 65, 210, 95, 226, MK_FAR_PTR("OK"), cmOK, bttToDo));
  ExecView((PGROUP_PTR) dsk);
  Destroy((VOID_PTR)dsk);
}

void myTextField_handleEvent(VOID_PTR thisView, unsigned short *evType, unsigned char x, unsigned char y)
{
    if (*evType == evPenDown)
    {
        BackupWindow(0, 138, 159, 239, GetLCDBackBufAddr());
        PTEXTFIELD_handleEvent(thisView, evType, x, y);
        RestoreWindow(0, 138, GetLCDBackBufAddr(), PUT);
    }
    else
        PTEXTFIELD_handleEvent(thisView, evType, x, y);
}

static void GetHighScoreName(void)
{
    PDESKBOX *frm;
    PTEXTFIELD *fld;

    char c[20];

    *c = 0;
    frm = (PDESKBOX *)CreateDeskBox(220, 2, 58, 157, 130, 
          MK_FAR_PTR((char *)"New High Score"), NULL_FP, NULL_FP,
          bafSmall | bafCheck | bafDotTitle );
    PGROUP_insert((VOID_PTR) frm, (PVIEW *)
           CreateLabel(221, 4, 72, 155, 83, MK_FAR_PTR((char *)"You have achieved a"), 
                       lbofAlignCenter|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) frm, (PVIEW *)
           CreateLabel(222, 4, 84, 155, 95, MK_FAR_PTR((char *)" new high score!"), 
                       lbofAlignCenter|lbofDefineFont, PRPFONT11N));
    PGROUP_insert((VOID_PTR) frm, (PVIEW *) 
           CreateLabel(223, 10, 100, 87, 111, MK_FAR_PTR(EnterName),
                       lbofAlignLeft|lbofDefineFont, PRPFONT11N));
    fld = (PTEXTFIELD *)CreateTextField(224, 10, 113, 89, 127, c, PRPFONT11N, 13, 20, MK_FAR_PTR(EnterName));
    PGROUP_insert((VOID_PTR) frm, (PVIEW *)fld);
    PGROUP_insert((VOID_PTR) frm, (PVIEW *) 
           CreateButton(225, 115, 108, 145, 124, MK_FAR_PTR("OK"), cmOK, bttToDo));

    BankedAssign2(fld->handleEvent, myTextField_handleEvent);
    ExecView((PGROUP_PTR) frm);

    if (*c == 0)
    {
        strcpy (c, "-- No Name --");
    }
    InsertScore (c, myCash);

    Destroy((VOID_PTR) frm);
}

void MakeScoreVerificationCode(int nScoreIndex)
{
    int i, j, k;
    char t;
    char s[40];

    dtoa(hscores[nScoreIndex].score, s);
    strcpy(s + strlen(s)-1, hscores[nScoreIndex].name);

    for (i = strlen(s); i < 40; i++)
        s[i] = (char) (i % MAGIC_NUMBER_A);
    s[39] = '\0';

    j = MAGIC_NUMBER_B % 10;
    k = MAGIC_NUMBER_C % 20;
    for (i = 0; i < 40; i++)
    {
        t = s[j];
        s[j] = s[k];
        s[k] = t;
        j = (j + MAGIC_NUMBER_D + i) % 20;
        k = (k + MAGIC_NUMBER_E + i) % 20;
    }

    for (i = 0; i < 40; i += 8)
    {
        s[i] = (s[i] + MAGIC_NUMBER_A) % 256;
        s[i + 1] = (s[i + 1] + MAGIC_NUMBER_B) % 256;
        s[i + 2] = (s[i + 2] + MAGIC_NUMBER_C) % 256;
        s[i + 3] = (s[i + 3] + MAGIC_NUMBER_D) % 256;
        s[i + 4] = (s[i + 4] + MAGIC_NUMBER_E) % 256;
        s[i + 5] = (s[i + 5] + MAGIC_NUMBER_F) % 256;
        s[i + 6] = (s[i + 6] + MAGIC_NUMBER_G) % 256;
        s[i + 7] = (s[i + 7] + MAGIC_NUMBER_H) % 256;
    }

    for (i = 0; i < 8; i++)
        s[i] = (s[i] & 0x0F) + 65;

    s[8] = '\0';
}

void InitHighScores (void)
{
    int i;
    for (i = 0; i < 5; i++)
    {
        strcpy(hscores[i].name, "Kai Nothdurft");
        hscores[i].score = 4200 - (i*100);
    }
}

void InsertScore(char *playername, double newscore)
{
    int i = 0, j = 0;
    while (i < 5)
    {
        if (newscore >= hscores[i].score)
        {
            for (j = 4; j > i; j--)
            {
                hscores[j].score = hscores[j - 1].score;
                strcpy(hscores[j].name, hscores[j - 1].name);
            }
            hscores[i].score = newscore;
            strcpy(hscores[i].name, playername);
            i = 10;
        }
        i++;
    }
}

/*
 * Save High-Scores.
 */
static void SaveStatus(void)
{
  int i;
  char recbuf[sizeof(PIMHEAD)+sizeof(RECHEAD)+sizeof(HighScore)];
  PIMHEAD* pPIMHead=(PIMHEAD*)recbuf;
  RECHEAD* pRECHead=(RECHEAD*)(recbuf+sizeof(PIMHEAD));
  char* pFieldPtr;

  for (i = 0; i < 5; i++)
  {
    pFieldPtr=(char*)pRECHead+ 3 * sizeof(RECHEAD);

    /* Private Field Length 0. Private is marked via options in PIMHEAD */
    pRECHead[0].offset = pFieldPtr-recbuf;
    pRECHead[1].offset = pFieldPtr-recbuf;
    strcpy(pFieldPtr,hscores[i].name);
    pFieldPtr += strlen(hscores[i].name)+1;

    pRECHead[2].offset = pFieldPtr-recbuf;
    *(double*)pFieldPtr = (double)hscores[i].score;
    pFieldPtr += sizeof(double);

    memset(pPIMHead,0,sizeof(PIMHEAD));
    pPIMHead->typeID=CurrentAppID;
    pPIMHead->fieldCount=3;
    pPIMHead->recLength=pFieldPtr-recbuf;
    pPIMHead->synKeyOffset=pFieldPtr-recbuf;
    ChangeRecord(CurrentAppID, i, recbuf, pPIMHead->recLength);
  }
}

/*
 * Read high scores.
 */
static void OpenDatabase(void)
{
  int i;

  char recbuf[sizeof(PIMHEAD)+sizeof(RECHEAD)+sizeof(HighScore)];
  PIMHEAD *pPIMHead=(PIMHEAD*)recbuf;
  RECHEAD *pRECHead=(RECHEAD*)(recbuf+sizeof(PIMHEAD));

  /* Create database, if it doesn't exist, and save default game status. */
  if(!LoadIndexTable(CurrentAppID))
  {
    InitHighScores();

    LoadIndexTable(CurrentAppID);
    SaveStatus();
  }
  else
  {
    for (i = 0; i < 5; i++)
    {
        ReadRecord(CurrentAppID,i,0,recbuf,sizeof(recbuf));
        strcpy(hscores[i].name, (char *)(pRECHead[1].offset+recbuf));
        hscores[i].score = *(double *)(pRECHead[2].offset+recbuf);
    }
  }
  return;
}

static void LoadApplicationState()
{
  SaveGameType sg;
  int i;

  if (GetPreferenceLen(CurrentAppID))
  {
    ReadPreference(CurrentAppID, 0, &sg, sizeof(SaveGameType));
    myCash = sg.myCash;
    myDebt = sg.myDebt;
    myBank = sg.myBank;
    myCoat = sg.myCoat;
    myGuns = sg.myGuns;
    myTotal = sg.myTotal;
    myLocation = sg.myLocation;
    timeLeft = sg.timeLeft;
    copCount = sg.copCount;
    cheatsEnabled = sg.cheatsEnabled;
    cheatKey = 0;
    for(i = 0; i < 8; i++)
    {
      myDrugs[i] = sg.myDrugs[i];
      drugPrices[i] = sg.drugPrices[i];
    }
  }
  else
  {
    initGame();
  }
  intro();
  randomize();
}

static void SaveApplicationState()
{
  SaveGameType sg;
  int i;
  
  for(i = 0; i < 8; i++)
  {
    sg.myDrugs[i] = myDrugs[i];
    sg.drugPrices[i] = drugPrices[i];
  }

  sg.myCash = myCash;
  sg.myDebt = myDebt;
  sg.myBank = myBank;
  sg.myCoat = myCoat;
  sg.myGuns = myGuns;
  sg.myTotal = myTotal;
  sg.myLocation = myLocation;
  sg.timeLeft = timeLeft;
  sg.copCount = copCount;
  sg.cheatsEnabled = cheatsEnabled;

  SavePreference(CurrentAppID, &sg, sizeof(SaveGameType));
}  

static void DrawHighScores(int offset)
{
  int i;
  char s[14];

  for (i=0; i<5; i++)
  {
    itoa(i+1,s,10);
    strcat(s,".");
    WriteString(5, offset+(12*i), s, 0);
    if (hscores[i].score < 1)
        continue;
    WriteString(15, offset+(12*i), hscores[i].name, 0);
    strcpy(s,"$");
    dtoa(hscores[i].score, s+1);
    s[strlen(s)-1]=0;
    WriteString(104, offset+(12*i), s, 0);
  }
}           

void GameOver_draw(VOID_PTR thisView)
{
  char FinalCash[13];

  PDESKBOX_draw(thisView);
  dtoa(myCash, FinalCash);
  FinalCash[strlen(FinalCash)-1]=0;
  SetFontType(PRPFONT14N);
  WriteString(70, 65, FinalCash, 0);
  DrawHighScores(119);
}

unsigned short GameOver()
{
  PDESKBOX *dsk;
  unsigned short result;

  dsk = (PDESKBOX *)CreateDeskBox(230, 0, 0, 159, 239, MK_FAR_PTR((char *)"Game Over"),
         MK_FAR_PTR(HelpMenu), NULL_FP, bafDotTitle | bafClose);

  if (copCount == -1)
  {
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(231,  5, 25, 157, 37, MK_FAR_PTR((char *)"You're dead."), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(232,  5, 38, 157, 50, MK_FAR_PTR((char *)"Congratulations."), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
  }
  else if (myCash < 0)
  {
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(231,  5, 25, 157, 37, MK_FAR_PTR((char *)"The Loan Shark's thugs"), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(232,  5, 38, 157, 50, MK_FAR_PTR((char *)"broke your legs."), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
  }
  else if (myCash >= 1000000)
  {
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(231,  5, 25, 157, 37, MK_FAR_PTR((char *)"You retired a millionaire"), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(232,  5, 38, 157, 50, MK_FAR_PTR((char *)"in the Carribbean."),
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
  }
  else if (myCash > 2000)
  {
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(231,  5, 25, 157, 37, MK_FAR_PTR((char *)"Congratulations!"), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(232,  5, 38, 157, 50, MK_FAR_PTR((char *)"You didn't do half bad."),
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
  }
  else
  {
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(231,  5, 25, 157, 37, MK_FAR_PTR((char *)"You didn't make any money!"), 
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
    PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
           CreateLabel(232,  5, 38, 157, 50, MK_FAR_PTR((char *)"Better luck next time."),
                       lbofAlignLeft|lbofDefineFont, PRPFONT14N));
  }
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(233,  5, 65, 157, 76, MK_FAR_PTR((char *)"Final Cash: $"), 
                     lbofAlignLeft|lbofDefineFont, PRPFONT14N));

  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(234,  5, 100, 153, 112, MK_FAR_PTR((char *)"High Scores"), 
                     lbofAlignCenter|lbofDefineFont, PRPFONT14B));

  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
         CreateButton(235, 20, 200, 139, 216, MK_FAR_PTR("Start New Game"), cmOK, bttToDo));

  BankedAssign2(dsk->draw, GameOver_draw);

  result=ExecView((PGROUP_PTR) dsk);
  Destroy((VOID_PTR)dsk);
  return result;
}

static void finishGame(void)
{
    int i;

    makeDrugPrices(0);
    myCash=myCash+(myBank-myDebt);
    myBank=0;
    myDebt=0;
    for (i=0; i < 8; i++)
    {
      myCash=myCash+(myDrugs[i]*drugPrices[i]);
      myDrugs[i]=0;
    }
}   

static void FuzzEncounter(void)
{
    int i;
    unsigned char result = 3;
    int resolved = 0;
    unsigned char chaseagain = 0;
    char isare[5];

    if (copCount<1)
        return;
    
    while (!resolved)
    {
      result = Cops(chaseagain);
      if (!result)  /* Flee */
      {
        if (!(random(3)))
        {
            if (!(random(5)))
            {
              resolved = 2;
              MessageBox("You ran into a dead end, and the cops found you.", mfWarning);
              continue;
            }
            resolved=0;
            chaseagain=1;
            continue;
        }
        else
        {
          resolved=1;
          MessageBox("You lost them in the alleys.", mfWarning);
          continue;
        }
      }               
      else if (result) /* Fight for your drugs */
      {
        if (!myGuns)
        {
          MessageBox("You do not have a gun.", mfWarning);
          continue;
        }
        if (!(random(4)))
        {
          MessageBox("You shot and killed one of the cops.", mfWarning);
          copCount--;
          if (copCount < 1)
          {
            resolved = 1;
            continue;
          }
          chaseagain=1;
        }
        else
        {
          MessageBox("You shot at the cops, but missed.", mfWarning);
          chaseagain=1;
        }
        if (!(random(5)))
        {
          if (!(random(5)))
          {
            MessageBox("The cops shot you.  You died.", mfWarning);
            timeLeft = 0;
            copCount = -1;
            resolved = 1;
            continue;
          }
          MessageBox("The cops shot you, and you are wounded.", mfWarning);
          resolved = 2;
          continue;
        }
        else
        {
          MessageBox("The cops shot at you, but missed.", mfWarning);
        }
      }               
    }
    if (resolved==2)
    {
      MessageBox("The cops seized all your drugs and half of your cash.", mfWarning);
      for (i = 0; i < 8; i++)
          myDrugs[i] = 0;
      myCash=(myCash/2)+0.5;
      myCash=dint( &myCash );
      myTotal=0;
    }
}

unsigned char Cops(unsigned char still)
{
  PDESKBOX *dsk;
  char line1[40],
       line2[40],
       line3[40];
  unsigned char retval;       
  
  strcpy(line1, "Officer Hardass ");
  *line2=0;
  *line3=0;

  switch (copCount)
  {
  case 2:
      strcat(line1, "and one");
      break;
  case 3:
      strcat(line1, "and two");
      break;
  default:
      strcat(line1, "is ");
      if (still)
        strcat(line2,"still ");
      strcat(line2, "chasing you!");
      break;
  }

  if (copCount > 1)
  {
      strcat(line2, "of his deputies are ");
      if (still)
        strcat(line2,"still ");
      strcat(line3, "chasing you!");
  }

  dsk = (PDESKBOX *)CreateDeskBox(230, 2, 120, 157, 239, MK_FAR_PTR((char *)"Police"),
         MK_FAR_PTR(HelpMenu), NULL_FP, bafSmall);

  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(231,  7, 140, 155, 152, MK_FAR_PTR(line1),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(232,  7, 153, 155, 165, MK_FAR_PTR(line2),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(233,  7, 166, 155, 178, MK_FAR_PTR(line3),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(234,  7, 192, 155, 204, MK_FAR_PTR((char*)"What do you do?"),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(235, 9, 215, 49, 231, MK_FAR_PTR("Run"), cmCancel, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(236, 109, 215, 149, 231, MK_FAR_PTR("Fight"), cmOK, bttBasic));
  retval=ExecView((PGROUP_PTR) dsk);
  Destroy((VOID_PTR)dsk);
  return (unsigned char)(retval==cmOK);
}

void amountshark_draw(VOID_PTR thisView)
{
  char s[45];
  char* capital;

  PDESKBOX_draw(thisView);

  strcpy(s, "You have $");
  dtoa(myDebt, s+strlen(s));
  strcpy(s+strlen(s)-1, " debt and");
  WriteString(4, 33, s, 0);

  strcpy(s, "$");
  dtoa(myCash, s+strlen(s));
  strcpy(s+strlen(s)-1, " cash. How much would");
  WriteString(4, 47, s, 0);

  strcpy(s, "you like to ");
  capital=s+strlen(s); /* Here starts 'Borrow' or 'Repay' */
  fstrcpy(capital, ((PDESKBOX *)thisView)->title);
  *capital=*capital+32; /* 'decapitalize' ('B'->'b' u. 'R'->'r') it. */
  strcat(s,"?");
  WriteString(4, 61, s, 0);
}

static void VisitShark(void)
{
  unsigned char result=0,
                okay=0;
  double count;
  double maxloan;
  int loantoday=0;
  PDESKBOX *dsk;
  PDESKBOX *amountbox;
  PNUMBERFIELD *fld;
  static char BorrowLimit[]="The Loan Shark is unwilling to loan you that much money. He will loan you a maximum of $999999999.";
  
  
  /* Create 'What to do'-Dialog */
  dsk=(PDESKBOX *)CreateDeskBox(230, 2, 120, 157, 239, MK_FAR_PTR((char *)"Loan Shark Options"),
         MK_FAR_PTR(HelpMenu), NULL_FP, bafSmall);

  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(231,  7, 153, 155, 165, MK_FAR_PTR((char*)"What would you like to"),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *)
         CreateLabel(232,  7, 166, 155, 178, MK_FAR_PTR((char*)"do at the loan shark?"),
                     lbofAlignCenter|lbofDefineFont, PRPFONT14N));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(233, 4, 215, 49, 231, MK_FAR_PTR("Done"), cmCancel, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(232, 4, 215, 49, 231, MK_FAR_PTR("Done"), cmCancel, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(233, 57, 215, 101, 231, MK_FAR_PTR("Repay"), cmRepay, bttBasic));
  PGROUP_insert((VOID_PTR) dsk, (PVIEW *) 
             CreateButton(234, 109, 215, 154, 231, MK_FAR_PTR("Borrow"), cmBorrow, bttBasic));

  /* Create 'How much'-Dialog */
  amountbox=(PDESKBOX *)CreateDeskBox(235, 1, 17, 158, 81, 
        NULL_FP, NULL_FP, NULL_FP, bafSmall | bafCheck | bafClose );
  fld=(PNUMBERFIELD *)CreateNumberField(238, 100, 61,(unsigned char *) &count, DTINTEGER,
                                        MK_FAR_PTR(EnterNumber));
  PGROUP_insert((VOID_PTR) amountbox, (PVIEW *)fld);
  BankedAssign2(amountbox->draw, amountshark_draw);
  BankedAssign2(fld->handleEvent, myNumberField_handleEvent);

  while (result!=cmCancel)
  {
    result=ExecView((PGROUP_PTR) dsk);
    LCDCopy(REALTOVIRT);

    if (result==cmRepay)
    {
      if (myDebt < 1)
      {
        MessageBox("You do not have any debt.", mfWarning);
        continue;
      }

      amountbox->title=MK_FAR_PTR("Repay");
      okay=0;
      while(!okay)
      {
        count=MIN(myDebt,myCash);
        okay=ExecView((PGROUP_PTR)amountbox);
        LCDCopy(VIRTTOREAL);

        if (okay == cmCancel)
        {
          okay=1;
          count=0;
          continue;
        }
        else
          okay=0;
        if (count < 0)
          continue;
        if ((myCash-count) < 0)
        {
          MessageBox(LackMoney, mfWarning);
          continue;
        }
        if ((myDebt-count) < 0)
        {
          MessageBox("You should not overpay the Loan Shark.", mfWarning);
          continue;
        }
        okay=1;
      }
      myDebt=myDebt-count;
      myCash=myCash-count;
    }
    else if (result==cmBorrow)
    {
      if (loantoday)
      {
        MessageBox("The Loan Shark will not loan you any more money today.", mfWarning);
        continue;
      }

      maxloan=myCash*SHARK_MULTIPLIER;
      if (maxloan < 5500)
          maxloan=5500;
      if ((maxloan+myCash) > 999999999)
          maxloan = 999999999-myCash;
      amountbox->title=MK_FAR_PTR("Borrow");
      okay=0;
      while(!okay)
      {
        count=maxloan;
        okay=ExecView((PGROUP_PTR)amountbox);
        LCDCopy(VIRTTOREAL);

        if (okay == cmCancel)
        {
          okay=1;
          count=0;
          continue;
        }
        else
          okay=0;
        if (count < 0)
          continue;

        if (count > maxloan)
        {
            dtoa(maxloan, strstr(BorrowLimit,(char *) "9"));
            MessageBox(BorrowLimit, mfWarning);
            continue;
        }
        if ((count + myCash) > 99999999)
            continue;
        okay = 1;
      }
      myDebt=myDebt+count;
      myCash=myCash+count;
      if (okay)
        loantoday = 1;
    }               
  }
  Destroy((VOID_PTR)amountbox);
  Destroy((VOID_PTR)dsk);
}

void help(char chapter)
{
  MessageBox("No help implemented yet.", mfWarning);
}