;Daily alarm test 		August 2002 by Edwin Blink

;assemble using my TASM make 2.0(or higher) utility

			.include "avigo.inc"
			.include "Header.asm"


DailyAlarmTime:		.equ	$C093


DailyLabelLeft:		.equ	4
DailyLabelTop:		.equ	24
DailyFieldTop:		.equ	DailyLabelTop + 12
DailyFieldLeft:		.equ	DailyLabelLeft


		;- Create a Deskbox -

		push	ix
		ld	ix,-5		;create space on stack	
		add	ix,sp
		ld	sp,ix
		
		
		ld	hl,bafDefault+bafClose+bafDotTitle
		
		push	hl			;stack attributes
		
		ld	hl,0			;Stack null
		push	hl
		push	hl
		
		push	hl			;stack null again
		push	hl
		
		ld	hl,$00A0		;stack *message'Daily Alarm' 
		call	GetSysMessageAddr
		call	StackLong

		ld	l,239			;bottom
		push	hl
		ld	l,159			;right
		push	hl
		ld	e,0			;left
		push	de			;top
		ld	l,'D'			;id
		ld	bc,CreateDeskBox
		call	BankedCall
		ld	(ix+0),l
		ld	(ix+1),h
		ex	de,hl			;* in DE
		ld	hl,CreateDeskBoxStackRestore
		add	hl,sp
		ld	sp,hl

		;disable find button
		
		ld	hl,PTIMEFIELD_OPTIONS
		add	hl,de
		res	ofFindableBit,(hl)

		;Set custom deskboxdraw
		
		ld	hl,PDESKBOX_DRAW
		add	hl,de
		ld	de,DailyAlarmDrawDeskbox
		call	StoreAsFar
				
		;- create timefield -

		push	ix			;stack *time
		pop	hl
		inc	hl
		inc	hl			;IX+2= *time
		Push	hl
		ld	bc,($C093)		;Copy Daily alarm time to buffer
		ld	(hl),c
		inc	hl
		ld	(hl),b
		inc	hl
		ld	(hl),0
		ld	l,DailyFieldTop
		push	hl			
		ld	e,DailyFieldLeft
		ld	l,'A'
		ld	bc,CreateTimeField
		call	BankedCall					
		pop	bc
		pop	bc
		
		
		;Set custom SetTimeFieldState (Not needed when custum handleTimeFieldEventEvent)

		push	hl
		ld	de,PTIMEFIELD_SETSTATE
		add	hl,de
		ld	de,DailyAlarmTimeFieldSetState
		call	StoreAsFar
		pop	hl
		
		
		;Set custom HandleTimeFieldEvent

		push	hl
		ld	de,PTIMEFIELD_EVENT
		add	hl,de
		ld	de,DailyAlarmTimeFieldEvent
		call	StoreAsFar
		pop	de
			
		;enable 'No Time' button

		ld	hl,PTIMEFIELD_ATTRIB
		add	hl,de
		ld	(hl),0			
		
		;Insert into deskbox
		
		
		ld	l,(ix+0)
		ld	h,(ix+1)
		push	hl
		ld	bc,PDESKBOX_INSERT+1
		add	hl,bc
		ld	b,(hl)
		dec	hl
		ld	c,(hl)
		push	bc
		call	LoadBank
		pop	bc
		pop	hl
		call	indirect_call		

		
		;execute deskbox
				
		ld	l,(ix+0)
		ld	h,(ix+1)
		ld	bc,ExecuteView	
		call	BankedCall

		;destroy deskbox
		
		ld	l,(ix+0)
		ld	h,(ix+1)		
		ld	bc,DestroyResource
		call	BankedCall
		
		;return to Application
		
		ld	hl,5
		add	hl,sp
		ld	sp,hl
		ld	hl,cmApplication
		pop	ix
		ret

StoreAsFar:
		ld	(hl),e
		inc	hl
		ld	(hl),d
		inc	hl
		ex	de,hl
		call	GetRomBank
		ex	de,hl
		ld	(hl),e
		inc	hl
		ld	(hl),d
		ret
		
;----------------------------------------------------------------------------------------------
;Required because of the daily alarm label

DailyAlarmDrawDeskbox:		;draw normal deskbox

				push	hl
				ld	bc,DrawDeskbox
				call	BankedCall
				pop	hl

				;draw alarm message

				ld	de,PDESKBOX_TOP
				add	hl,de
				ld	a,(hl)
				add	a,DailyLabelTop
				ld	e,a
				dec	hl
				ld	a,(hl)
				add	a,DailyLabelLeft
				ld	l,a
				ld	h,e
				push	hl		;save Left, Top
				ld	c,0
				push	bc
				ld	bc,$00A0	;'Daily Alarm'
				push	bc
				call	WriteSysStr
				pop	bc
				pop	bc
				pop	hl
				
				;write ':' after message
		
				
					
WriteColon:	
				push	hl
				push	bc
				ld	c,':'
				push	bc
				add	a,2
				ld	l,a
				ld	e,h
				call	WriteChar
				pop	bc
				pop	bc
				pop	hl
				ret
				
;----------------------------------------------------------------------------------------------
;Custom SetTimeField State 

;This is a work around to make sure that whenever the timepicker is shown.
;the correct title is written 

DailyAlarmTimeFieldSetState:

				push	de
				ld	c,e		;C=State
				ex	de,hl		;save *TimeField
				ld	hl,6+2
				add	hl,sp
				ld	l,(hl)
				ld	h,0				
				push	hl		;SP+2
				ex	de,hl
				ld	e,c
				ld	bc,SetSquareFieldState
				call	BankedCall
				pop	de
				pop	hl
				dec	e
				ret	nz			;ret not display
				
				ld	a,c
				and	a
				ret	z			;ret State 0
				
				ld	hl,$00A0		;DailyAlarm
				call	GetSysMessageAddr
				ex	de,hl	
				ld	hl,$F154		;farstring
				jp	StoreLong
				
;----------------------------------------------------------------------------------------------

DailyAlarmTimeFieldEvent:

;Required to because when the timefield picker is closed the Daily alarm must be set or
;reset. This Event handler  calls the normal event handler for a time field and then checks
;and sets the daily alarm.
;However it would be better to rewrite the event handler to check if changes should be applied
;When rewriting the event handler the timepicker Title can also be set when the timepicker 
;is made visibleand there is no need for a modified SetTimeFieldState to set the Title

				push	hl
				ld	hl,6+2
				ld	b,h
				add	hl,sp
				ld	a,(hl)
				inc	hl
				inc	hl
				ld	c,(hl)
				pop	hl
				push	hl
				push	bc
				ld	c,a
				push	bc				
				ld	bc,HandleTimeFieldEvent
				call	BankedCall
				pop	bc
				pop	bc
				pop	de

				ld	hl,PTIMEFIELD_TIME
				add	hl,de
				ld	a,(hl)
				inc	hl
				ld	h,(hl)
				ld	l,a
				ld	a,($C093)		;AlarmHour
				cp	(hl)
				jr	nz,ChangeAlarm
				inc	a			;FF no date
				jr	z,NoAlarmChange
				ld	a,($C094)		;AlarmMinutes
				inc	hl
				cp	(hl)
				dec	hl
				jr	z,NoAlarmChange
ChangeAlarm:
				ld	a,(hl)
				inc	a
				ld	e,$41			;DisableDailyAlarm
				jr	z,$+4
				ld	e,$01			;EnableDailyAlarm
				ld	bc,SetSpecialAlarm				
				call	BankedCall
NoAlarmChange:
				ret
