/********************************************************
 * 
 * Title: Kralj
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/01/25 22:17:32
 *
 *
 * This is the main file for the chess program kralj
 *
 ********************************************************/

/********************************************************
 * All used headers are declared in the kralj header
 ********************************************************/
#include <avsys.h>
#include <avgui.h>
#include <knotools.h>
#include "kralj.h"
#include "chess.h"
#include "drawing.h"
#include "game.h"


/********************************************************
 * Menu commands are only used in this implementation.
 * Therefor they are not defined in the header file.
 ********************************************************/
#define cmGameNew 0x2001
#define cmGameLoad 0x2002
#define cmGameSave 0x2003
#define cmGameRestart 0x2004
#define cmOption 0x2050
#define cmInformation 0x2060
#define cmHelp 0x2070

/*
===============================================================================
 Use code segment to save ram
=============================================================================== 
*/
#pragma codeseg

/*
 * The static strings will be stored in the code segment
 * to save place in the ram
 */
char WindowTitle[]="Kralj";
char Version[]="0.0.0 aplha 1";
char Date[]="2000-02-22";
char NotImplemented[]="Sorry, currently not implemented!";

/*
 * The start menu
 */
MENUITEM StartMenu[]=
{
   {"New game", cmGameNew, lstDisplay},
   {"Load game", cmGameLoad, lstDisplay},
   {"Option", cmOption, lstDisplay | lstUnderLine},
	 {"Information", cmInformation, lstDisplay | lstUnderLine },
	 {"Help", cmHelp, lstDisplay | lstUnderLine },
   {"Exit", cmCancel, lstDisplay},
   {"\0", 0, 0} 
};

/*
 * The start menu
 */
MENUITEM PlayingMenu[]=
{
	 {"Restart game", cmGameRestart, lstDisplay},
   {"New game", cmGameNew, lstDisplay},
   {"Load game", cmGameLoad, lstDisplay},
	 {"Save game", cmGameSave, lstDisplay},
   {"Option", cmOption, lstDisplay | lstUnderLine},
	 {"Information", cmInformation, lstDisplay | lstUnderLine },
	 {"Help", cmHelp, lstDisplay | lstUnderLine },
   {"Exit", cmCancel, lstDisplay},
   {"\0", 0, 0} 
};


/*
===============================================================================
 Use default segment again
=============================================================================== 
*/
#pragma defaultseg

/* 
===============================================================================
 Some global variables that are used in other places too
=============================================================================== 
*/

/********************************************************
 * Declare pointer for our DeskBox that is created in the
 * main function
 ********************************************************/
PDESKBOX *dsk;

/********************************************************
 * The global game data
 ********************************************************/
Game game;

/********************************************************
 * Prototype functions
 ********************************************************/
void DebugPrint(char* msg);
void DebugPrintInt(char* msg, int outvalue);

void info_not_implemented();

void dsk_handlePenDownMoveEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y);
void dsk_handlePenDownEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y);
void dsk_handlePenUpEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y);
void dsk_handleCommandEvent(VOID_PTR view, unsigned int *evType, unsigned char x, unsigned char y);
void dsk_handleTimerEvent();

void menu_new_game();

/* ------------------------------------------------------
 * |                                                    |
 * |   Starting implementation of functions             |
 * |                                                    |
 * ------------------------------------------------------
 */

/********************************************************
 * Debug output function
 ********************************************************/
void DebugPrint(char* msg)
{
	_asm
	{
		ld h,_msg+1(ix)
		ld l,_msg+0(ix)
		.dw 0xfeed
	}
}


/********************************************************
 * Debug output function
 ********************************************************/
void DebugPrintInt(char* msg, int outvalue)
{
	char textvalue[6]; /* Should be enough for a integer */
	itoa( outvalue, textvalue, 10 );
	DebugPrint( msg );
	DebugPrint( textvalue );
}

/* ------------------------------------------------------
 * |                                                    |
 * |   Option menu                                      |
 * |                                                    |
 * ------------------------------------------------------
 */

/********************************************************
 * Option menu
 ********************************************************/
void menu_option()
{	

	Options o;

	/*
	 * Local reference to the DeskBox and other components
	 */	
	PDESKBOX *optionsdsk;

	/*
	 * A label and numset of the animation speed
	 */
	PNUMBERSET *numset_animationspeed;
	PLABEL *label_animationspeed;

	/*
	 * A label and boolfield of the show last move
	 */
	PBOOLFIELD *boolfld_showlastmove;
	PLABEL *label_showlastmove;

	/*
	 * A label and boolfield of the ticks
	 */
	PBOOLFIELD *boolfld_ticks;
	PLABEL *label_ticks;

	/*
	 * A label and boolfield of the beeps
	 */
	PBOOLFIELD *boolfld_beep;
	PLABEL *label_beep;



	/*
	 * Init the temporary options var
	 */
	o = game.options;

	/*
	 * create the components
	 */
  label_animationspeed = (PLABEL *)CreateLabel(211, 10, 30, 90, 50, MK_FAR_PTR("Animation Speed :"),
           lbofAlignRight|lbofDefineFont, PRPFONT11N);
	numset_animationspeed = (PNUMBERSET *)CreateNumberSet(212, 110, 30, 1, 9, 1, &o.animation_speed);	

  label_showlastmove = (PLABEL *)CreateLabel(221, 10, 60, 90, 80, MK_FAR_PTR("Show last move :"),
           lbofAlignRight|lbofDefineFont, PRPFONT11N);
	boolfld_showlastmove = (PBOOLFIELD *)CreateBoolField(222, 110, 60, &o.show_last_move, 1);

  label_ticks = (PLABEL *)CreateLabel(231, 10, 90, 90, 110, MK_FAR_PTR("Sound Ticker:"),
           lbofAlignRight|lbofDefineFont, PRPFONT11N);
	boolfld_ticks = (PBOOLFIELD *)CreateBoolField(232, 110, 90, &o.ticks, 1);

  label_beep = (PLABEL *)CreateLabel(241, 10, 120, 90, 140, MK_FAR_PTR("Sound Alert :"),
           lbofAlignRight|lbofDefineFont, PRPFONT11N);
	boolfld_beep = (PBOOLFIELD *)CreateBoolField(242, 110, 120, &o.beep, 1);

	/* 
	 * Create first the main deskbox
	 */
	optionsdsk = (PDESKBOX *)CreateDeskBox(200, 0, 0, 159, 239, 
		MK_FAR_PTR("Options"), NULL_FP, NULL_FP,
		bafClose | bafCheck ); 

	/*
	 * Add the components to the new DeskBox
	 */
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) label_animationspeed);
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) numset_animationspeed);	
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) label_showlastmove);	
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) boolfld_showlastmove);		
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) label_ticks);	
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) boolfld_ticks);		
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) label_beep);	
	PGROUP_insert((VOID_PTR) optionsdsk, (PVIEW *) boolfld_beep);	


	/* 
	 * Here's the 'magic' function that does most of the work of the program.
	 * ExecView() will draw, and redraw when needed, our deskbox and all our controls.
	 * It will continuously poll for pen and button input, then send messages to the
	 * controls and the DeskBox itself, and invoke their handlers.  It will exit when
	 * it processes a cmCancel or cmQuit command message. 
	 */
	if( ExecView((PGROUP_PTR) optionsdsk) == cmOK )
	{
		game.options = o;
	}

	/*
	 * Finally, we'll 'destroy' the DeskBox to free up its resource memory. 
	 */
	Destroy((VOID_PTR) optionsdsk);

	/*
	 * Redraw the main screen
	 */
	PDESKBOX_redraw((VOID_PTR) dsk);
	
	
}


/* ------------------------------------------------------
 * |                                                    |
 * |   New game menu                                    |
 * |                                                    |
 * ------------------------------------------------------
 */

/*
===============================================================================
 Use code segment to save ram
=============================================================================== 
*/
#pragma codeseg

/*
 * The players available in the new game menu
 */
STACKEDITEM GameTypePlayerList[]=
{
	{ "Human" },
	{	"Avigo" },
	{ "\0" }
};

/*
 * The players available in the new game menu
 */
STACKEDITEM GameTypeList[]=
{
	{ "Unlimited" },
	{	"Timer in min:sec" },
	{ "Increment in min:sec" },
	{ "\0" }
};


/*
===============================================================================
 Use default segment again
=============================================================================== 
*/
#pragma defaultseg


GameType ngg;


/********************************************************
 * New game menu
 ********************************************************/
void menu_new_game()
{	

	/*
	 * Local reference to the DeskBox and other components
	 */	
	PDESKBOX *newgamedsk;
	PSTACKEDLIST *stackedlist_gameplayertype_white;
	PSTACKEDLIST *stackedlist_gameplayertype_black;
	PSTACKEDLIST *stackedlist_gametype;
	PNUMBERSET *numset_level_white;
	PNUMBERSET *numset_level_black;
	PNUMBERSET *numset_timer_minute;
	PNUMBERSET *numset_timer_second;
	PNUMBERSET *numset_increment_minute;
	PNUMBERSET *numset_increment_second;

	/*
	 * Init some basics
	 */
	ngg.white_player = PLAYERTYPE_HUMAN;
	ngg.black_player = PLAYERTYPE_AVIGO;
	ngg.level_white = 5;
	ngg.level_black = 5;
	ngg.game_type = GAMETYPE_UNLIMITED;
	ngg.timer_minute = 15;
	ngg.timer_second = 0;
	ngg.increment_minute = 0;
	ngg.increment_second = 15;


	/* 
	 * Create first the main deskbox
	 */
	newgamedsk = (PDESKBOX *)CreateDeskBox(200, 0, 0, 159, 239, 
		MK_FAR_PTR("New game"), NULL_FP, NULL_FP,
		bafClose | bafCheck ); 

	/*
	 * Create all components - white props first
	 */
	stackedlist_gameplayertype_white = (PSTACKEDLIST *) CreateStackedList(210, 35, 35, 55, MK_FAR_PTR(GameTypePlayerList), &ngg.white_player);
	numset_level_white = (PNUMBERSET *)CreateNumberSet(211, 130, 42, 1, 12, 1, &ngg.level_white);	

	/*
	 * Now following the black props
	 */
	stackedlist_gameplayertype_black = (PSTACKEDLIST *) CreateStackedList(220, 35, 95, 55, MK_FAR_PTR(GameTypePlayerList), &ngg.black_player);
	numset_level_black = (PNUMBERSET *)CreateNumberSet(221, 130, 102, 1, 12, 1, &ngg.level_black);

	/*
	 * Game type
	 */
	stackedlist_gametype = (PSTACKEDLIST *) CreateStackedList(230, 35, 155, 110, MK_FAR_PTR(GameTypeList), &ngg.game_type);
	numset_timer_minute = (PNUMBERSET *)CreateNumberSet(231, 35, 211, 1, 99, 1, &ngg.timer_minute);
	numset_timer_second = (PNUMBERSET *)CreateNumberSet(232, 60, 211, 0, 59, 1, &ngg.timer_second);
	numset_increment_minute = (PNUMBERSET *)CreateNumberSet(231, 105, 211, 0, 99, 1, &ngg.increment_minute);
	numset_increment_second = (PNUMBERSET *)CreateNumberSet(232, 130, 211, 0, 59, 1, &ngg.increment_second);


	/*
	 * Add the components to the new DeskBox
	 */
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) stackedlist_gameplayertype_white);
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_level_white);
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) stackedlist_gameplayertype_black);
	/* PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_level_black); */
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) stackedlist_gametype);
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_timer_minute);
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_timer_second);
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_increment_minute);
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_increment_second);

	/*
	 * Important: This object has to be the last one, because it owns the numset focus
	 */
	PGROUP_insert((VOID_PTR) newgamedsk, (PVIEW *) numset_level_black);

	/* 
	 * Now we will assign the two handlers we implemented earlier to our DeskBox.
	 * There are two functions that do this.  Use 'BankedAssign1()' if your handler
	 * has only one argument, and 'BankedAssign2()' if it has two or more.  A handler
	 * will never have zero arguments.  Note: two functions are needed because of the
	 * differences in the way parameters are passed in the FWSDK and in the Avigo
	 * internally. The 'Official $DK' uses just one: BankedAssign()
	 */
	BankedAssign1(newgamedsk->draw,dsk_draw_menu_new_game); 
	BankedAssign2(newgamedsk->handleEvent,dsk_menu_new_game_handleEvent);
	

	/* 
	 * Here's the 'magic' function that does most of the work of the program.
	 * ExecView() will draw, and redraw when needed, our deskbox and all our controls.
	 * It will continuously poll for pen and button input, then send messages to the
	 * controls and the DeskBox itself, and invoke their handlers.  It will exit when
	 * it processes a cmCancel or cmQuit command message. 
	 */
	if( ExecView((PGROUP_PTR) newgamedsk) == cmOK ) 
	{
		/* The user commited his selection - Now reset the game */		
		reset_game( ngg );
	}

	/*
	 * Finally, we'll 'destroy' the DeskBox to free up its resource memory. 
	 */
	Destroy((VOID_PTR) newgamedsk);

	/*
	 * Redraw the main screen
	 */
	PDESKBOX_redraw((VOID_PTR) dsk);
	
	
}

/********************************************************
 * This function operates most like a paint function
 ********************************************************/
void dsk_menu_new_game_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{

	/*
	 * Using to see if we need a refersh after all checks
	 */
	unsigned char refresh;

	/*
	 * Check if the events have to be ignored
	 * This is used to prevent events to unvisible controls
	 */
	if( ngg.white_player == 0 && x>100 && x<155 && y>31 && y<67) return;
	if( ngg.black_player == 0 && x>100 && x<155 && y>91 && y<127) return;
	if( ngg.game_type == 0 && x>3 && x<156 && y>201 && y<236) return;
	if( ngg.game_type == 1 && x>86 && x<156 && y>201 && y<236) return;

	/*
	 * Use to see if we need a refresh of the DeskBox
	 */
	refresh = FALSE;
	if(*evType == evPenDown ) 
	{
		refresh = TRUE;
	}

	/* 
	 * Do default handling (process pen events, etc...)
	 */
	PDESKBOX_handleEvent( view, evType, x, y ); 

	if( refresh == TRUE ) PDESKBOX_redraw((VOID_PTR) view);

}

/********************************************************
 * This function operates most like a paint function
 ********************************************************/
void dsk_draw_menu_new_game(VOID_PTR view)
{

	SetToVirtualLCD(1);	

	/*
	 * Draw the deskbox and the components
	 */
	PDESKBOX_draw(view);	

	/*************************************
	 * draw the additional screen elements
	 *************************************/

	/*
	 * Draw white player
	 */
	draw_figure( WHITE_KING, 0, 41 );				
	DrawRect( 2, 15, 157, 70, DRAW_BLACK );	
	FillRect( 4, 17, 155, 30, DRAW_BLACK );	
	WriteString( 5, 19, "White Player", 1 ); 	
	if( ngg.white_player == 0 )
	{		
		FillRect( 100,31, 155, 67, DRAW_WHITE );
	}
	else WriteString( 100, 44, "Level:", 0 ); 

	/*
	 * Draw black player
	 */
	draw_figure( BLACK_KING, 0, 101 );				
	DrawRect( 2, 75, 157, 130, DRAW_BLACK );	
	FillRect( 4, 77, 155, 90, DRAW_BLACK );	
	WriteString( 5, 79, "Black Player", 1 ); 	
	if( ngg.black_player == 0 )
	{		
		FillRect( 100,91, 155, 127, DRAW_WHITE );
	}
	else WriteString( 100, 104, "Level:", 0 );  


	/*
	 * Draw game type
	 */	
	draw_sprite( 10, 161, 2, 16, 32, 40, SPRITE_MODE_OR );
	DrawRect( 2, 135, 157, 237, DRAW_BLACK );	
	FillRect( 4, 137, 155, 150, DRAW_BLACK );	
	WriteString( 5, 139, "Game Type", 1 ); 		
	if( ngg.game_type == 0 ) FillRect( 3, 201, 85, 236, DRAW_WHITE );
	if( ngg.game_type == 1 || ngg.game_type == 0 ) FillRect( 86, 201, 156, 236, DRAW_WHITE );
	switch( ngg.game_type )
	{
		case 2:
			WriteString( 126, 213, ":", 0 ); 	
			WriteString( 88, 213, "Inc:" , 0 );
		case 1:			
			WriteString( 56, 213, ":", 0 ); 	
			WriteString( 4, 213, "Timer:" , 0 );
	}

	SetToRealLCD(1);

}

/* ------------------------------------------------------
 * |                                                    |
 * |   Main window                                      |
 * |                                                    |
 * ------------------------------------------------------
 */


/********************************************************
 * Init the game to indicate game as started
 ********************************************************/
void game_started(VOID_PTR view)
{
	
	

	game.game_started=TRUE; /* Indicate that game is started */
}

/********************************************************
 * This function operates most like a paint function
 ********************************************************/
void dsk_draw(VOID_PTR view)
{

	SetToVirtualLCD(1);

	PDESKBOX_draw(view);	

	draw_playground();

	SetToRealLCD(1);
	

}

 
/********************************************************
 * Replacement event handler for DESKBOX.  This is where 
 * we do what we need to do in response to the events we
 * receive
 ********************************************************/
void dsk_handleEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{  

	/* 
	 * For the gui, we're only interested in the 'command' events 
	 */
	if(*evType == evCommand) dsk_handleCommandEvent( view, evType, x, y );

	/*
	 * Now check the pen downs
	 */
	if(*evType == evPenDown) dsk_handlePenDownEvent( view, evType, x, y );

	/*
	 * On pen up stop moving
	 */
	if(*evType == evPenUp) dsk_handlePenUpEvent( view, evType, x, y );

	/*
	 * Now move the figure with drag and drop
	 */
	if(*evType == evPenDownMove) dsk_handlePenDownMoveEvent( view, evType, x, y );

	/*
	 * Game started - count the timer
	 */	
	if(*evType == evTimer && game.game_started == TRUE ) dsk_handleTimerEvent();


	/* 
	 * Do default handling (process pen events, etc...)
	 */
	PDESKBOX_handleEvent( view, evType, x, y ); 
	
}


/********************************************************
 * Handle the timer events
 ********************************************************/
void dsk_handleTimerEvent()
{
	if( game.chessboard.players.nextplayer == WHITE_PLAYER_NEXT )
	{
		if( game.gametype.game_type == GAMETYPE_UNLIMITED )
		{
			if( game.chessboard.players.white.time < 32767 ) game.chessboard.players.white.time++;
		}
		else
		{
			if( game.chessboard.players.white.time > 0 ) 
			{
				game.chessboard.players.white.time--;
			}
			else
			{
				game.game_started = FALSE;
			}
		}
	}
	else
	{
		if( game.gametype.game_type == GAMETYPE_UNLIMITED )
		{
			if( game.chessboard.players.black.time < 32767 ) game.chessboard.players.black.time++;
		}
		else
		{
			if( game.chessboard.players.black.time > 0 ) 
			{
				game.chessboard.players.black.time--;
			}
			else
			{
				game.game_started = FALSE;
			}
		}

	}
	draw_player_infos(); /* update gui */
}

/********************************************************
 * Handle the command events
 ********************************************************/
void dsk_handleCommandEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{
   if (*evType == evCommand)
   {		 
      switch(TOWORD(x,y)) /* TOWORD combines the 8-bit 'x' and 'y' into one
                             16-bit value, the 'command'. */
      {
         case cmGameNew :
                           menu_new_game();
                           break;
         case cmGameLoad :                                                      
   	                     break;
				 case cmOption :
										menu_option();
										break;
         case cmPgUp :
                           MessageBox("Up",
                              mfWarning | mfYesButton);
                           break;
         case cmPgDn :
                           MessageBox("Down",
                              mfWarning | mfYesButton);
                           break;
         case cmHelp :
                           break;
         case cmInformation : 
                           break;
      }
   }
}

/********************************************************
 * Handle the PenDownMove event
 ********************************************************/
void dsk_handlePenDownMoveEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{  	
	if( game.chessboard.selected_field.figure.type != NONE )
	{			
		game.chessboard.board[game.chessboard.selected_field.pos.x][game.chessboard.selected_field.pos.y]=NONE;
		move_drag_and_drop( x, y);
	}
}

/********************************************************
 * Handle the PenUp event
 ********************************************************/
void dsk_handlePenUpEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{
	Point temp_point;

	if( game.chessboard.selected_field.figure.type != NONE ) 
	{
		/*
		 * Ok - check out where the user wants to move his figure		 
		 */
		game.chessboard.destination_field = get_chessboard_field( x, y );		

		/* 
		 * The game.chessboard is global
		 * Verify the move from game.chessboard.selected_field to game.chessboard.destination_field
		 * chess_make_move() returns FALSE if the move is illegal. Otherwise it
		 * the performes the move internal.
		 */		
		if( chess_make_move() == FALSE ) 
		{
			/* Move not possible */						
			/* temp_point = game.chessboard.destination_field.figure.pos; */
			game.chessboard.destination_field = game.chessboard.selected_field;
			/* game.chessboard.destination_field.figure.pos = temp_point; */
		}
		else
		{			
			if( game.game_started == FALSE ) game_started(view); /* Indicate that game is started */
			if( game.chessboard.players.nextplayer == WHITE_PLAYER_NEXT ) 
			{
				if( game.gametype.game_type == GAMETYPE_INCREMENT ) game.chessboard.players.white.time = game.chessboard.players.white.time + game.gametype.increment_minute*60 + game.gametype.increment_second;
				if( game.chessboard.players.white.time < 0 ) 32767;
				game.chessboard.players.nextplayer=BLACK_PLAYER_NEXT;
			}
			else 
			{
				if( game.gametype.game_type == GAMETYPE_INCREMENT ) game.chessboard.players.black.time = game.chessboard.players.black.time + game.gametype.increment_minute*60 + game.gametype.increment_second;
				if( game.chessboard.players.black.time < 0 ) 32767;
				game.chessboard.players.nextplayer=WHITE_PLAYER_NEXT;			
			}
		}

		/* Make the move to game.chessboard.destination_field */
		make_move();
		/* Reset the selected field */
		game.chessboard.selected_field.figure.type=NONE;
	}
}

/********************************************************
 * Handle the PenDown event
 ********************************************************/
void dsk_handlePenDownEvent(VOID_PTR view, unsigned int *evType, unsigned char x,
   unsigned char y)
{

	if( (game.chessboard.players.nextplayer==WHITE_PLAYER_NEXT && game.gametype.white_player!=PLAYERTYPE_HUMAN) ||
			(game.chessboard.players.nextplayer==BLACK_PLAYER_NEXT && game.gametype.black_player!=PLAYERTYPE_HUMAN)
			) return;

	game.chessboard.selected_field=get_chessboard_field(x, y);	

	if( (game.chessboard.players.nextplayer==WHITE_PLAYER_NEXT && (game.chessboard.selected_field.figure.type/BLACK_FIGURES)==1) ||
			(game.chessboard.players.nextplayer==BLACK_PLAYER_NEXT && (game.chessboard.selected_field.figure.type/WHITE_FIGURES)==1)
			) game.chessboard.selected_field.figure.type=NONE;

	/* Mark as selected */
	if( game.chessboard.selected_field.figure.type != NONE ) {
		game.chessboard.destination_field.figure.type = game.chessboard.selected_field.figure.type;
		SetToVirtualLCD(1);
		draw_square(SELECTED, game.chessboard.selected_field.pos.x, game.chessboard.selected_field.pos.y );
		game.chessboard.selected_field.selected = TRUE;
		SetToRealLCD(1);
		BackupWindow( game.chessboard.left, game.chessboard.top, game.chessboard.left+18*8, game.chessboard.top+18*8, GetLCDBackBufAddr() );
		/* Here we backuped the whole game.chessboard without the selected figure. This is only
		 * needed if we move the figusre with the drag and drop system. Next step is to
		 * set the figure back. This is for the set/put system moves important.
		 */
		SetToVirtualLCD(1);
		draw_field(SELECTED, game.chessboard.selected_field.pos.x, game.chessboard.selected_field.pos.y );
		SetToRealLCD(1);
	}
}

/********************************************************
 * Replacement event handler for DESKBOX. This is where 
 * we do what we need to do in response to the events we
 * receive
 ********************************************************/
void info_not_implemented() 
{
	MessageBox(NotImplemented, 0x0);
}

/********************************************************
 * Initialize all important things first
 ********************************************************/
void init() {

	ngg.black_player = PLAYERTYPE_AVIGO;
	ngg.white_player = PLAYERTYPE_HUMAN;
	ngg.game_type = GAMETYPE_UNLIMITED;
	ngg.level_black = 3;
	ngg.level_white = 4;
	ngg.timer_minute = 10;
	ngg.timer_second = 0;
	ngg.increment_minute = 0;
	ngg.increment_second = 10;

	reset_options();
	reset_game(ngg);
}

/********************************************************
 * This is the starting function. It creates the main
 * deskbox with the main game menu and starts the event
 * polling. After closing it frees all memory and ends.
 ********************************************************/
int main()
{
	/*
	 * Show the start screen
	 */
	show_start_screen();

	/**
	 * Init all
	 */
	init();

	/* 
	 * Create first the main deskbox
	 */
	dsk = (PDESKBOX *)CreateDeskBox(100, 0, 0, 159, 239, 
		MK_FAR_PTR(WindowTitle), MK_FAR_PTR(StartMenu), NULL_FP,
		bafClose | bafDotTitle); 

	/*
	 * This page up and down  buttons are used for switching the
	 * display pages while the gameplay
	 */
	InsertPageArrow( dsk, 101, (PVIEW *) dsk);

	/* 
	 * Now we will assign the two handlers we implemented earlier to our DeskBox.
	 * There are two functions that do this.  Use 'BankedAssign1()' if your handler
	 * has only one argument, and 'BankedAssign2()' if it has two or more.  A handler
	 * will never have zero arguments.  Note: two functions are needed because of the
	 * differences in the way parameters are passed in the FWSDK and in the Avigo
	 * internally. The 'Official $DK' uses just one: BankedAssign()
	 */
	BankedAssign1(dsk->draw,dsk_draw); 
	BankedAssign2(dsk->handleEvent,dsk_handleEvent);
	

	/* 
	 * Here's the 'magic' function that does most of the work of the program.
	 * ExecView() will draw, and redraw when needed, our deskbox and all our controls.
	 * It will continuously poll for pen and button input, then send messages to the
	 * controls and the DeskBox itself, and invoke their handlers.  It will exit when
	 * it processes a cmCancel or cmQuit command message. 
	 */
	ExecView((PGROUP_PTR) dsk);

	/*
	 * Finally, we'll 'destroy' the DeskBox to free up its resource memory. 
	 */
	Destroy((VOID_PTR) dsk);

	/*
	 * Hey, we're done! That wasn't so bad, was it? 
	 */

	/*
	 * Avigo apps return a code indicating the program to run next.  APPLICATION
	 * indicates the apps. menu 
	 */	
	return APPLICATION;

}

