/********************************************************
 * 
 * Title: Kralj
 *
 * Module: Drawing
 *
 * Type: Implementation
 *
 * Author: Jurica Jurjevic
 *
 * Timestamp: 2000/02/14 00:54:21
 *
 *
 * Game drawing on the screen are all performed in this
 * library.
 *
 ********************************************************/
#include <avsys.h>
#include <knotools.h>
#include "avicons.h"
#include "kralj.h"
#include "gfx.h"
#include "drawing.h"
#include "chess.h"


/********************************************************
 * Build up the start screen and show it
 ********************************************************/
void show_start_screen() 
{


}

/********************************************************
 * Moving a figure with drag and drop?
 ********************************************************/
void move_drag_and_drop(unsigned char pix_x, unsigned char pix_y)
{		

	int pixel_x = pix_x+1-game.chessboard.selected_field.offset.x;
	int pixel_y = pix_y+1-game.chessboard.selected_field.offset.y;

	SetToVirtualLCD(1);
	RestoreWindow(game.chessboard.left, game.chessboard.top, 	GetLCDBackBufAddr(), PUT );

	/* Check if the figure is in the range of the board */
	if( pixel_x < game.chessboard.left+1 ) pixel_x = game.chessboard.left+1;
	if( pixel_x > game.chessboard.left+18*7 ) pixel_x = game.chessboard.left+18*7;
	if( pixel_y < game.chessboard.top+1 ) pixel_y = game.chessboard.top+1;
	if( pixel_y > game.chessboard.top+18*7 ) pixel_y = game.chessboard.top+18*7;
	
	/* Now draw the field where the pointer is scrolling over */
	game.chessboard.destination_field = get_chessboard_field(pixel_x+8, pixel_y+8);
	draw_field(SELECTED, game.chessboard.destination_field.pos.x, game.chessboard.destination_field.pos.y );

	/* Draw the moving figure */
	draw_figure(game.chessboard.selected_field.figure.type, pixel_x, pixel_y);
	
	/* Last, save the position of the figure for later animation */
	game.chessboard.selected_field.figure.pos.x = pixel_x;
	game.chessboard.selected_field.figure.pos.y = pixel_y;	

	SetToRealLCD(1);

}



/********************************************************
 * Make the move visible - means draw and set it!
 * Global params game.chessboard.destination_field and
 * game.chessboard.selected_field used for positioning
 ********************************************************/
void make_move()
{

	int exit=FALSE;

	int current_pos_x = game.chessboard.selected_field.figure.pos.x;
	int current_pos_y = game.chessboard.selected_field.figure.pos.y;

	int destination_pos_x = game.chessboard.destination_field.figure.pos.x;
	int destination_pos_y = game.chessboard.destination_field.figure.pos.y;

	while(exit==FALSE)
	{
		/* Check for exit */
		if(destination_pos_x>current_pos_x-game.options.animation_speed
			&& destination_pos_x<current_pos_x+game.options.animation_speed
			&& destination_pos_y>current_pos_y-game.options.animation_speed
			&& destination_pos_y<current_pos_y+game.options.animation_speed
			) exit=TRUE;
		/* Draw the move*/
		if( current_pos_x < destination_pos_x ) 
		{
			current_pos_x=current_pos_x+game.options.animation_speed;
		} 
		if( current_pos_x > destination_pos_x ) 
		{
			current_pos_x=current_pos_x-game.options.animation_speed;
		}
		if( current_pos_y < destination_pos_y ) 
		{
			current_pos_y=current_pos_y+game.options.animation_speed;
		}
		if( current_pos_y > destination_pos_y ) 
		{
			current_pos_y=current_pos_y-game.options.animation_speed;
		}
		SetToVirtualLCD(1);
		RestoreWindow(game.chessboard.left, game.chessboard.top, 	GetLCDBackBufAddr(), PUT );
		/* Draw the moving figure */
		draw_figure(game.chessboard.selected_field.figure.type, current_pos_x, current_pos_y);
		SetToRealLCD(1);
		Delay_10ms();
	}

	/* 
	 * Deselect the squared fields
	 */
	game.chessboard.selected_field.selected=FALSE;
	game.chessboard.destination_field.selected=FALSE;
	
	SetToVirtualLCD(1);
	RestoreWindow(game.chessboard.left, game.chessboard.top, 	GetLCDBackBufAddr(), PUT );
	draw_field( NORMAL, game.chessboard.selected_field.pos.x, game.chessboard.selected_field.pos.y );
	draw_field( NORMAL, game.chessboard.destination_field.pos.x, game.chessboard.destination_field.pos.y );
	SetToRealLCD(1);
}


/********************************************************
 * Draw the whole playground
 ********************************************************/
void draw_playground() 
{	
	draw_player_infos();
	draw_chessboard();
}

/********************************************************
 * Draw the player names and thier times
 ********************************************************/
void draw_player_infos() 
{
	
	unsigned char nameposx=15;
	unsigned char timeposx=121;
	unsigned char posone=16;
	unsigned char postwo=185;
	char *nametop=game.chessboard.players.black.name;
	char *namebottom=game.chessboard.players.white.name;
	char timetop[9];
	char timebottom[9];

	int time;
	int temp;
	int temph;

	if( game.chessboard.orientation == WHITE_TOP ) 
	{
		nametop=game.chessboard.players.white.name;
		namebottom=game.chessboard.players.black.name;		
	}

	/* Converte the int time to the string one */
	
	/* First the hours of top*/
	time=game.chessboard.players.black.time;
	if( game.chessboard.orientation == WHITE_TOP ) time=game.chessboard.players.white.time;	
	temp=time/3600;
	timetop[0]='0'+temp/10;
	timetop[1]='0'+temp%10;
	timetop[2]=':';
	temph=(time-temp*3600);
	temp=temph/60;
	timetop[3]='0'+temp/10;
	timetop[4]='0'+temp%10;
	timetop[5]=':';
	temp=temph-temp*60;
	timetop[6]='0'+temp/10;
	timetop[7]='0'+temp%10;
	timetop[8]=0x0;	

	/* Second the hours of bottom */
	time=game.chessboard.players.white.time;
	if( game.chessboard.orientation == WHITE_TOP ) time=game.chessboard.players.black.time;
	temp=time/3600;
	timebottom[0]='0'+temp/10;
	timebottom[1]='0'+temp%10;
	timebottom[2]=':';
	temph=(time-temp*3600);
	temp=temph/60;
	timebottom[3]='0'+temp/10;
	timebottom[4]='0'+temp%10;
	timebottom[5]=':';
	temp=temph-temp*60;
	timebottom[6]='0'+temp/10;
	timebottom[7]='0'+temp%10;
	timebottom[8]=0x0;

	/* Write the player name and his time */
	SetFontType(PRPFONT7N);		
	WriteString( nameposx, posone, nametop, 0 );
	WriteString( timeposx, posone, timetop, 0 );	
	WriteString( nameposx, postwo, namebottom, 0 );
	WriteString( timeposx, postwo, timebottom, 0 );


	/* Draw whoes moving next */
	if( ( game.chessboard.players.nextplayer == WHITE_PLAYER_NEXT && game.chessboard.orientation == WHITE_TOP ) ||
		  ( game.chessboard.players.nextplayer == BLACK_PLAYER_NEXT && game.chessboard.orientation == WHITE_BOTTOM ) ) 
	{		
		DrawSystemIcon(5, posone-2, 291, OR);
		DrawSystemIcon(1, posone-2, 291, OR);
		FillRect(1, postwo-3, 12, postwo+8, DRAW_WHITE);		
		
	}
	if( ( game.chessboard.players.nextplayer == WHITE_PLAYER_NEXT && game.chessboard.orientation == WHITE_BOTTOM ) ||
		  ( game.chessboard.players.nextplayer == BLACK_PLAYER_NEXT && game.chessboard.orientation == WHITE_TOP ) ) 
	{
		DrawSystemIcon(5, postwo-3, 291, OR);
		DrawSystemIcon(1, postwo-3, 291, OR);
		FillRect(1, posone-2, 12, posone+8, DRAW_WHITE);		
	}


}

/********************************************************
 * Draw the game.chessboard. posx and posy means the position
 ********************************************************/
void draw_chessboard() 
{

	int v;
	int h;
	int posx=game.chessboard.left;
	int posy=game.chessboard.top;

	char number=game.chessboard.orientation==WHITE_BOTTOM?'8':'1';
	char alpha='A';


	/** Ok first draw the board coordinates */
	SetFontType(PRPFONT7N);
	for(v=0; v<8; v++) {		
		WriteChar( posx-7, v*18+posy+4, number, DRAW_BLACK );
		number=number+game.chessboard.orientation;
	}
	for(h=0; h<8; h++) {
		WriteChar( posx+7+h*18, 8*18+posy+2, alpha++, DRAW_BLACK );
	}

	/** Here we draw the game.chessboard itself */
	for(v=0; v<8; v++) 
	{
		for(h=0; h<8; h++) 
		{
			/** Draw the field */
			draw_field( NORMAL, h, v );
		}
	}
	DrawRect(posx-2, posy-2, posx+8*18+1, posy+8*18+1, DRAW_BLACK);
	
}

/********************************************************
 * Draw the field (square and figure) at position posx,
 * posy - The figure from game.chessboard[posy][posx] taken
 * posy is the line posx the row
 ********************************************************/
void draw_field(unsigned char mode, unsigned char posx, unsigned char posy) 
{	

	int ypos = posy;	

	if( game.chessboard.orientation == WHITE_TOP ) ypos = 7 - posy;

	draw_square( mode, posx, posy );	

	draw_figure( game.chessboard.board[posx][posy], game.chessboard.left+1+posx*18, game.chessboard.top+1+ypos*18 );
}


/********************************************************
 * Draw the square with mode
 ********************************************************/
void draw_square(unsigned char mode, unsigned char posx, unsigned char posy)
{	
	int counter;	

	if( game.chessboard.orientation == WHITE_TOP ) posy = 7 - posy;

	counter=posy*8+posx+posy%2+((game.chessboard.orientation+1)/2)+1; /* White or black square */
	FillRect(game.chessboard.left+posx*18, game.chessboard.top+posy*18, game.chessboard.left+posx*18+17, game.chessboard.top+posy*18+17, DRAW_WHITE);
	if(counter%2==0) {
		gfx_blit(game.chessboard.left+1+posx*18, game.chessboard.top+1+posy*18, 2, 16, SPRITE(0,40), GFX_BLIT_OR);		
		DrawRect(game.chessboard.left+posx*18, game.chessboard.top+posy*18, game.chessboard.left+posx*18+17, game.chessboard.top+posy*18+17, DRAW_GRAY);
	} else {
		gfx_blit(game.chessboard.left+1+posx*18, game.chessboard.top+1+posy*18, 2, 16, SPRITE(16,40), GFX_BLIT_OR);		
	}

	switch(mode)
	{
	case NORMAL:
		break;
	case SELECTED:
		DrawRect(game.chessboard.left+posx*18, game.chessboard.top+posy*18, game.chessboard.left+posx*18+17, game.chessboard.top+posy*18+17, DRAW_BLACK);
		break;
	}

}

/********************************************************
 * Draw the figures at posx and posy
 ********************************************************/
void draw_figure(unsigned char figure, unsigned char pixel_x, unsigned char pixel_y)
{	

	/* Check if the figure is in the range of the board */
	if( pixel_x < game.chessboard.left ) pixel_x = game.chessboard.left+1;
	if( pixel_x > game.chessboard.left+18*7 ) pixel_x = game.chessboard.left+18*7+1;
	if( pixel_y < game.chessboard.top ) pixel_y = game.chessboard.top+1;
	if( pixel_y > game.chessboard.top+18*7 ) pixel_y = game.chessboard.top+18*7+1;

	switch(figure) 
	{
	case NONE:
		break;
	/* Black figures first */
	case BLACK_ROOK:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_ROOK, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BLACK_ROOK, GFX_BLIT_OR);				
		break;
	case BLACK_KNIGHT:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_KNIGHT, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BLACK_KNIGHT, GFX_BLIT_OR);								
		break;
	case BLACK_BISHOP:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_BISHOP, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BLACK_BISHOP, GFX_BLIT_OR);				
		break;
	case BLACK_PAWN:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_PAWN, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BLACK_PAWN, GFX_BLIT_OR);								
		break;
	case BLACK_QUEEN:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_QUEEN, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BLACK_QUEEN, GFX_BLIT_OR);				
		break;
	case BLACK_KING:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_KING, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BLACK_KING, GFX_BLIT_OR);								
		break;
	/* White figures last */
	case WHITE_ROOK:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_ROOK, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_WHITE_ROOK, GFX_BLIT_OR);				
		break;
	case WHITE_KNIGHT:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_KNIGHT, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_WHITE_KNIGHT, GFX_BLIT_OR);								
		break;
	case WHITE_BISHOP:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_BISHOP, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_WHITE_BISHOP, GFX_BLIT_OR);				
		break;
	case WHITE_PAWN:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_PAWN, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_WHITE_PAWN, GFX_BLIT_OR);								
		break;
	case WHITE_QUEEN:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_QUEEN, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_WHITE_QUEEN, GFX_BLIT_OR);				
		break;
	case WHITE_KING:
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_BACKGROUND_KING, GFX_BLIT_CLEAR);
		gfx_blit(pixel_x, pixel_y, 2, 16, SPRITE_WHITE_KING, GFX_BLIT_OR);
		break;
	}			
}


void draw_sprite( unsigned char x, unsigned char y, unsigned char w, unsigned char h, unsigned char sx, unsigned char sy, unsigned char m )
{
	gfx_blit(x, y, w, h, SPRITE(sx,sy), m);								
}