#ifndef IO_ERROR_H
#define IO_ERROR_H

/******************************************************************************\
*  io_error.h
*
*  Header file that defines the error handling of the I/O API software
*
\******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

// define export options
#ifdef __BORLANDC__
#define DLLEXPORT __export _stdcall
#define VAREXPORT __import
// Borland pragma for assuring byte alignment
#pragma option -a1
#else
#define DLLEXPORT __declspec(dllexport) _stdcall
#define VAREXPORT
// MFC pragma's for assuring byte alignment
#pragma pack( push, alignment_before_tops_includes ) //store current alignment
#pragma pack(1)
#endif
 

// These functions provide the error reporting capability of the I/O API.
// The I/O API reports errors via a circular Error Buffer.  Entries in
// the Error Buffer consist of a character string that describes the
// error followed by an optional error id that gives additional information
// for some errors.


// prototye for error handling routines


// IO_ERROR places an error string and an error id in the error buffer.
void DLLEXPORT IO_ERROR(char *p_error_string, DWORD p_error_id);
// Suspend and resume error reporting.
void DLLEXPORT IO_ERROR_Suspend(void);
void DLLEXPORT IO_ERROR_Resume(void);
//
// IO_ERROR_GetError returns the error buffer data to the caller.  It also
// allows the user to reset the error buffer if desired.  This allows the
// user to read "fresh" buffers each time, and not get error buffer entries
// that were previously retrieved. Error messages are seperated by a NULL
// terminator.
//
// Input Parameters:
//   p_return_buffer_size - size of the buffer that will receive the character
//    string error messages.  The API will truncate the response if this
//    parameter is not large enough. Partial messages will not be returned.
//   p_return_buffer_ptr - ptr to the buffer that will receive the error strings.
//   p_reset_error_flag - if this flag is nonzero then the error buffer
//    will be reset. This allows the user to not receive errors messages
//    that have been previously retrieved.
//   p_actual_bytes_returned - the number of data bytes returned.
//
// Return Values:
//   This routine will return FALSE if the return data was truncated. I.E.
//   the return_buffer_size is smaller than the number of messages in the
//   error buffer.
//
BOOL DLLEXPORT IO_ERROR_GetErrors(WORD p_return_buffer_size,
                                  BYTE *p_return_buffer_ptr,
                                  WORD p_reset_errors_flag,
                                  WORD *p_actual_bytes_returned);

// definition of an Error Buffer Entry

typedef struct IO_ERROR_Def
{
char  error_string[150];
DWORD error_id;
} IO_ERROR_BufferType;


// defines the number of entries in the error buffer
#define IO_ERROR_NUM_ENTRIES 20

// define the Error Buffer
extern VAREXPORT IO_ERROR_BufferType IO_ERROR_Buffer[IO_ERROR_NUM_ENTRIES];


// define the current index into the error buffer.  This is the index into
// the error buffer array IO_ERROR_Buffer at which the next error will
// be stored.
extern VAREXPORT WORD IO_ERROR_BufferIndex;


// define the cumulative count of all errors that have been encountered.
extern VAREXPORT DWORD IO_ERROR_Count;


// restore previous alignment
#ifdef __BORLANDC__
#pragma option -a-.                                  // Borland restore
#else
#pragma pack( pop, alignment_before_tops_includes ) // MFC restore
#endif

#ifdef __cplusplus
}
#endif

#endif

//---------------------------------------------------------------------------
//  End of File: io_error.h
//---------------------------------------------------------------------------


