#include <stdio.h>
#include <ctype.h>


#define HEXDUMP(file,ptr,size)	\
{\
   int jjj;\
   int iii;\
   char *tp;\
   char *cp;\
   for (iii = 0, tp = (char *)(ptr), cp = (char *)(ptr); iii < (size); )\
   {\
      fprintf ((file), "%04X  ", iii + 0xFC00);\
      for (jjj = 0; jjj < 8; jjj++)\
      {\
	 if (cp < ((char *)(ptr)+(size)))\
	 {\
	    fprintf ((file), "%02.2X", *cp++ & 0xFF);\
	    if (cp < ((char *)(ptr)+(size)))\
	    {\
	       fprintf ((file), "%02.2X ", *cp++ & 0xFF);\
	    }\
	    else\
	    {\
	       fprintf ((file), "   ");\
	    }\
	 }\
	 else\
	 {\
	    fprintf ((file), "     ");\
	 }\
	 iii += 2;\
      }\
      fprintf ((file), "   ");\
      for (jjj = 0; jjj < 8; jjj++)\
      {\
	 if (tp < ((char *)(ptr)+(size)))\
	 {\
	    if (isprint(*tp))\
	       fprintf ((file), "%c", *tp);\
	    else\
	       fprintf ((file), ".");\
	    tp++;\
	    if (tp < ((char *)(ptr)+(size)))\
	    {\
	       if (isprint(*tp))\
		  fprintf ((file), "%c ", *tp);\
	       else\
		  fprintf ((file), ". ");\
	       tp++;\
	    }\
	    else\
	    {\
	       fprintf ((file), "  ");\
	    }\
	 }\
	 else\
	 {\
	    fprintf ((file), "   ");\
	 }\
      }\
      fprintf ((file), "\n");\
   }\
}

main (int argc, char **argv)
{
   FILE *fd;
   int i;
   int j;
   unsigned char buf[1024];
   
   if (argc != 2)
   {
      fprintf (stderr, "usage: dumprom file\n");
      exit (1);
   }

   if ((fd = fopen (argv[1], "rb")) == NULL)
   {
      perror ("Can't open file");
      exit (1);
   }

      for (i = 0; i < 1024; i++)
         buf[i] = fgetc (fd);
      HEXDUMP (stdout, buf, 1024);
}
