	IDT	'DDISK'
	TITL	'Dump disk to serial port'
*
* DDISK - Dumps the disk to the serial port
*
R0	EQU	0
R1	EQU	1
R2	EQU	2
R3	EQU	3
R4	EQU	4
R5	EQU	5
R6	EQU	6
R7	EQU	7
R8	EQU	8
R9	EQU	9
R10	EQU	10
R11	EQU	11
R12	EQU	12
R13	EQU	13
R14	EQU	14
R15	EQU	15
*
* Terminal CRU bits and codes
*
TRMCRU	EQU	>0		Terminal CRU
*
XMIT	EQU	8
DTR	EQU	9
RTS	EQU	10
WRQ	EQU	11
RRQ	EQU	12
NSF	EQU	13
*
KILL	EQU	>03		CTRL-C
XON	EQU	>11
XOFF	EQU	>13
*
* Disk commands and codes
*
DEVADR	EQU	>F800		Disk TILINE address
DEVUNT	EQU	>0400		Disk Unit
*
STRRCM	EQU	>0000		Store registers
READCM	EQU	>0200		Read
WRITCM	EQU	>0300		Write
REDUCM	EQU	>0400		Read unformatted
RESTCM	EQU	>0700		Restore
*
ERRMSK	EQU	>21FF
*
PNLCRU	EQU	>1FE0		Front panel CRU
	PAGE
*
* Task Entry
*
	DATA	WS,ENTRY,0
*
* Standalone Entry
*
SAENT	EQU	$
	LWPI	WS
ENTRY	EQU	$
	LIMI	0		Take over the system
	SBO	DTR
	SBO	RTS
	BLWP	@PRINT		Issue ready message
	DATA	READY,RDYLEN
	TB	RRQ
	JNE	$-2
	STCR	R1,8		Get reply
	SBZ	RRQ
*
	LI	R1,RESTCM	Restore disk
	MOV	R1,@DSKCMD
	LI	R1,DEVUNT
	MOV	R1,@DSKUNT
	LI	R1,6
	MOV	R1,@DSKLEN
	CLR	@DSKTRK
	CLR	@DSKSEC
	CLR	@DSKHED
	BLWP	@DISKH
	DATA	DSKPRM,0,OOPS
*
	LI	R1,STRRCM	Store registers
	MOV	R1,@DSKCMD
	BLWP	@DISKH
	DATA	DSKPRM,DSKREG,OOPS
*
	LI	R1,REDUCM	Read unformatted
	MOV	R1,@DSKCMD
	BLWP	@DISKH
	DATA	DSKPRM,DSKUBF,OOPS
*
	CLR	R2		Calc bytes/sector
	MOV	@DSKREG,R3	Get words/track
	MOV	@DSKREG+2,R4	Get sectors/track
	SRL	R4,8
	DIV	R4,R2		Words/track / Sectors/track = Words/sector
	MOV	@DSKREG+2,R4	Get overhead/sector (words)
	ANDI	R4,>00FF
	S	R4,R2		Minus overhead
	SLA	R2,1		Make bytes/sector
	MOV	R2,@DSKLEN
	MOV	R2,@PRTLEN
	MOV	@DSKREG+4,R4	Get tracks (cylinders)
	ANDI	R4,>7FF
	CLR	R7		Track counter
NXTTRK	EQU	$
	MOV	R7,@DSKTRK
	MOV	@DSKREG+4,R5	Get Heads
	SRL	R5,11
	CLR	R6		Head counter
NXTHED	EQU	$
	LI	R1,READCM	Read track
	A	R6,R1		Add head
	MOV	R1,@DSKCMD
	MOV	@DSKREG+2,R3	Get Sectors/track
	SRL	R3,8
	CLR	R1		Sector counter
NXTSEC	EQU	$
	MOV	@DSKUBF+2,R10	Get record/sector
	ANDI	R10,>FF00
	SOC	R1,R10	
	MOV	R10,@DSKSEC	Save sector
	MOV	R6,R10		Display HTTT TTTT TTSS SSSS
	SLA	R10,9		 only correct for DS10
	A	@DSKTRK,R10	 but, heck, the lights be a flashin
	SLA	R10,6
	A	R1,R10
	LI	R12,PNLCRU	  on front panel...
	LDCR	R10,8
	SWPB	R10
	LDCR	R10,8
	LI	R12,TRMCRU
	BLWP	@DISKH		Read a sector
	DATA	DSKPRM,DSKBUF,OOPS
	BLWP	@PRINT		Send sector out
	DATA	DSKBUF
PRTLEN	DATA	$-$
	INC	R1		Next sector
	DEC	R3		Last sector on this track?
	JGT	NXTSEC		No, read next sector
	TB	RRQ		Wait for go ahead.
	JNE	$-2
	STCR	R10,8		Get reply
	SBZ	RRQ
	INC	R6		Next head
	DEC	R5		Last head?
	JGT	NXTHED		No, read next head
	INC	R7		Yes, next track
	DEC	R4		Last track?
	JGT	NXTTRK		No, read next track
IDLINS	IDLE			Yes, we're done.
*
OOPS	EQU	$
	LI	R0,>DEAD
	LI	R1,>BAD0
	MOV	@IDLINS,*R1
	B	*R1
*
WS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
*
READY	TEXT	'Enter any key when ready:'
	BYTE	>0D,>0A
RDYLEN	EQU	$-READY
	EVEN
*
DSKPRM	EQU	$
DSKCMD	DATA	$-$		Command
DSKHED	DATA	$-$		Head
DSKSEC	DATA	$-$		Sector
DSKTRK	DATA	$-$		Track
DSKLEN	DATA	$-$		Length
DSKUNT	DATA	$-$		Unit
DSKREG	BSS	6		Disk registers
DSKUBF	BSS	6		Disk unformatted read
	PAGE
*
* Print a message
*
PRINT	DATA	PRWS,PRENT
PRENT	EQU	$
	MOV	*R14+,R2	Get buffer address
	MOV	*R14+,R1	Get message length
	SBO	DTR
	SBO	RTS
PRI010	LDCR	*R2+,8		Put it out
	TB	WRQ
	JNE	$-2
	SBZ	WRQ
	TB	RRQ		Any thing coming back?
	JEQ	PRI030		Yes, go check it.
PRI020	EQU	$
	DEC	R1
	JGT	PRI010
	CLR	@0(R13)		Done, exit 0.
	RTWP
*
PRI030	EQU	$
	STCR	R5,8		Get it.
	SBZ	RRQ
	SRL	R5,8
	CI	R5,XOFF		If XOFF then
	JEQ	PRI040		   go wait for XON
	CI	R5,KILL		If not KILL (CTRL-C) then
	JNE	PRI020		   Ignore.
	SETO	@0(R13)		else exit -1.
	RTWP
PRI040	EQU	$
	TB	RRQ		Wait for XON.
	JNE	PRI040
	STCR	R5,8
	SBZ	RRQ
	SRL	R5,8
	CI	R5,XON
	JEQ	PRI020
	JMP	PRI040
*
PRWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,TRMCRU,0,0,0
	PAGE
*
* Disk Handler
*
DISKH	DATA	DISKWS,DISKEP
DISKWS	DATA	0,0,0,0,0,0,0,0
	DATA	0,0,0,0,DEVADR,0,0,0
DISKEP	EQU	$
	MOV	R12,R7
	AI	R7,14
	MOV	R14,R10		Ignore error now
	BL	@BZYCHK
	MOV	*R14+,R10	Get parm addr
	MOV	*R10+,R0	Get disk command
	MOV	*R10+,R1	Get head
	SOC	R1,R0
	MOV	*R10+,R1	Get Sector
	MOV	*R10+,R2	Get Track
	MOV	*R10+,R3	Get Length
	MOV	*R14+,R4	Get buffer addr
	MOV	*R10+,R5	Get Unit
	MOV	*R14+,R10	Get error vector
	BL	@ISSUE
	RTWP
*
ISSUE	MOV	R12,R7		Issue TILINE command
	CLR	*R7+
	MOV	R0,*R7+
	MOV	R1,*R7+
	MOV	R2,*R7+
	MOV	R3,*R7+
	MOV	R4,*R7+
	MOV	R5,*R7+
	CLR	*R7		Start transfer
BZYCHK	MOV	*R7,R8		Get status
	JLT	ISSU020		Done?
	JMP	BZYCHK		No, wait.
ISSU020 ANDI	R8,ERRMSK	Yes, Errors?
	JEQ	ISSU030		No
	MOV	R10,R14		Yes, set error vector.
ISSU030	RT

*
DSKBUF	BSS	288
	END	SAENT
