#include <stdio.h>
#include <string.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif


main (int argc, char **argv)
{
   FILE *fd;
   char *bp;
   int done;
   int nxtrec;
   int i;
   short int cksum;
   char buffer[82];

   if (argc != 2)
   {
      printf ("usage: chksum filename\n");
      exit (1);
   }

   if ((fd = fopen (argv[1], "r")) == NULL)
   {
      perror ("Can't open input");
      exit (1);
   }

   done = FALSE;
   while (!done)
   {
      if (fgets (buffer, 82, fd) == NULL)
      {
         perror ("Can't read");
	 fclose (fd);
	 exit (1);
      }
      printf ("buffer = %s", buffer);
      cksum = 0;
      bp = buffer;
      nxtrec = FALSE;
      while (!nxtrec)
      {
	 printf ("*bp = %c\n", *bp);
         switch (*bp)
	 {
	 case '0':
	    for (i = 0; i < 13; i++)
	    {
	       cksum += *bp++;
	    }
	    break;
	 case '1':
	 case '2':
	 case '9':
	 case 'A':
	 case 'B':
	 case 'C':
	    for (i = 0; i < 5; i++)
	    {
	       cksum += *bp++;
	    }
	    break;
	 case '3':
	 case '4':
	 case '5':
	 case '6':
	    for (i = 0; i < 11; i++)
	    {
	       cksum += *bp++;
	    }
	    break;
	 case '7':
	    cksum += *bp++;
	    *(bp+4) = '\0';
	    cksum = -cksum;
	    printf ("cksum = %04X, rec = %s\n", cksum & 0xFFFF, bp);
	    nxtrec = TRUE;
	    break;
	 case '8':
	    cksum += *bp++;
	    *(bp+4) = '\0';
	    printf ("cksum = %04X, rec = %s\n", cksum, bp);
	    nxtrec = TRUE;
	    break;
	 case 'F':
	    nxtrec = TRUE;
	    break;
	 case ':':
	    done = TRUE;
	    nxtrec = TRUE;
	    break;
	 }
      }
   }
}
