/***********************************************************************
* Screen control routines, Uses ANSI control sequences.
*
* Changes:
*   05/29/03   DGP   Original.
*
***********************************************************************/
 
#include <stdio.h>

extern int enablepanel;

#if defined(USS) || defined(OS390)
#define ESCAPE  0x27
#else
#define ESCAPE  0x1B
#endif
 
/***********************************************************************
* clearscreen - clear the screen
***********************************************************************/
 
void
clearscreen (void)
{
#ifdef ANSICRT
   if (enablepanel)
      printf ("%c[2J", ESCAPE);
#else
   printf ("\n\n\n\n\n\n\n\n\n\n\n\n");
   printf ("\n\n\n\n\n\n\n\n\n\n\n\n");
#endif
}
 
/***********************************************************************
* clearline - clear the line
***********************************************************************/
 
void
clearline (void)
{
#ifdef ANSICRT
   if (enablepanel)
      printf ("%c[2K", ESCAPE);
#endif
}
 
/***********************************************************************
* screen position - position on the screen
***********************************************************************/
 
void
screenposition (int row,
		int col)
{
#ifdef ANSICRT
   if (enablepanel)
      printf ("%c[%d;%dH", ESCAPE, row, col);
   else
      printf ("\n");
#else
   printf ("\n");
#endif
}
