/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static char sccsid[] = "@(#)pstoc.c 9.8 88/01/19 Copyright 1987 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc. 
 */

/*-
	Receiving typed messages from postscript

	pstoc.c, Sun Jun 15 13:41:00 1986

 */

#ifdef REF
#include <sys/types.h>
#include <ref/config.h>
#endif
#include <errno.h>
#include <varargs.h>
#include "encoding.h"
#include "pstoctable.h"
#include "psio.h"



/* VARARGS */
pscanf(f, fmt, va_alist)
    register struct psiobuf *f;
    register char *fmt;
    va_dcl
{
    va_list     args;
    unsigned char dtype;
    va_start(args);
    if (f->outputside && psio_needsflush(f->outputside))
	psio_flush(f->outputside);
    while (*fmt) {
	register    c;
	register    temp;
	register    len;
	c = *fmt++;
	if (c == '*') {
	    len = va_arg(args, int);
	    c = *fmt++;
	}
	else
	    len = 99999;
	if ((dtype = ttype[c]) == 0)
	    continue;
	c = psio_getc(f);
	if (dtype == enc_string + 1) {
	    *va_arg(args, char *) = c;
	    continue;
	}
#define case4(tag) case tag: case tag+1: case tag+2: case tag+3
#define case16(tag) case4(tag):case4(tag+4):case4(tag+8):case4(tag+12)
#define case32(tag) case16(tag):case16(tag+16)
	switch (c) {
	    /*
	     * An encoded integer: the bottom two bits of the opcode = (the
	     * number of bytes in the number)-1;  the next two bits = the
	     * number of bytes that are to follow the binary point
	     */
    case16(enc_int):
	    {
		register    n;
		temp = c;
		c = psio_getc(f);
		n = (char) c;
		while (temp & 3) {
		    --temp;
		    n = (n << 8) | psio_getc(f);
		}
		switch (dtype) {
		case enc_int:
		    *va_arg(args, int *) = n >> ((temp >> 2) & 3) * 8;
		    break;
		case enc_int + 1:
		    c = (2 - ((temp >> 2) & 3)) * 8;
		    if (c > 0) {
			*va_arg(args, int *) = n << c;
		    }
		    else if (c < 0) {
			*va_arg(args, int *) = n >> -c;
		    }
		    else {
			*va_arg(args, int *) = n;
		    }
		    break;
		case enc_IEEEfloat:
		    *va_arg(args, float *) = ((double) n) / (1 << (((temp >> 2) & 3) * 8));
		    break;
		case enc_IEEEdouble:
		    *va_arg(args, double *) = ((double) n) / (1 << (((temp >> 2) & 3) * 8));
		    break;
		default:
		    return -1;
		}
		break;
	case16(enc_short_string):
		temp = c & 017;
		goto read_encoded_string;
	case enc_IEEEfloat:
		{
		    union {
			float       f;
			long        n;
		    }           u;
		    u.n = psio_getc(f);
		    u.n = (u.n << 8) | psio_getc(f);
		    u.n = (u.n << 8) | psio_getc(f);
		    u.n = (u.n << 8) | psio_getc(f);
#if defined(vax)
		    /* This call is dangerous, the first instance of
		     * u is treated as a long and the second instance as
		     * float. The conversion is returned in the second u.
		     * If the following routine is modified, on must be
		     * careful to isolate the values.
		     */
		    ieee_vax_float(&u.n, &u.f);
#endif
		    switch (dtype) {
		    case enc_int:
			*va_arg(args, int *) = u.f;
			break;
		    case enc_IEEEfloat:
			*va_arg(args, float *) = u.f;
			break;
		    case enc_IEEEdouble:
			*va_arg(args, double *) = u.f;
			break;
		    default:
			return -1;
		    }
		}
		break;
	case4(enc_string):
		temp = 0;
		{
		    register    i = c & 3;
		    do {
			temp = (temp << 8) | psio_getc(f);
		    } while (--i >= 0);
		}
	read_encoded_string:
		if (dtype != enc_string)
		    return -1;
		{
		    register char *p = va_arg(args, char *);
		    while (--temp >= 0 && len > 0)
			*p++ = psio_getc(f), len--;
		    if (len == 0) {
			while (temp-- >= 0)
			    (void) psio_getc(f);
		    }
		    else
			*p++ = 0;
		}
		break;
	    }
	case enc_syscommon:{
		register char *p = va_arg(args, char *);
		while (c != '\n' && c != ' ' && len-- > 0) {
		    *p++ = c;
		    c = psio_getc(f);
		}
		if (len == 0) {
		    while (c != '\n' && c != ' ')	/* flush remainder */
			c = psio_getc(f);
		}
		else
		    *p = '\0';
		break;
	    }
	default:
	    return -1;
	}
    }
    va_end(args);
}

#define INITBUF(p) if ((p)->bufsiz == 0) initbuf(p)

static
initbuf(p)
    register struct psiobuf *p;
{
    if (p->bufsiz == 0) {
	p->bufsiz = BUFSIZ;
	p->base = (unsigned char *) malloc(p->bufsiz);
	p->flag |= _IOMYBUF;
    }
}

_psfilbuf(p)
    register struct psiobuf *p;
{
    register    avail;
    extern int errno;
    INITBUF(p);
    while (1) {
	avail = p->bufsiz - p->protected;
	if (avail <= 0)
	    return -1;
	p->ptr = p->base + p->protected;
	p->cnt = read(p->file, p->ptr, avail);
	if (p->cnt <= 0) {
	    if (p->cnt == 0)
		errno = 0;
	    if (errno == EINTR) {
		continue;
	    } else if (errno == EWOULDBLOCK) {
		sleep(1);	/* Resort to polling */
		continue;
	    } else {
		p->flag |= p->cnt == 0 ? _IOEOF : _IOERR;
		return -1;
	    }
	}
	return psio_getc(p);
    }
}

_psreset(p)
    register struct psiobuf *p;
{
    if (p->protected) {
	if (p->cnt > 0) {
	    bcopy(p->ptr, p->base + p->protected, p->cnt);
	    p->cnt += p->protected;
	}
	else
	    p->cnt = p->protected;
	p->ptr = p->base;
	p->protected = 0; 
    }
}

/* are we looking at a particular tag? */
ps_lookingat(p, tag)
    register struct psiobuf *p;
{
    INITBUF(p);
    if (p->outputside && psio_needsflush(p->outputside))
	psio_flush(p->outputside);
    if (p->protected)
	_psreset(p);
    while (p->cnt < 3) {
	p->protected = p->cnt;
	if (_psfilbuf(p) < 0)
	    return 0;
	p->cnt += 1 + p->protected;
	p->ptr = p->base;
	p->protected = 0;
    }
    if (p->ptr[0] == enc_tag &&
	((p->ptr[1] << 8) + p->ptr[2]) == (short) tag) {
	p->ptr += 3;
	p->cnt -= 3;
	return 1;
    }
    return 0;
}

/* are we looking at a particular tag? */
ps_awaittag(p)
    register struct psiobuf *p;
{
    INITBUF(p);
    if (p->outputside && psio_needsflush(p->outputside))
	psio_flush(p->outputside);
    if (p->protected)
	_psreset(p);
    while (p->cnt < 3) {
	p->protected = p->cnt;
	if (_psfilbuf(p) < 0)
	    return -1;
	p->cnt += 1 + p->protected;
	p->ptr = p->base;
	p->protected = 0;
    }
    if (p->ptr[0] != enc_tag)
	return -1;
    p->ptr += 3;
    p->cnt -= 3;
    return (p->ptr[-2] << 8) + p->ptr[-1];
}


/* are we looking at a tag? */
ps_lookingattag(p)
    register struct psiobuf *p;
{
    INITBUF(p);
    if (p->outputside && psio_needsflush(p->outputside))
	psio_flush(p->outputside);
    if (p->protected)
	_psreset(p);
    while (p->cnt < 1) {
	p->protected = p->cnt;
	if (_psfilbuf(p) < 0)
	    return 0;
	p->cnt += 1 + p->protected;
	p->ptr = p->base;
	p->protected = 0;
    }
    if (p->ptr[0] == enc_tag)
	return 1;
    return 0;
}

/* wait for some particular tag */
ps_waitfor(p, tag)
    register struct psiobuf *p;
{
    register unsigned char *exam,
               *limit;
    INITBUF(p);
    if (p->outputside)
	psio_flush(p->outputside);
    if (p->protected)
	_psreset(p);
    exam = (unsigned char *) p->ptr;
    limit = exam + p->cnt;
    while (1) {
	register char c;
	while (limit - exam < 3) {
	    register delta = p->ptr - p->base;
	    p->protected = p->cnt;
	    if (delta > 0 && p->protected != 0) {
		bcopy(p->ptr, p->base, p->protected);
		exam -= delta;
	    }
	    else
		exam = p->base;
	    if (_psfilbuf(p) < 0)
		return -1;
	    p->cnt += 1 + p->protected;
	    p->ptr = p->base;
	    p->protected = 0;
	    limit = (unsigned char *) p->base + p->cnt;
	}
	if (exam[0] == enc_tag &&
	    (short)((exam[1] << 8) + exam[2]) == (short) tag) {
	    *(unsigned char **) &p->ptr = exam + 3;
	    p->cnt = limit - exam - 3;
	    p->protected = exam - (unsigned char *) p->base;
	    return 0;
	}
	c = oplength[*exam];
	if (c <= 0)
	    switch (c) {
	    case -2:
		exam += exam[1] + 2;
		break;
	    case -3:
		exam += (exam[1] << 8) + exam[2] + 2;
	    default:
		exam++;
	    }
	else
	    exam += c;
    }
}

#if defined(vax)

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	mant: 23;
	unsigned int	exp     : 8;
	unsigned int	sign    : 1;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mant1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mant2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} sgl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x0, 0xff, 0x0 }},		/* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0 }}		/* Min IEEE */
};

/* Thsi routine is typically called with lp, and rfp pointing to
 * the same location (as a union). You can not modify part of rfp
 * and expect lp not to be changed.
 */
ieee_vax_float(lp, rfp)
	register long *lp;
	register float *rfp;
{
	struct ieee_single is;
	struct vax_single *vsp;
	struct sgl_limits *lim;
	int i;


	is = *((struct ieee_single *)lp);
	vsp = (struct vax_single *)rfp;
	for (i = 0, lim = sgl_limits;
		i < sizeof(sgl_limits)/sizeof(struct sgl_limits);
		i++, lim++) {
		if ((is.exp == lim->ieee.exp) &&
			(is.mant == lim->ieee.mant)) {
			*vsp = lim->s;
			goto returnit;
		}
	}
	vsp->exp = is.exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
	vsp->mant2 = is.mant;
	vsp->mant1 = (is.mant >> 16);
returnit:
	vsp->sign = is.sign;
}

#endif
