#ifndef lint
static char sccsid[] = "@(#)psiofprntf.c 9.6 88/02/10 Copyright 1985 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

/*-
	fprintf equivalent for psio

	psiofprntf.c, Tue Jun 30 11:31:19 1987

		James Gosling,
		Sun Microsystems
 */

#ifdef REF
#include <sys/types.h>
#include <ref/config.h>
#endif
#include "psio.h"
#include <varargs.h>

/* if the definition of a fract changes include/fract.h this should likely
 * change to match.
 */
typedef int fract;

psio_doprnt(f, fmt, args)
    register PSFILE *f;
    register char *fmt;
    va_list     args;
{
    register    c;

    while (c = *fmt++)
	if (c != '%') {
	    psio_putc(c, f);
	    /*-	    if (c == '\n' && (f->flags & PSLINEBUF))
			    psio_flush(f); */
	}
	else {
	    register    len = -1;
    parse_another:
	    switch (c = *fmt++) {
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
	    case '.':
	    case '#':
		goto parse_another;
	    case '*':
		len = va_arg(args, int);
		goto parse_another;
	    case 's':{
		    register char *s = va_arg(args, char *);
		    if (len >= 0)
			while (--len >= 0)
			    psio_putc(*s++, f);
		    else
			while (*s)
			    psio_putc(*s++, f);
		    break;
		}
	    case 'X':
	    case 'x':{
		    static char hex[] = "0123456789ABCDEF";
		    register unsigned n = va_arg(args, unsigned long);
		    char        h_digit_buf[8];
		    register char *hp = &h_digit_buf[sizeof h_digit_buf];
		    do {
			*--hp = hex[n & 0xF];
			n >>= 4;
		    } while (n != 0);
		    while (hp < &h_digit_buf[sizeof h_digit_buf])
			psio_putc(*hp++, f);
		}
		break;
	    case 'O':
	    case 'o':{
		    register unsigned n = va_arg(args, unsigned long);
		    char        o_digit_buf[11];
		    register char *op = &o_digit_buf[sizeof o_digit_buf];
		    do {
			*--op = (n & 07) + '0';
			n >>= 3;
		    } while (n != 0);
		    while (op < &o_digit_buf[sizeof o_digit_buf])
			psio_putc(*op++, f);
		}
		break;
	    case 'c':
		psio_putc(va_arg(args, int), f);
		break;
	    case 'u':
	    case 'U':		/* WRONG! */
	    case 'D':
	    case 'd':{
		    register    n = va_arg(args, int);
		    char        digit_buf[8];
		    register char *op = &digit_buf[sizeof digit_buf];
		    if (n < 0) {
			n = -n;
			psio_putc('-', f);
		    }
		    do {
			*--op = (n % 10) + '0';
			n /= 10;
		    } while (n != 0);
		    while (op < &digit_buf[sizeof digit_buf])
			psio_putc(*op++, f);
		}
		break;
	    case 'f':
	    case 'g':
		{
		    char        cvtbuf[100];
		    extern      gconvert();
		    register char *fp;
		    double	fval;

		    fval = va_arg(args, double);
		    gconvert(fval, 6, 0, cvtbuf);
		    for (fp = cvtbuf; *fp;)
			psio_putc(*fp++, f);
		}
		break;
	    case 'p':		/* fixed(31,16) */
		{
		    char        cvtbuf[100];
		    extern      frconvert();
		    register char *fp;
		    frconvert(va_arg(args, fract), 3, 0, cvtbuf);
		    for (fp = cvtbuf; *fp;)
			psio_putc(*fp++, f);
		}
		break;
	    default:
		psio_putc(c, f);
		break;
	    }
	}
}

#if defined(mc68000) || defined(sparc) || defined(i386)
/* IEEE standard codes: 	0x7FF00000 00000000	+infinity
 *				0xFFF00000 00000000	-infinity
 *				0x7FFxxxxx xxxxxxxx	-NaN
 */
#define POSINF 0x7FF00000
#define NEGINF 0xFFF00000

/* in: 	n		double
 * out:	<return value>	0	numeric
 *			1	infinity
 *			2	-infinity
 *			3	NaN
 */
int rangetest(n)		/* NON-PORTABLE tests for infinity and NaN */
double n;
{
    register long *lo = (long *)(&n);

#if defined(i386)
    /* most significant word is the second long for the i386 */
    lo++;
#endif
    if ( (*lo & POSINF) == POSINF) {
	if ( (*lo & NEGINF) == NEGINF)
	    return 2;		/* -infinity */
	else if (*lo & ~POSINF)
	    return 3;		/* NaN */
	else
	    return 1;		/* +infinity */
    } else {
	return 0;		/* numeric */
    }
}
#endif	/* mc68000 || sparc || i386 */

#if defined(vax)

#include <signal.h>
#include <setjmp.h>

jmp_buf	env;

/*
 * fake out IEEE reports for the VAX which is not so careful about
 * the values of numbers. Others may wish this routine to act
 * differently (ie interpret or report the exceptions differently).
 */
float_exception(sig, code, scp)
	int	sig, code;
	struct sigcontext	*scp;
{
	switch (code) {
		case FPE_FLTOVF_TRAP:
		case FPE_FLTOVF_FAULT:
			longjmp(env, 1);	/* +infinity */
			break;          	/* keep lint happy */
		case FPE_FLTUND_TRAP:
		case FPE_FLTUND_FAULT:
			longjmp(env, 2);	/* -infinity */
			break;
		default:
			longjmp(env, 3);	/* NaN */
	}
}
#endif	/* vax */

static
gconvert(n, ndigit, trailingdot, buffer)
    double      n;
    char       *buffer;
{
    register    decexp = 0;
    register char *bp = buffer;
    char        decbuf[20];
    register char *dp = decbuf;
#if defined(vax)
    char *hold_bp;
    int (*hold_func)();
    int val;
#endif

    if (n < 0) {
	*bp++ = '-';
	n = -n;
    }
#if defined(mc68000) || defined(sparc) || defined(i386)
    switch ( rangetest(n) )
#endif
#if defined(vax)
    hold_bp = bp;			/* hold in case we get an exception */
    signal(SIGFPE, float_exception);
    if (val = setjmp(env))		/* returns 0 first time */
    {
	bp = hold_bp;			/* reset the bp pointer if exception */
	signal(SIGFPE, hold_func);
    }
    switch ( val )			
#endif
    {
    case 1:		/* n == infinity */
	*bp++ = 'i';
	*bp++ = 'n';
	*bp++ = 'f';
	*bp++ = '\0';
	return;
	break;		/* should keep lint happy */
    case 2:   		/* n == -infinity */
	*bp++ = '-';
	*bp++ = 'i';
	*bp++ = 'n';
	*bp++ = 'f';
	*bp++ = '\0';
	return;
	break;
    case 3:		/* n == NaN */
	*bp++ = 'N';
	*bp++ = 'a';
	*bp++ = 'N';
	*bp++ = '\0';
	return;
	break;
    default:
	break;
    } /* end switch */
    if (n) {
	while (n >= 10) {
	    n = n / 10;
	    decexp++;
	}
	while (n < 1) {
	    n = n * 10;
	    decexp--;
	}
    }
    do {
	register    digit = n;
	*dp++ = digit + '0';
	n = (n - digit) * 10;
    } while (n && --ndigit >= 0);
    if (dp[-1] >= '5' && ndigit < 0) {
	dp--;
	while (1) {
	    if (dp <= decbuf) {
		*dp++ = '1';
		decexp++;
		break;
	    }
	    if (dp[-1] != '9') {
		dp[-1]++;
		break;
	    }
	    dp--;
	}
    }
    while (dp > decbuf && dp[-1] == '0')
	dp--;
    if (dp == decbuf) {
	*dp++ = '0';
	decexp = 0;
    }
    *dp = 0;
    dp = decbuf;
    if (decexp < -3 || decexp > 10) {
	*bp++ = *dp++;
	if (*dp) {
	    *bp++ = '.';
	    while (*dp)
		*bp++ = *dp++;
	}
	*bp++ = 'e';
	if (decexp < 0) {
	    decexp = -decexp;
	    *bp++ = '-';
	}
	if (decexp > 100) {
	    *bp++ = decexp / 100 + '0';
	    decexp %= 100;
	}
	if (decexp > 10) {
	    *bp++ = decexp / 10 + '0';
	    decexp %= 10;
	}
	*bp++ = decexp + '0';
    }
    else if (decexp < 0) {
	*bp++ = '0';
	*bp++ = '.';
	while (++decexp < 0)
	    *bp++ = '0';
	while (*dp)
	    *bp++ = *dp++;
    }
    else {
	while (decexp >= 0 && *dp) {
	    *bp++ = *dp++;
	    decexp--;
	}
	while (decexp >= 0) {
	    *bp++ = '0';
	    decexp--;
	}
	if (*dp) {
	    *bp++ = '.';
	    do
		*bp++ = *dp++;
	    while (*dp);
	}
    }
    *bp++ = 0;
#if defined(vax)
    signal(SIGFPE, hold_func);
#endif
}

static char *
decconvert(bp, num)
    register char *bp;
    register    num;
{
    if (num >= 10)
	bp = decconvert(bp, num / 10);
    *bp++ = num % 10 + '0';
    return bp;
}

static
frconvert(n, ndigit, trailingdot, buffer)
    fract       n;
    char       *buffer;
{
    register    decexp;
    register char *bp = buffer, *dp;
    char        decbuf[20];
    if (n < 0) {
	*bp++ = '-';
	n = -n;
    }
    dp = decconvert(decbuf, n >> 16);
    decexp = dp - decbuf - 1;
    do {
	register    digit;
	n = (n & 0xFFFF) * 10;
	if (n == 0)
	    break;
	*dp++ = (n >> 16) + '0';
    } while (--ndigit >= 0);
    if (dp[-1] >= '5' && ndigit < 0) {
	dp--;
	while (1) {
	    if (dp <= decbuf) {
		*dp++ = '1';
		decexp++;
		break;
	    }
	    if (dp[-1] != '9') {
		dp[-1]++;
		break;
	    }
	    dp--;
	}
    }
    while (dp > decbuf && dp[-1] == '0')
	dp--;
    if (dp == decbuf) {
	*dp++ = '0';
	decexp = 0;
    }
    *dp = 0;
    dp = decbuf;
    if (decexp < 0) {
	*bp++ = '0';
	*bp++ = '.';
	while (++decexp < 0)
	    *bp++ = '0';
	while (*dp)
	    *bp++ = *dp++;
    }
    else {
	while (decexp >= 0 && *dp) {
	    *bp++ = *dp++;
	    decexp--;
	}
	while (decexp >= 0) {
	    *bp++ = '0';
	    decexp--;
	}
	if (*dp) {
	    *bp++ = '.';
	    do
		*bp++ = *dp++;
	    while (*dp);
	}
    }
    *bp++ = 0;
}

psio_fprintf(f, fmt, va_alist)
    PSFILE     *f;
    char       *fmt;
    va_dcl
{
    psio_doprnt(f, fmt, &va_alist);
}

psio_printf(fmt, va_alist)
    char       *fmt;
    va_dcl
{
    if (psio_stdout == 0)
	psio_stdout = psio_fdopen(1, "w");
    psio_doprnt(psio_stdout, fmt, &va_alist);
}
