/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static char   sccsid[] = "@(#) set_selection.c 9.2 88/01/18";
#endif

/*
 * Copyright (c) 1987 by Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <sys/types.h>
#include <suntool/selection_svc.h>
#include <suntool/selection_attributes.h>

main(argc, argv)
    int                   argc;
    char                **argv;
{
    Seln_client           client;
    Seln_holder           holder;
    Seln_rank             rank = SELN_PRIMARY;
    char                  context = 0;
    char		 *file_name = 0;

    while (--argc) {
	argv++;
	if (**argv == '/') {
	    file_name = *argv;
	} else {
	    switch (**argv) {
	      case '1':
		rank = SELN_PRIMARY;
		break;
	      /* Service does not support setting secondary selection to file.
	      case '2':
		rank = SELN_SECONDARY;
		break;
	       */
	      case '3':
		rank = SELN_SHELF;
		break;
	      case 'D':
		seln_use_test_service();
		break;
	      case 't':
	      case 'T':
		seln_use_timeout(atoi(++argv));
		break;
	      case 'h':
	      case 'H':
	      default:
		goto Usage;
	    }
	}
    }
    if (file_name && (*file_name == '/')) {
	(void) seln_hold_file(rank, file_name);
    } else {
Usage:
	quit("Usage: set_selection [D] [t seconds] [1 | 3] absolute_path_to_file\n");
    }
    exit(0); 
}

quit(str)
    char                 *str;
{
    fprintf(stderr, str);
    exit(1);
}

