/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

/*
 * 	ptyx.h 1.3 88/01/18
 *
 *	Copyright (c) 1987 by Sun Microsystems, Inc.
 *	Steve Isaac 12/18/87
 *
 */

/* Copyright	Massachusetts Institute of Technology	1984, 1985 */

/* ptyx.h */

#define	FALSE		0
#define	TRUE		1

typedef char **ScrnBuf;

/*
 * ANSI emulation.
 */
#define INQ	0x05
#define	FF	0x0C		/* C0, C1 control names */
#define	LS1	0x0E
#define	LS0	0x0F
#define	CAN	0x18
#define	SUB	0x1A
#define	ESC	0x1B
#define US	0x1F
#define	DEL	0x7F
#define HTS     ('H'+0x40')
#define	SS2	0x8E
#define	SS3	0x8F
#define	DCS	0x90
#define	OLDID	0x9A		/* ESC Z */
#define	CSI	0x9B
#define	ST	0x9C
#define	OSC	0x9D
#define	PM	0x9E
#define	APC	0x9F
#define	RDEL	0xFF

#define	NPARAM	10		/* Max. parameters */

typedef struct {
    unsigned char a_type;
    unsigned char a_pintro;
    unsigned char a_final;
    unsigned char a_inters;
    char        a_nparam;	/* # of parameters */
    char        a_dflt[NPARAM];	/* Default value flags */
    short       a_param[NPARAM];/* Parameters */
    char        a_nastyf;	/* Error flag */
}           ANSI;

typedef struct {
    int         row;
    int         col;
    unsigned    flags;		/* Vt100 saves graphics rendition. Ugh! */
    char        curgl;
    char        curgr;
    char        gsets[4];
}           SavedCaret;

typedef struct {
    int         respond;	/* socket for responses (position report,
				 * etc.) */
    long        pid;		/* pid of process on far side */
    int         uid;		/* user id of actual person */
    int         gid;		/* group id of actual person */
    int         color;		/* colors used */
    int         foreground;	/* foreground color */
    int         background;	/* Background color */
    int         caretcolor;	/* Cursor color */
    unsigned short send_mouse_pos;	/* user wants mouse transition */
    				/* and position information */
    int         autoraise;	/* auto raise window mode */
    int         timer;		/* timer function */
    int         visualbell;	/* visual bell mode */
    int         textundericon;	/* text under icon */
    int         iconinput;	/* got input while iconified */
    int         active_icon;	/* icon is miniature copy */
    int         deiconwarp;	/* warp mouse on deiconify */
    int         logging;	/* logging mode */
    int         logfd;		/* file descriptor of log */
    char       *logfile;	/* log file name */
    char       *logstart;	/* current start of log buffer */
    int         inhibit;	/* flags for inhibiting changes */
    unsigned int multiscroll;	/* true if multi-scroll */

    /* VT window parameters */
    int         top_marg;	/* top line of scrolling region */
    int         bot_marg;	/* bottom line of  "	    " */
    int         scrollinput;	/* scroll to bottom on input */
    int         scrollkey;	/* scroll to bottom on key */

    unsigned short do_wrap;	/* true if caret in last column and character
				 * just output */
    int         c132;		/* allow change to 132 columns */
    int         curses;		/* cludge-ups for more and vi */
    int         marginbell;	/* true if margin bell on */
    int         nmarginbell;	/* columns from right margin */
    int         bellarmed;	/* caret below bell margin */

    SavedCaret  sc;		/* data for restore caret */
    int         statusline;	/* status line showing */
    int         statusheight;	/* status line height */
    int         instatus;	/* caret in status line */
    SavedCaret  statussc;	/* status line restore caret */
    int         reversestatus;	/* status line reversed */
    char       *winname;	/* name of window (and icons) */
    int         winnamelen;	/* length of window name */
    int         save_modes[19];	/* save dec private modes */
    int         pagemode;	/* true if page mode */
    int         pagecnt;	/* count of lines in page mode */

    /* Improved VT100 emulation stuff. */
    char        gsets[4];	/* G0 through G3. */
    char        curgl;		/* Current GL setting. */
    char        curgr;		/* Current GR setting. */
    char        curss;		/* Current single shift. */
    int         jumpscroll;	/* whether we should jumpscroll */

    int         margin;		/* 0 -> margin 1, 1 -> margin 2 */
}           Screen;

typedef struct {
    unsigned    offset;		/* status of shift, control, meta */
#define SHIFT	0x0001
#define META	0x0002
#define CONTROL	0x0004

    unsigned    flags;
}           Keyboard;

/* define masks for flags */
#define CAPS_LOCK	0x01
#define KYPD_APL	0x02
#define CURSOR_APL	0x04


#define N_MARGINBELL	10
#define MAX_TABS	320
#define TAB_ARRAY_SIZE	10	/* number of ints to provide MAX_TABS bits */

typedef unsigned Tabs[TAB_ARRAY_SIZE];


#define BUF_SIZE 8192

typedef struct {
    Keyboard    keyboard;	/* terminal keyboard */
    Screen      screen;		/* terminal screeen */
    unsigned    flags;		/* mode flags */
    unsigned    initflags;	/* initial mode flags */
    Tabs        tabs;		/* tabstops of the terminal */
}           Terminal;


/* masks for terminal flags */

#define INVERSE		0x01	/* invert the characters to be output */
#define UNDERLINE	0x02	/* true if underlining */
#define BOLD		0x04
#define WRAPAROUND	0x08
#define REVERSE_VIDEO	0x10	/* true if screen white on black */
#define ORIGIN		0x20	/* true if in origin mode */
#define INSERT		0x40	/* true if in insert mode */
#define SMOOTHSCROLL	0x80	/* true if in smooth scroll mode */
#define AUTOREPEAT	0x100	/* true if in autorepeat mode */
#define IN132COLUMNS	0x200	/* true if in 132 column mode */
#define LINEFEED	0x400
#define	REVERSEWRAP	0x800	/* true if reverse wraparound mode */
#define ICONINPUT	0x1000	/* true if mini icon accepts kbd input */

#define	ATTRIBUTES	0x07	/* attributes mask */
#define CHAR		0177

#define Titlebar(screen)	(screen->mappedVwin->titlebar)
#define ActiveIcon(screen)	(screen->active_icon && \
				(screen->mappedVwin == &screen->iconVwin))

/* flags for color */
#define	C_FOREGROUND	0x01
#define	C_BACKGROUND	0x02
#define	C_FBMASK	0x03
#define	C_CURSOR	0x04
#define	C_MOUSE		0x08
#define	C_BORDER	0x10

/* flags for inhibit */
#define	I_LOG		0x01
#define	I_SIGNAL	0x02

#define MAXSCREENWIDTH  2048 /* characters */
#define MAXNUMLINES  1024 
#define SAVELINES  150 
#define SELECTDELAY  65000 
