/*
 * This file is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify this file without charge, but are not authorized to
 * license or distribute it to anyone else except as part of a product
 * or program developed by the user.
 * 
 * THIS FILE IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * This file is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY THIS FILE
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even
 * if Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */

#ifndef lint
static	char sccsid[] = "@(#)input.c 1.2 88/01/18 Copyright 1987 Sun Micro";
#endif

/*
 *	Copyright (c) 1987 by Sun Microsystems, Inc.
 *	Steve Isaac 12/18/87
 *
 */

/* Copyright (c) 1985 Massachusetts Institute of Technology              */
/* Copyright (c) 1985   Digital Equipment Corporation                    */

/* input.c */
 
#include <stdio.h>
#include "ptyx.h"
#include "NeWS.h"
#include "keydefs.h"

static char *kypd_num = "0x.\r123456,789-";
static char *kypd_apl = "pxnMqrstuvlwxym";
static char *cur = "DCBA";


Input(keyboard, screen, keycode)
    register Keyboard *keyboard;
    register Screen *screen;
    register    keycode;
{
    register char *string;
    register int col,
                key = FALSE;
    int         pty = screen->respond;
    int         nbytes;
    ANSI        reply;

    if (keycode < 0400) {
	unparseputc(keycode, pty);
	key = TRUE;
    } else
    {
	/* keycode &= ValueMask; /* no longer need shift bits for anything */
	reply.a_pintro = 0;
	reply.a_final = 0;
	reply.a_nparam = 0;
	reply.a_inters = 0;
	if (IsKeypadKey(keycode)) {
	    if (keyboard->flags & KYPD_APL) {
		reply.a_type = SS3;
		unparseseq(&reply, pty);
		unparseputc(kypd_apl[keycode - KC_KEYPAD_0], pty);
	    }
	    else
		unparseputc(kypd_num[keycode - KC_KEYPAD_0], pty);
	    key = TRUE;
	}
	else if (IsCursorKey(keycode)) {
	    if (keyboard->flags & CURSOR_APL) {
		reply.a_type = SS3;
		unparseseq(&reply, pty);
		unparseputc(cur[keycode - KC_CURSOR_LEFT], pty);
	    }
	    else {
		reply.a_type = CSI;
		reply.a_final = cur[keycode - KC_CURSOR_LEFT];
		unparseseq(&reply, pty);
	    }
	    key = TRUE;
	}
	else if (IsPFKey(keycode)) {
	    reply.a_type = SS3;
	    unparseseq(&reply, pty);
	    unparseputc((char) (keycode - KC_PF1 + 'P'), pty);
	    key = TRUE;
	}
	else if (IsFunctionKey(keycode)) {
	    reply.a_type = CSI;
	    reply.a_nparam = 1;
	    reply.a_param[0] = funcvalue(keycode);
	    reply.a_final = '~';
	    if (reply.a_param[0] > 0)
		unparseseq(&reply, pty);
	    key = TRUE;
	}
    }

    return;
}

funcvalue(keycode)
{
    switch (keycode) {
    case KC_F1:
	return (11);
    case KC_F2:
	return (12);
    case KC_F3:
	return (13);
    case KC_F4:
	return (14);
    case KC_F5:
	return (15);
    case KC_F6:
	return (17);
    case KC_F7:
	return (18);
    case KC_F8:
	return (19);
    case KC_F9:
	return (20);
    case KC_F10:
	return (21);
    case KC_F11:
	return (23);
    case KC_F12:
	return (24);
    case KC_F13:
	return (25);
    case KC_F14:
	return (26);
    case KC_F15:
	return (28);
    case KC_F16:
	return (29);
    case KC_F17:
	return (31);
    case KC_F18:
	return (32);
    case KC_F19:
	return (33);
    case KC_F20:
	return (34);
    case KC_E1:
	return (1);
    case KC_E2:
	return (2);
    case KC_E3:
	return (3);
    case KC_E4:
	return (4);
    case KC_E5:
	return (5);
    case KC_E6:
	return (6);
    default:
	return (-1);
    }
}
