/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 *
 * Ethernet header: manifests, types, structs local to Ethernet code.
 */

#ifndef _ETHERNET
#define _ETHERNET

#include "Vethernet.h"
#include "Venviron.h"

typedef	unsigned short	ushort;
typedef	unsigned char	uchar;
typedef	unsigned int	uint;

/*    Definitions for the Deqna ethernet interface    */

/* parameters */
#ifndef TXLISTLEN
#define TXLISTLEN		1	/* number of transmit buffers */
#endif
#ifndef RXLISTLEN
#define RXLISTLEN		20	/* number of receive buffers */
#endif
#define	QNAWAITTIME		10000	/* a loop of at least 100 microsecs */
#define	ENET_READER_TIMEOUT	(CLICKS_PER_SEC*5) /* Get suspicious if no  */
						   /*  packet read in 5 sec.*/
#define ENET_WRITER_TIMEOUT	(CLICKS_PER_SEC/20)/* Ditto if packet not   */
						   /*  written OK in 50 ms. */

/* Set Up modes */
#define	QNA_AllMultiCast	0x1
#define	QNA_Promiscuous		0x2
#define	QNA_No_LED		0x0
#define	QNA_LED1_out		0x4
#define	QNA_LED2_out		0x8
#define	QNA_LED3_out		0xc
#define	QNA_SanityValue(lognumsecs)	(lognumsecs*0x10)

/* Descriptor status expressed as a complete int */
#define QNA_BDLLastNoErr	(0<<14)
#define QNA_BDLLastErr		(1<<14)
#define QNA_BDLUnused		(2<<14)
#define QNA_BDLUsing		(3<<14)

/* Defines to mask out bits in the Control and Status Register */
#define	QNARCVENABLE	0x0001		/* Receiver Enable */
#define	QNARESET	0x0002		/* Reset */
#define	QNANXMINT	0x0004		/* Nonexistent memory interrupt */
#define	QNABOOTROM	0x0008		/* Boot diagnostic ROM */
#define	QNATXBDLBAD	0x0010		/* Transmit List invalid */
#define	QNARXBDLBAD	0x0020		/* Receive List invalid */
#define	QNAINTENABLE	0x0040		/* Interrupt enable */
#define	QNAXMTINT	0x0080		/* Transmit Interrupt Request */
#define	QNAILOOP	0x0100		/* NOT Internal Loopback */
#define	QNAELOOP	0x0200		/* External Loopback */
#define	QNATIMERENABLE	0x0400		/* Sanity Timer interrupt enable */
#define	QNAFUSEOK	0x1000		/* Power is being supplied */
#define	QNACARRIER	0x2000		/* carrier sense signal */
#define	QNARCVINT	0x8000		/* Recieve Interrupt Request */

#define ENETADDRLEN	6


/*
 * Pointers to all the Deqna registers.  The (read-only) address registers
 *   live at base + 0, 2, 4, 6, 8, 10, and overlap with the (write-only)
 *   Rx and Tx BDL registers at base + 4, 6, 8, 10.  The (read-write) vector
 *   and csr registers come last, at base+12 and base+14 respectively.
 * DEQNA_BASE_ADDRESS and MANGLE_ADDRESS should be defined elsewhere (the
 *   latter defaults to the identity function; the former must be supplied).
 * MANGLE_ADDRESS is defined differently for the 680x0-based version of the
 *   Firefly (which is responsible for all this mucking around); there, we
 *   have to scramble the bits in the address.
 */

#ifndef MANGLE_ADDRESS
#define MANGLE_ADDRESS(x) (x)
#endif

#define REG_ADDR(x) ((ushort *) MANGLE_ADDRESS(DEQNA_BASE_ADDRESS+(x)))
	/* We have a separate pointer to each DEQNA register.  It's */
	/*   pretty silly in general, but works well with the       */
	/*   address-mangling hardware on the 680x0-based Firefly.  */
#define Deqna_enet_addr(i)	REG_ADDR((i)<<1)	/* 0 <= i <= 5 */
#define Deqna_rxBDLlo		REG_ADDR( 4)
#define Deqna_rxBDLhi		REG_ADDR( 6)
#define Deqna_txBDLlo		REG_ADDR( 8)
#define Deqna_txBDLhi		REG_ADDR(10)
#define Deqna_vector		REG_ADDR(12)
#define Deqna_csr		REG_ADDR(14)

#define QNA_TX1_COUNTpos	4
#define QNA_TX1_COUNTmask	0x00F0
#define QNA_TX1_FAIL		0x0100
#define QNA_TX1_ABORT		0x0200
#define QNA_TX1_STE16		0x0400
#define QNA_TX1_NOCAR		0x0800
#define QNA_TX1_LOSS		0x1000
#define QNA_TX1_USEmask		0xC000
#define QNA_TX1_USEpos		14

#define QNA_TX2_TDRpos		0
#define QNA_TX2_TDRmask		0x3FFF

#define QNA_RX1_OVF		0x0001	/* overflow */
#define QNA_RX1_CRCERR		0x0002	/* crc error */
#define QNA_RX1_FRAME		0x0004  /* framing error */
#define QNA_RX1_tooshort	0x0008	/* Where did Jay get this from? */
					/* Not in DEQNA Users Guide     */
#define QNA_RX1_RBLHIpos	8	/* RBL<10:8>, i.e. bits 10 to 8 */
#define QNA_RX1_RBLHImask	0x0700	/*   of Rx message length - 60  */
#define QNA_RX1_RUNT		0x0800	/* runt message */
#define QNA_RX1_DISCARD		0x1000	/* packet discarded */
#define QNA_RX1_ESETUP		0x2000	/* eloop/setup packet */
#define QNA_RX1_USEmask		0xC000	/* LASTNOT and ERROR/USED bits */
#define QNA_RX1_USEpos		14

#define QNA_RX2_RBLLOpos	0
#define QNA_RX2_RBLLOmask	0x00FF
#define QNA_RX2_RBL2pos		8	/* DEQNA writes two copies of */
#define QNA_RX2_RBL2mask	0xFF00	/*   RBL<7:0> in QNA_RX2      */

/*
*	the type of a Buffer Descriptor.
*	These tell the DEQNA where to put packets.
*/
typedef struct
  {
    ushort	bd1;	/* QNA_BD1_xxx constants */
    ushort	bd2;	/* QNA_BD2_xxx constants */
    ushort	addrlo;	/* low order address bits */
    ushort	size;	/* the size of this buffer */
    ushort	status1;/* QNA_TX1_xxx or QNA_RX1_xxx constants */
    ushort	status2;/* QNA_TX2_xxx or QNA_RX2_xxx constants */
} QNABD_t;

#define QNA_BD1_FLAGpos		14
#define QNA_BD1_FLAGmask	0xC000

#define QNA_BD2_ADDRHIpos	0
#define QNA_BD2_ADDRHImask	0x003F
#define QNA_BD2_HBOSTART	0x0040
#define QNA_BD2_LBOEND		0x0080
#define QNA_BD2_SETUP		0x1000
#define QNA_BD2_ENDOFMSG	0x2000
#define	QNA_BD2_CHAIN		0x4000
#define QNA_BD2_VALID		0x8000

/*
*	the deqna data structure
*/
typedef struct {
	QNABD_t		txlist[TXLISTLEN+1];
	QNABD_t		rxlist[RXLISTLEN+1];
	Enet10Packet	txbuff;
	Enet10Packet	rxbuff[RXLISTLEN];
	uchar		setupbuff[16][8];
} Qna_t;

#undef ushort
#undef uchar
#undef uint

#endif _ETHERNET
