/*
 *  Description of the boot parameters that the various Vaxen use.
 *
 *  Of course we ignore most of this stuff, but it was fun typing it up.
 */


#ifdef MICROVAX

/*
 *  Goodies for Microvax are culled from section 3.5.2 of:
 *     Software Specification for KA630-A Console Program, revision 2.2,
 *     Digital Equipment Corporation, 1983 (Company confidential!).
 *  Unfortunately, there are differences between that document and reality,
 *  where reality is defined as the results of examining registers and memory
 *  on 10-Dec-1985.  So, the information below is massaged to correspond to
 *  what we believe reality is.
 *
 *  Essentially, the 64K ROM in a MicroVAX II contains the Monitor and VMB
 *  (DEC's funny name for the primary bootstrap).  When asked to boot, the
 *  monitor finds 64K of good RAM (it seems to choose locations 0000-FFFF),
 *  copies VMB into it (starting at an offset of 200???), and then jumps
 *  to VMB.  VMB builds a System Control Block and an extended Restart
 *  Parameter Block.  Contrary to the documentation, it does not appear to
 *  build a Page Frame Number bitmap, just uses the one built by the Monitor.
 *  It then chooses a device from which to boot - the DEQNA in our case - 
 *  executes the bootstrap driver for that device, and then jumps to whatever
 *  it has just loaded (the "secondary bootstrap" - Vload in our case),
 *  passing it some magic addresses in registers (see SecondBootInfo below).
 *
 *  Memory layout:
 *	r11     --> Extrended RPB (r11 = 00000000)
 *	r11+200 --> VMB ??
 *	scbb    --> System Control Block (1K, scbb = 00003a00)
 *		    Stack for secondary bootstrap (1.5K, ends at 00004400)
 *	sp      --> *** Gap from 00004400-00004BFF, mainly zero ***
 *      00004C00:   Secondary bootstrap (assuming the load offsets in the MOP
 *		    packets start at 0, which is what mvaxbootserver does)
 */

typedef struct restartParamBlock	/* Extended RPB built by VMB */
  {
    char *rpb;		/* Pointer to itself */
    long zero[3];	/* In a real RPB that the monitor will actually   */
			/* recognize, these would be: physical address of */
			/* the restart routine, checksum of first 31 longs*/
			/* and software restart in progress flag (??)     */
			/* ------------- basic RPB ends here -------------*/

    char *pc;		/* PC  at last restart/halt */
    char *psl;		/* PSL  "		"   */
    long reason;	/* Reason (number) for halt, generated by */
			/*   MicroVAX II chip or by Monitor	  */
    long savedregs[6];	/* Values passed from Monitor to VMB in r0-r5:	    */
			/*   r0 = ASCII device name (from BOOT command) or 0*/
			/*   r1 = Contents of Boot & Diagnostic Register    */
			/*   r2 = Size (bytes) of Monitor's memory bitmap   */
			/*   r3 = address      "                      "	    */
			/*   r4 - unused				    */
			/*   r5 = Flags from BOOT command (we do use these) */
    long reserved1[2];
    long diskaddr;	/* Probably doesn't mean anything for DEQNA boot    */
    long bootsize;	/* Size (blocks) of secondary bootstrap ????	    */
    long pfnbitmap[2];	/* Size and Address of PFN bitmap.  Since, contrary */
			/* to the documentation, VMB doesn't build a bitmap,*/
			/* these are just copies of the values passed from  */
			/* the Monitor to VMB (see above) in r2-r3.	    */
    long pagecount;	/* "number of good physical pages".  Experimentation*/
			/* suggests that this counts pages excluding those  */
			/* that the monitor wants for private data or for   */
			/* the bitmap					    */
    long reserved2;
    char *bootcsr;	/* physical address of CSR of boot device (DEQNA)   */
    long reserved3[4];
    char bootfile[40];	/* Boot filename.  Meaningless for DEQNA?	    */
    long reserved4[8];
    char *scb;		/* Pointer to the SCB that VMB built		    */
  } RestartParamBlock;

typedef struct secondBootArgs	/* Parameters for secondary bootstrap */
  {
    long argSize;		/* Hexadecimal 15, though documentation */
				/*   says decimal 12.			*/
    long reserved1[2];
    long lowestValidPFN;	/* Yet more (largely redundant)	info about  */
    long highestValidPFN;	/*   the Page Frame Number bitmap.  It seems*/
    long PFN_MapBytes;		/*   highestValidPFN is the last page used  */
    char *PFN_MapAddr;		/*   by the monitor, not the last page      */
				/*   before the bitmap and monitor data.    */
    long reserved2[3];
    long processorID;		/* 8 (or 08XXXXXX ?) for MicroVAX II ?? */
				/* Actually, seems to be zero.		*/
    long reserved3[2];
				/* ----- Documentation stops here ----- */
    long reserved4[9];		/* Dunno what these do; all appear zero.*/
  } SecondBootArgs;

typedef struct secondBootInfo	/* What VMB actually passes in registers  */
				/*   to the secondary bootstrap.  We just */
				/*   use this fake structure as a mnemonic*/
  {
    RestartParamBlock	*r11_extended_RPB;	/* r11 -> RestartParamBlock */
    SecondBootArgs	*ap_SecondBootArgs;	/*  ap -> SecondBootArgs    */
    char		*sp_SecondBootAddr;	/*  sp -> end of 1.5K stack.*/
    char		*scbb_VMB_SCB;		/* scbb-> VMB's SCB	    */
  } SecondBootInfo;

#endif MICROVAX
