/*
 * V-System Storage Server
 * CopyRight (c) 1981 David Cheriton, all rights reserved.
 * transliterated from Verex and Zed. May 1983.
 */

#ifndef VSTORAGE
#define VSTORAGE
#include "Venviron.h"

/* name request format must be compatible with CreateInstanceReq */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode      requestcode;
    short unsigned  filenameindex; /* First byte of filename to use */
#else LITTLE_ENDIAN
    short unsigned  filenameindex; /* First byte of filename to use */
    SystemCode      requestcode;
#endif LITTLE_ENDIAN
    unsigned        arg1;          /* Server-dependent */
    unsigned        arg2;
    char            *str;          
    unsigned        *ptrarg;       
    ContextId       contextid;     /* Context used to interpret name */
    char            *filename;     
    unsigned        filenamelen;
  } FSRequest;


typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode      replycode;
    short unsigned  filler;
#else LITTLE_ENDIAN
    short unsigned  filler;
    SystemCode      replycode;
#endif LITTLE_ENDIAN
    ProcessId       FSioprocess;
    unsigned        FSblocksize;
    unsigned        FSfdnumber;
    unsigned        *FSdev;
  } FSReply;


/* Query Storage reply message format. Request format uses the IoRequest
 * struct with only the request code (QUERY_FILE or QUERY_STORAGE_STATS)
 * and file instance fields significant.
 */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode      replycode;
    short unsigned  filler;
#else LITTLE_ENDIAN
    short unsigned  filler;
    SystemCode      replycode;
#endif LITTLE_ENDIAN
    unsigned        NumReads;
    unsigned        NumWrites;
    unsigned        NumFDReads;              	/* reads to file desc. file */
    unsigned        AverageReadLength;
    unsigned        AverageWriteLength;
    unsigned        CylindersPerIO;  		/* cylinders seeked per I/O */
    double          BufferHitRate;
  } QueryStorageReply;


/* File permissions -  Note: a file can contain data as well as provide a
 *  context from which other files can be accessed (i.e. act like a directory).
 *  Also, the below 5 attributes apply to the owner's permissions.  To get group
 *  permissions, one must shift right 5 bits and to get 'other' permissions,
 *  one must shift right another 5 bits.
 */
#define SS_MODIFY    0x0001   /* directory attribute */
#define SS_LIST      0x0002   /*         "           */
#define SS_EXECUTE   0x0004   /*   file attribute    */
#define SS_WRITE     0x0008   /*         "           */
#define SS_READ      0x0010   /*         "           */
#define SS_DIR       0x8000   /* specifies if file has any sons */

#define SS_NORM_PERM 0x4a5b   /* all but execute for owner; read and list */
                              /*  for group and others */ 

/* Used by MODIFY_FILE request */
#define RESET_FILE_PERM   0
#define SET_FILE_PERM     1
#define CHANGE_OWNER      2
#define SET_FILE_TYPE     3
#define SET_FILE_VERSION  4

#endif VSTORAGE
