/* Processor-dependent definitions and typedefs. */

#ifndef VPROCESSOR
#define VPROCESSOR

/* Team origin address (lowest valid address in team space) */
#define TEAM_ORIGIN	0x0

/* Processor State as stored in the process descriptor */
typedef struct
  {
	/* Machine dependent fields */
	Unspec		regs[15];	/* r0 - r14 general registers */
	Unspec		pc;		/* must be in this order -- the
					 * pc sometimes gets referenced as
					 * regs[15]. */
	Unspec		PSL;		/* processor status long word */

	/* Machine independent fields */
        Unspec	*perProcess;	 /* Pointer to per process area */
        Unspec	**perProcessLoc; /* perProcess pointer stored at
				  * this address on a process switch */
  } Processor_state;
 
#define ByteSwapProcessor_state(ps) do { \
    ByteSwapLongInPlace(&((ps)->regs[0]), 19*sizeof(long)); \
  } while (0)

#define USER_STACK_POINTER regs[14]		/* User Stack pointer */

/* values of AstLevel field of PCB */
#define KERNEL_AST	0	/* Kernel has AST pending */
#define EXEC_AST	1	/* Executive " */
#define SUPER_AST	2	/* Supervisor " */
#define USER_AST	3	/* User " */
#define	NO_AST_PENDING	4	/* No Ast is pending */

/* Access mode masks */
#define	PSL_CURMOD	0x03000000
#define PSL_KERNEL	0x0
#define	PSL_EXEC	0x01000000
#define	PSL_SUPER	0x02000000
#define	PSL_USER	0x03000000
#define	PSL_IS		0x04000000

#endif VPROCESSOR
