/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * FILE: Vgts.h
 *
 * This file contains all the public definitions which pertain to the 
 * SUN Virtual Graphics Terminal Service package.
 */

#ifndef _VGTS_H
#define _VGTS_H

/*
 * General definitions
 */

typedef unsigned char BOOLEAN;
#define TRUE 1
#define FALSE 0

#define ERROR -1
#define NIL 0

#ifndef NULL
#define NULL	0
#endif  NULL

#define max(A,B) ((A) > (B) ? (A) : (B))
#define min(A,B) ((A) < (B) ? (A) : (B))

/*
 * Types of items in the sdf
 */

#define SDF_SYMBOL_CALL 1
#define SDF_SYMBOL_DEF 2
#define SDF_FILLED_RECTANGLE 3
#define SDF_HORIZONTAL_LINE 4
#define SDF_VERTICAL_LINE 5
#define SDF_POINT 6
#define SDF_SIMPLE_TEXT 7
#define SDF_GENERAL_LINE 8
#define SDF_OUTLINE 9		
#define SDF_HORIZONTAL_REF 10	
#define SDF_VERTICAL_REF 11	
#define SDF_SEL_HORIZ_REF 12	
#define SDF_SEL_VERT_REF 13
#define SDF_TEXT 14
#define SDF_RASTER 15
#define SDF_SPLINE 16

#define SDF_POLYMARKER 17
#define SDF_POLYLINE 18
#define SDF_FILL_AREA 19
#define SDF_CIRCLE 20
#define SDF_FILL_CIRCLE 21
#define SDF_POLYARC 22
#define SDF_FILL_POLYARC 23

#define SDF_FILL_PATTERN 30
#define SDF_FILL_AREA_OPACITY 31
#define SDF_FILL_BORDER_STYLE 32
#define SDF_FILL_AREA_COLOR 33
#define SDF_MARKER_TYPE 34
#define SDF_MARKER_COLOR 35
#define SDF_POLYLINE_COLOR 36
#define SDF_TEXT_COLOR 37
#define SDF_FONT_INDEX 38
#define SDF_COLOR 39

/* change this if you add any more attributes */
#define SDF_MAX_ATTRIBUTE 39

  /*
   * Maximum Coordinate value for SDF Items
   */

#define MaxCoord 32767	

/*
 * This bits go into type data field for Outline items
 */

#define LeftEdge 1
#define RightEdge 2
#define TopEdge 4
#define BottomEdge 8

#define AllEdges (LeftEdge+RightEdge+TopEdge+BottomEdge)


/*
 * values of type data field for Filled Rectangles
 */
#define NM 0	/* Metal */
#define NP 1	/* PolySilicon */
#define ND 2	/* Diffusion */
#define NI 3	/* Ion Implant */
#define NC 4	/* contact cut */
#define NB 5	/* Burried contact */
#define NG 6	/* OverGlass cut */
#define NDP 7	/* What are these??? - WIN */
#define NMP 8
#define NDM 9
#define ZZ 10
#define BLACK 11	/* solid black */
#define GRAY 12		/* half-tone gray */
#define HILIGHT 13	/* unselectable highlights */

/*
 * Use the following offset to use the more general pattern definitions
 * with filled rectangles.
 */

#define STIPPLE_OFFSET 14 

/*
 * bits for graphics input buttons
 */

#define LeftButton 1
#define MiddleButton 4
#define RightButton 2

/* VGT usage-type bits */

#define UNUSED 0		/* initial value */
#define GRAPHICS 1		/* normal graphics display */
#define TTY 2			/* allow pad operations */
#define ZOOMABLE 4		/* Allow users to zoom it */

typedef struct
	/* Descriptor for a popup menu display entry. */
    {
    char *string;		/* String to display. */
    unsigned char menuNumber;	/* Number returned if entry selected. */
    } PopUpEntry;


/***** mouse stuff ********/

typedef struct MinElement
  {
    short		      item;	/* an sdf item name */
    short		      edgeset;	/* for rectangles only -- TRD */
    struct MinElement        *next;
  } MINREC, *MINPTR;

typedef struct ListInfo
  {
    MINPTR            Header;
    short             NumOfElements;
  } LISTTYPE;

/********** Search Types ***************/

#define All         0
#define AllLines    1
#define JustHoriz   2
#define JustVerts   3
#define JustRects   4
#define JustSymbols 5
#define JustText    6
#define JustRefPt   7
#define JustSplines 8
#define JustRasters 9
#define JustTheRest 999   /* Other stuff uses only the bounding box for now */ 

/*
 * Message types for linked-together programs.
 * Warning: Clients should not depend on these!
 */

typedef struct EventMsg
  {
  	/*
	 * Message format for event requests
	 * and replies
	 */
#ifndef LITTLE_ENDIAN
    short 	requestcode;
    short 	fileid;
    short 	eventcode;
    short 	x;
    short 	y;
    short	buttons;
#else LITTLE_ENDIAN
    short 	fileid;
    short 	requestcode;
    short 	x;
    short 	eventcode;
    short	buttons;
    short 	y;
#endif LITTLE_ENDIAN
    short 	padding[10];
  } 
    EventReq;


/* ModifyPad bits unique to the vgts */

/** CAUTION!!  Must not overlap with ModifyPad bits in Vtermagent.h!! */

# define ReportClick 16		/* report clicks for graphics events */
# define ReportTransition 32	/* report all transitions on buttons */
# define ReportEscSeq 64	/* use "Emacs hack" escape sequences */
# define NoCursor 128		/* no cursor in this pad */
# define ReportMotion 256	/* report any kind of motion */
# define ReportCharacter 512	/* report character events */
# define ReportEditedText 1024	/* report edited-text events */

/*
 * note that ReportClick and ReportTransition, being mode bits on a VGT,
 * are also members of the set:
 * { ReportCharacter, ReportClick, ReportTransition }
 * of event codes.
 */

# define PadWidth 80		/* default columns in a pad */
# define PadHeight 28	
				/* default size of TTY views */
# define ViewWidth(columns) ( (columns+1)*8+10)
# define ViewHeight(lines) (lines*16+24)


# define EditReturnIfEmpty		1
# define EditAllowPastBackLimit		2
# define EditInsertBreakChar		4
# define EditBreakPastBackLimit		8
# define EditBreakAtBackLimit		16
# define EditBreakOnPunctuation		32
# define EditBreakOnEOL			64
# define EditGotBreakChar		128
# define EditInputAbortSignal		256
# define EditOperationAbortSignal	512
# define EditEOFSignal			1024


/* A Polyline data block is an array of SdfPoint */
typedef struct { short x, y; }  SdfPoint;

/* Range limits for attribute indices */
#define MAX_FILL_PATTERN_INDEX	64
#define MAX_MARKER_TYPE_INDEX 40
#define MAX_FONT_INDEX 20

#endif _VGTS_H
