/* (New) Standard internal bitmap and font format.
 * Per Bothner, April 1985.
 * Still not 100% finalized; concact me of you use this file.
 */

#ifndef _VFONT
#define _VFONT
#include "Qtypes.h"

#include <coordinates.h>

#define u_char unsigned char
#define u_short unsigned short
typedef u_char BitUnit;		/* a BitUnit is the "primitive" bitstring */
typedef u_short BitWord;	/* minimum bitstring allocation unit */
#define BitUnitLog 3		/* log2 of length of BitUnit in bits */
#define BitUnitLen (1<<BitUnitLog) /* # of bits in a BitUnit */
#define BitAlignLog 1		/* log2 of BitWord/BitUnit ratio */
#define BitAlign (1<<BitAlignLog) /* # of BitUnits to a BitWord */
#define BitWordLen (BitUnitLen*BitAlign) /* # of bits in a BitWord */
#define BitWordLog (BitUnitLog+BitAlignLog) /* log2 of BitWordLen */
#define BitWordOnes 0xFFFF	/* a BitWord full of ones */

/* LeftZeros(n) is a BitWord with the leftmost n bits 0, and the rest 1 */
#ifdef LITTLE_ENDIAN
#define LeftZeros(n) (BitWordOnes << (n))
#else BIG_ENDIAN
#define LeftZeros(n) (BitWordOnes >> (n))
#endif

/*
 * A Vfont has FontPrefix (which describes general information about the
 * font) followed by an array of 256 pointer to character descriptors.
 * NOTE that the address of a Vfont is the address of the \Array/,
 * which is why the descriptor is called a Font\Prefix/.
 */

typedef struct FontPrefix
  {
    Vector originAll;	/* max(origin) over all chars */
    Vector bBoxAll;	/* bounding box if all chars were superimposed */
    long *TFMwidth;	/* if non-NULL: table of TFMwidths */
    ScaledVector resolution;	/* resolution in pixles/point (scaled) */
    u_char minChar, maxChar;
    long designSize;	/* in points * 2**20 */
    HeapPrefix type;	/* optional pointer to type descriptor */
  };


typedef union Vfont
  {
    struct FontPrefix g;
    struct CharPrefix *(c[256]);
    BitUnit *(r[256]);	/* pointer to actual rasters */
  } Vfont;

#define FontPrefixOf(vf) (&(vf)->g - 1)
/* Thus if vf is Vfont*, you can access minChar as FontPrefixOf(vf)->minChar */

#define BitOffset(r) ((r)[-1].xoffset & (BitWordLen-1))
/* Note:
 * 'start' must be aligned on an BitWord boundary.
 * The actual first bit is BitOffset(r) bits to the right.
 */

typedef struct CharPrefix
  {
    /* short ascent = height above baseline = origin.v */
    Vector origin;		/* origin relative to bounding box top left */
    ScaledVector width;		/* displacement vector */
    BitUnit *start;		/* pointer to first word */
    short xoffset;		/* distance from HeadRaster left edge */
    u_short stride;		/* in terms of BitUnit units */
    Vector bBox;		/* size of bounding box in pixels */
    __optionField
    HeapPrefix type;	/* optional pointer to type descriptor */
  } VRaster, CharPrefix;

/* Options: */
#define RasterOneDim 1		/* Raster is one dimensional line */
#define RasterZeroDim 2		/* Raster is zero dimensional point */
#define RasterInverse 4		/* 0 is black, instead of the normal 1 */
#define RasterLinked 8		/* see below */
#define RasterListHead 16
#define RasterSun100 32		/* sun-100 column order */

/* Options to ReadGenericFont etc */
#define FontSun100 1

#define NextRaster(r) *(VRaster**)(r)

/* Linked rasters:
 * If (the start field of) multiple VRasters might point to the same
 * bitmap, it is possible to link them together in a circular list,
 * so that buffer can be properly freed. The link is stored \after/
 * the CharPrefix, as assumed by the NextRaster macro.
 * In that case the reference count is one for each external reference, plus
 * one for being in the list. The VRaster with the RasterListHead bit
 * 'owns' the whole bitmap.
 *
 * Freeing a VRaster:
 * If a reference count goes to one, the VRaster should be unlinked, unless the
 * RasterListHead bit is on. In the latter case, we have to wait until
 * there are no other list elements.
 */

#define AllocFailure 0
#endif _VFONT
