/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * remote.h - private  definitions for stubs and
 *	      interpreter of VGTS escape sequences
 *
 * Bill Nowicki September 1982
 */

enum VgtsRequest
  {
    VgtsCreateSDF,
    VgtsDeleteSDF,
    VgtsDefineSymbol,
    VgtsEndSymbol,
    VgtsAddItem,
    VgtsAddCall,
    VgtsDeleteItem,
    VgtsInquireItem,
    VgtsInquireCall,
    VgtsChangeItem,
    VgtsEditSymbol,
    VgtsDeleteSymbol,
    VgtsCreateVGT,
    VgtsDeleteVGT,
    VgtsDisplayItem,
    VgtsCreateView,
    VgtsGetMouseClick,
    VgtsFindSelectedObject,
    VgtsPopup,
    VgtsDefineFont,
    VgtsSetMode,
    VgtsDefaultView,
    VgtsNewDefineSymbol,
    VgtsNewEndSymbol,
    VgtsNewEditSymbol,
    VgtsNewDisplayItem
  };

# define VgtsMaxCode VgtsNewDisplayItem	/* highest code */

# define InterpEscape 037	/* VGTS interpreter escape char */

# define SIXTEEN 0xFFFF		/* sixteen bits of all ones */
# define MAGIC4 255		/* means there are four bytes */

