/* NEC PD7201 Double UART chip */

/* The 7201 has two (almost identical) channels.  The following definitions
	apply to registers for either channel
*/

/* Status Register  (READ REGISTER 0) */
#define NECrxrdy	1
#define NECtxrdy	4
#define NECdcd		0x08
#define NECsync		0x10
#define	NECbreak	0x80

/* WRITE REGISTER 0 */
#define NECptres(a)	(char)(NECrexst|a)
				/* Select register to be written and
				 * reset external/status interrupts */
#define	NECselreg(a)	(a)	/* select register 0-7 */
#define NECchres	0x18	/* Channel Reset */
#define NECtxres	0x28	/* Tx interrupt Reset */
#define NECrexst	0x10	/* Reset external/status interrupts */

/* WRITE REGISTER 1 */
#define NECtxint	2	/* Tx interrupt enable */
#define NECrxina	0x18	/* Rx interrupt enable on all characters */

/* WRITE REGISTER 3 */
#define NECrxena	1	/* Rx enable */
#define NECautoe	0x20	/* Auto enables */
#define NECrx8bt	0xC0	/* Rx 8 bit characters */

/* WRITE REGISTER 4 */
#define NECrx1sb	4	/* Rx 1 stop bit */
#define NEC16clk	0x40	/* 16x clock mode */

/* WRITE REGISTER 5 */
#define NECtxrts 	2	/* RTS */
#define NECtxena	8	/* Tx enable */
#define NECtx8bt	0x60	/* Tx 8 bit characters */
#define NECdtr		0x80	/* Data Terminal Ready */
#define	NECsndbrk	0x10	/* send "break" on Tx */
